pro hydra_fv_import, filename, status=status
   message, 'Importing old list file...', /cont
   common hydra_fv_common, $
     fve_header0, fve_data0, fve_input_global0, $
     fvi_header0, fvi_data0, fvi_input_global0
   restore, file= filename
   if n_elements( fve_data ) eq 0 then begin
       status='structure_conflict'
       return
   endif
   hydra_fv_listman, /reset, species=0
   hydra_fv_listman, /reset, species=1
   t= tag_names( fve_header )

;   copy headers
   for i=0,n_elements(t)-1 do begin 
       str= 'fve_header0.'+t(i)+'=fve_header.'+t(i)
       r= execute(str)
   endfor
   
   for i=0,n_elements(t)-1 do begin 
       str= 'fvi_header0.'+t(i)+'=fvi_header.'+t(i)
       r= execute(str)
   endfor
   
;   copy data
   print, 'importing input structures...', format='(a,$)'
   fve_data0= replicate( fve_data0, n_elements( fve_data ) )
   for j=0,n_elements(fve_data)-1 do begin
       print, '.', format='(a,$)'
       fve_data0(j).time= fve_data(j).time
       fve_data0(j).handle= fve_data(j).handle
       fve_data0(j).species= fve_data(j).species
       fve_data0(j).reload= fve_data(j).reload
       new= fpitch_import( fve_data0(j).fv_input, fve_data(j).fv_input )
       fve_data0(j).fv_input= new
   endfor

;   copy data
   fvi_data0= replicate( fvi_data0, n_elements( fvi_data ) )
   for j=0,n_elements(fvi_data)-1 do begin
       print, '.', format='(a,$)'
       fvi_data0(j).time= fvi_data(j).time
       fvi_data0(j).handle= fvi_data(j).handle
       fvi_data0(j).species= fvi_data(j).species
       fvi_data0(j).reload= fvi_data(j).reload
       new= fpitch_import ( fvi_data0(j).fv_input, fvi_data(j).fv_input )
       fvi_data0(j).fv_input= new
   endfor
   message, 'All done!', /cont
   status='success'
end

pro hydra_fv_load, filename, status=status
  common hydra_fv_common, $
    fve_header0, fve_data0, fve_input_global0, $
    fvi_header0, fvi_data0, fvi_input_global0
  restore, file= filename
  if tag_names( fve_header, /structure_name ) ne $
    'FV_HEADER_STRUCT_1_12' then begin
      hydra_fv_import, filename, status=status
  endif else begin
      if n_elements( fve_header ) gt 0 then fve_header0=fve_header
      if n_elements(fve_data0) gt 0 then fve_data0=fve_data 
      if n_elements(fve_input_global0) gt 0 then $
        fve_input_global0=fve_input_global
      if n_elements(fvi_header) gt 0 then fvi_header0=fvi_header
      if n_elements(fvi_data) gt 0 then fvi_data0=fvi_data
      if n_elements(fvi_input_global) gt 0 then $
        fvi_input_global0=fvi_input_global
      status='success'
  endelse
end
