pro hydra_ppa_jbf_draw, date, tmid, zrange=zrange, nsub=nsub, buff=buff, $
                        dt=dt_out, _extra=e, control=control, output=output

;+
;  pro hydra_ppa_jbf_draw, date, tmid, zrange=zrange, nsub=nsub
;  date is input YYYYMMDD, a long.
;  tmid is input seconds since midnight
;  zrange is [z1,z2] always zlog=1
;  nsub is particians to divide the block into, 1, 2, or 4.
;  dt outputs the length of a ppa "block" in the displayed mode.
;  control must be used for input. 4/21/97
;-
   if n_params() eq 0 and n_elements( control ) eq 0 then begin
       doc_library, 'hydra_ppa_jbf'
       return
   endif

   if n_elements( control ) gt 0 then begin
       date= control.date
       tmid= control.time
       nsub= control.nsub
       zrange= control.zrange
       yrange= control.yrange
       backsub= control.backsub       
   endif else begin
       backsub=0
   endelse

   if n_elements( nsub ) eq 0 then nsub=1
   if n_elements( zrange ) eq 0 then zrange=[0.1,10]
   if n_elements( buff ) eq 0 then begin
       buff=[0.,0.]
       buff(0)= (tmid-300.) > 0 
       buff(1)= (tmid+300.) < 86400 ; load ten minutes
   endif

   common hydra_ppa_jbf_buf, buf_timerange, buf_date, $
     buf_counts, buf_time, buf_dt, ppa_info, buf_nsub

   if n_elements( buf_timerange ) ne 0 then begin
       if buf_date eq date and $
         buf_timerange(0) le tmid and $
         buf_timerange(1) ge tmid then begin
           isloaded=1
       endif else begin
           isloaded=0
       endelse
   endif else isloaded=0
   if control.reload then isloaded=0
   
   if not isloaded then begin
       init_ppa_l1, date, ppa_info, status=status
       if status eq 0 then begin
           erase
           xyouts, .5, .6, 'PPA Level One file!cnot found.', /norm, $
             align=0.5, charsize=2.0
           dt_out=0.
           return
       endif
       
       time_range= ( buff mod 86400 ) / 3600.
       recnum= find_ppa_recnum( time_range, ppa_info )

       read_ppa_l1, recnum, ppa_data, ppa_info
       buf_counts= float( ppa_data.counts )
       
       viewtime= ppa_data.viewtime
       validb= make_array( ppa_info.nbin, value=1 ) # $
         ( ppa_data(*).validb_flag )(*)
       r= where( validb eq 0 )
       if r(0) ne -1 then viewtime( r ) = 0.
       
       rnv= where( viewtime eq 0. )
       rv= where( viewtime gt 0. )
       
       rzero= where( buf_counts eq 0. )
       if rzero(0) ne -1 then buf_counts( rzero ) = 0.1
       
       if rnv(0) ne -1 then buf_counts( rnv ) = 1e-20 
       if rv(0) ne -1 then buf_counts( rv ) = buf_counts( rv ) / viewtime( rv )
       
       buf_time= ppa_data(*).time
       buf_dt= ppa_data(*).dt

       buf_timerange= time_range * 3600.
       buf_date= date

       control.reload=0

; for scphase study
       common phase_study_common, buf_phase, buf_phase_time, $
         buf_phase_spinrate, a1_
       init_level1, date, block_data, mode_info
       time_range_hr= time_range/3600.
       r= where( mode_info.rectime ge time_range(0) and $
                 mode_info.rectime le time_range(1) )
       if r(0) eq -1 then begin
           buf_phase= fltarr(5)
           buf_phase_time= fltarr(5)
       endif else begin
           rec_start= r(0)
           rec_count= r(n_elements(r)-1) - rec_start + 1
           CDF= mode_info.l1stat.rawid
           hyd_cdf_varget, CDF, 'PHASE_START', phase_start, $
             rec_start=rec_start, rec_count=rec_count
           phase_start= reform( rebin( phase_start(*), $
                                       384L*rec_count, /sample ), $
                                384, rec_count )
       
           block_mode= mode_info.mode
       
           hyd_cdf_varget, CDF, 'PHI_OFFSET', phi_offset, $
             rec_start=block_mode-1
           phi_offset= phi_offset # make_array( rec_count, value=1 ) 
           
           sc_phase= phase_start(*) + phi_offset(*) 
           
           hyd_cdf_varget, cdf, 'BLOCK_TIME', block_time, $
             rec_start= rec_start, rec_count=rec_count
           block_time= reform( rebin( block_time(*), $
                                      384L*rec_count, /sample ), $
                               384, rec_count )
           hyd_cdf_varget, CDF, 'TIME_OFFSET', time_offset, $
             rec_start=block_mode-1
           time_offset= time_offset # make_array( rec_count, value=1 )
           
           block_time= ( ( block_time / 1000 ) mod 86400 ) + time_offset
           
           htim= block_time
           rectimes= buf_time

           spin_rate= ( sc_phase(1:100)-sc_phase(0:99) ) / $
             ( htim(1:100) - htim(0:99) )
           s= sort( spin_rate )
           spin_rate= spin_rate(s(50))
           
           n= n_elements( htim ) 
           sc_phase1= sc_phase(0) + ( htim(n-1) - htim(0) ) * spin_rate       
           correction= ( sc_phase(n-1) - sc_phase1 mod (2*!pi) )
           while correction gt 1*!pi do correction = correction - 2*!pi
           while correction lt -1*!pi do correction = correction + 2*!pi
           
           sc_phase(n-1)= sc_phase1 + correction
           
           spin_rate= double( sc_phase(n-1) - sc_phase(0) ) / $
             ( htim(n-1) - htim(0) )
       
           sc_phase= sc_phase(0) + ( rectimes - htim(0) ) * ( spin_rate )
           
           buf_phase= sc_phase
           buf_phase_time= block_time
           buf_phase_spinrate= spin_rate
       endelse    
   endif
       
   r= where( tmid - buf_time ge 0, count ) 
   if count eq 0 then r=0 else r=r(count-1)

;  put out subblock 
   n1= ppa_info.nen     
   isub= fix ( ( ( tmid - buf_time(r)  ) > 0 ) / buf_dt(r) * nsub )
   isub= isub < ( nsub-1 )
   rsub= indgen( n1/nsub ) + isub * ( n1/nsub )
   dt= buf_dt(r)/nsub
   time= buf_time(r) + dt * isub
   energy= ppa_info.energy(rsub)
   counts= buf_counts(ppa_info.ialpha,*,r)
   counts= counts(*,rsub)

   phase= buf_phase(r) + buf_phase_spinrate * dt * isub

   dt_out= buf_dt(r)

   delta_bin= ( !pi / 256 ) / !dtor   

   alpha1= indgen(256) * delta_bin
   alpha2= alpha1 + delta_bin
   alpha= reform ( [ alpha1, alpha2 ], n_elements(alpha1), 2 )

   timestr= hydra_hms( time ) + ' - ' + $
     hydra_hms( time+dt )
   
   s= sort( energy )


;  erase the old title
   polyfill, [0,1,1,0,0],[.95,.95,1,1,.95], color=0, /normal

   !p.position=0
   !p.region=[0,0,0.8,1]
   
   common hydra_setcolors1_common, colors
   if n_elements( colors ) gt 0 then begin
       ctable= colors.colortable
   endif

   ztitle='cps'
   
;  background subtraction
   if backsub or control.signal_to_background then begin
       count_en= total( counts, 1 )
       valid= make_array( size=size(counts), /int, value=1 )
       rnv= where( counts eq 1e-20 )
       if rnv(0) ne -1 then valid(rnv)=0
       N= total( valid, 1 )
       r= where( N ge 1 )
       if r(0) ne -1 then begin
           avg= count_en(r)/N(r)
           background_level= min( avg )
       endif else begin
           background_level= 0.
       endelse
;       help, background_level
       counts= ( counts - background_level ) > 1e-31

       if control.signal_to_background then begin
           counts= ( counts + background_level ) / background_level 
           zrange= [1,10.]
           ztitle='Signal / Background'
       endif
       
       if rnv(0) ne -1 then counts( rnv ) = 1e-20
   endif       

   year= long(buf_date) / 10000
   month= ( long(buf_date) - year ) / 100
   day= long(buf_date) mod 100
   julday= julday( month, day, year )
   output= { $
             energy:energy(s), $
             alpha:alpha, $
             count_rate:counts(*,s), $
             date:date, $       ; YYYYMMDD, long
             time:time, $       ; seconds since midnight
             delta_time:double(dt_out), $ ; seconds
             ztitle:ztitle $
           }
   
   erase
   hydra_plotcolor, counts(*,s), alpha, $
     energy(s), $
     /zlog, zrange=zrange, $
     nodata=1e-20, $
     title='PPA Count Rate '+timestr, $
     ytitle='Energy', xtitle='Pitch Angle', /ylog, yrange=control.yrange, $     
     /xfilled, dy=0.02, _extra=e, /ycenter
     
   !p.region=0
   
   hydra_color_bar, /zlog, zrange=zrange, ztit=ztitle

   position=  [ 0.65, 0.1, 0.75, 0.2 ]
   angles= findgen(21)/20 * !pi * 2
   plot, [-1,1],[-1,1], position=position, xstyle=5, ystyle=5, $
     /noerase, /nodata
;   polyfill, sin(angles), cos(angles), /data, color=!p.background
   oplot,  sin(angles), cos(angles)
   arrow, 0,0, cos( phase ), sin(phase), /data, /solid
   
   return
end


pro hydra_ppa_jbf_control, control, top
   widget_data={ okay_id:0L, $
                 base_id:0L, $
                 date_id:0L, $
                 time_id:0L, $
                 nsub_id:0L, $
                 zrange0_id:0L, $
                 zrange1_id:0L, $
                 yrange0_id:0L, $
                 yrange1_id:0L, $
                 backsub_id:0L, $
                 reload_id:0L, $
                 signal_to_background_id:0L $
               }

   base= widget_base( title='hydra_ppa_jbf_control', /col )
   
   b0= widget_base( base, /row )

   b1= widget_base( b0, /col )
   b2= widget_base( b1, /row )
   l1= widget_label( b2, value='Date:' )   
   widget_data.date_id= widget_text( b2, value=strtrim(control.date,2),  $
                                     ysize=1, xsize=8, /editable, $
                                     uvalue='datetime' )
   b2= widget_base( b1, /row )
   l1= widget_label( b2, value='Time:' )
   widget_data.time_id= widget_text( b2, value=hydra_hms(control.time),  $
                                     ysize=1, xsize=8, /editable, $
                                     uvalue='datetime' )
   s1= [ 'One Subblock', 'Two Subblocks', 'Four Subblocks' ]
   b2= widget_base( b1, /row )
   l= widget_label( b2, value='Partitions:')
   widget_data.nsub_id= widget_droplist( b2, value=s1, uvalue='nsum' )
   nsub_selections=[1,2,4]      ; look for same def elsewhere
   widget_control, widget_data.nsub_id, $
     set_droplist_select= ( where( nsub_selections eq control.nsub ))(0)
   
   b1= widget_base( b0, /col )
   b2= widget_base( b1, /row )  
   l= widget_label( b2, value='Z Range:')   
   widget_data.zrange0_id= $
     widget_text( b2, value=string(control.zrange(0), format='(g8.2)'), $
                  xsize=8, uvalue='zrange', /edit )
   l= widget_label( b2, value='to')      
   widget_data.zrange1_id= $
     widget_text( b2, value=string(control.zrange(1), format='(g8.2)'), $
                  xsize=8, uvalue='zrange', /edit )
   
   b2= widget_base( b1, /row ) 
   l= widget_label( b2, value='Y Range:')   
   widget_data.yrange0_id= $
     widget_text( b2, value=string(control.yrange(0), format='(g8.2)'), $
                  xsize=8, uvalue='yrange', /edit )
   l= widget_label( b2, value='to')      
   widget_data.yrange1_id= $
     widget_text( b2, value=string(control.yrange(1), format='(g8.2)'), $
                  xsize=8, uvalue='yrange', /edit )
   
   b1= widget_base( b1, /column, /nonexclusive )   

   widget_data.backsub_id= widget_button( b1, value='Subtract Background' )
   widget_control, widget_data.backsub_id, $
     set_button= control.backsub, $
     set_uvalue='backsub'+strtrim(control.backsub,2)  

   widget_data.signal_to_background_id= widget_button( b1, value='Signal to Background' )
   widget_control, widget_data.signal_to_background_id, $
     set_button= control.signal_to_background, $
     set_uvalue='signal_to_background'+strtrim(control.signal_to_background,2)  

   widget_data.reload_id= widget_button( b1, value='Reload Data        ' )
   widget_control, widget_data.reload_id, $
     set_button= control.reload, $
     set_uvalue='reload'+strtrim(control.reload,2) 
   
   widget_data.okay_id=  widget_button( base, value='Okay', uval='okay' )
   widget_control, base, set_uvalue=widget_data

   widget_control, /realize, base, xoffset=300, yoffset=300

   event= widget_event(base)
   widget_control, event.id, get_uvalue=uvalue
   while uvalue ne 'okay' do begin
       case uvalue of 
           'datetime': begin
               widget_control, widget_data.date_id, get_value=date
               date= date(0)
               widget_control, widget_data.time_id, get_value=time
               time= time(0)
               if date ne '        ' and time ne '        ' then begin
                   hydra_time_io, date, time
                   control.date= date
                   control.time= time*3600.
               endif
           end
           'zrange': begin
               widget_control, widget_data.zrange0_id, get_value=zrange0
               widget_control, widget_data.zrange1_id, get_value=zrange1
               control.zrange= double( [ zrange0(0), zrange1(0) ] )
           end
           'yrange': begin
               widget_control, widget_data.yrange0_id, get_value=yrange0
               widget_control, widget_data.yrange1_id, get_value=yrange1
               control.yrange= double( [ yrange0(0), yrange1(0) ] )
           end   
           'nsum': begin
               nsub_selections=[1,2,4] 
               control.nsub= nsub_selections(event.index)
           end
           'backsub0': control.backsub=1
           'backsub1': control.backsub=0               
           'reload0': control.reload=1
           'reload1': control.reload=0
           'signal_to_background1': control.signal_to_background=0
           'signal_to_background0': control.signal_to_background=1
           else:
       endcase

;     copy control structure to widgets 
       widget_control, widget_data.time_id, $
         set_value= hydra_hms( control.time )
       if control.date ne 0 then begin
           widget_control, widget_data.date_id, $
             set_value= strtrim( control.date,2 )
       endif
       nsub_selections=[1,2,4]  ; look for same def elsewhere
       widget_control, widget_data.nsub_id, $
         set_droplist_select= ( where( nsub_selections eq control.nsub ))(0)
       widget_control, widget_data.zrange0_id, $
         set_value=string(control.zrange(0), format='(g8.2)')
       widget_control, widget_data.zrange1_id, $
         set_value=string(control.zrange(1), format='(g8.2)')
       widget_control, widget_data.yrange0_id, $
         set_value=string(control.yrange(0), format='(g8.2)')
       widget_control, widget_data.yrange1_id, $
         set_value=string(control.yrange(1), format='(g8.2)')

       widget_control, widget_data.backsub_id, $
         set_button=control.backsub, $
         set_uvalue='backsub'+strtrim(control.backsub,2)

       widget_control, widget_data.signal_to_background_id, $
         set_button=control.signal_to_background, $
         set_uvalue='signal_to_background'+strtrim(control.signal_to_background,2)

       widget_control, widget_data.reload_id, $
         set_button=control.reload, $
         set_uvalue='reload'+strtrim(control.reload,2)
       
       w= widget_event(base)
       widget_control, w.id, get_uvalue=uvalue
       
   endwhile
   widget_control, base, /destroy
end









pro hydra_ppa_jbf_event, event, top=top, uvalue=uvalue

   if n_params() eq 0 then begin

       widget_control, top, get_uvalue=widget_data
       control= widget_data.control

   endif else begin

       top= event.top
       
       widget_control, top, get_uvalue=widget_data
       control= widget_data.control
       
   endelse
   
   if n_elements( uvalue ) gt 0 then begin
       action= uvalue
   endif else begin
       widget_control, event.id, get_uvalue=action
   endelse

   if n_elements( action ) eq 0 then action=''
   case action of
       'prev': begin
           control.time= $
             control.time - widget_data.dt / control.nsub
       end
       'next': begin
           control.time= $
             control.time + widget_data.dt / control.nsub
       end               
       'nsub': begin
           nsub_selections=[1,2,4] ; look for same def elsewhere
           control.nsub= nsub_selections(event.index)
       end
       'control': begin
           hydra_ppa_jbf_control, control
       end               
       'datetime': begin
           widget_control, widget_data.date_id, get_value=date
           date= date(0)
           widget_control, widget_data.time_id, get_value=time
           time= time(0)
           if date ne '        ' and time ne '        ' then begin
               hydra_time_io, date, time
               control.date= long(date)
               control.time= time*3600.                   
           endif
       end
       'quit': begin
           widget_control, top, /destroy
           return
       end
       else:
   endcase

;  copy control structure to widgets 
   widget_control, widget_data.time_id, $
     set_value= hydra_hms( control.time )
   if control.date ne 0 then begin
       widget_control, widget_data.date_id, $
         set_value= strtrim( control.date,2 )
   endif
   nsub_selections=[1,2,4]      ; look for same def elsewhere
   widget_control, widget_data.nsub_id, $
     set_droplist_select= ( where( nsub_selections eq control.nsub ))(0)
   
   if (control.date ne 0) then begin
       wset, widget_data.window
;       catch, err
       err=0
       if err eq 0 then hydra_ppa_jbf_draw, control=control, output=output else begin
           erase
           xyouts, 0.5, 0.6, 'Unidentified error occurred!cin plotting.!c'+!err_string, $
             align=0.5, charsize=2.0, /norm
       endelse
       catch, /cancel
       widget_data.dt= output.delta_time     
       if widget_data.papco then begin
           date_str= strtrim( output.date, 2 )
           time_str= hydra_hms( output.time + output.delta_time/2 )
           striketime= strmid(date_str,4,2)+'/'+$
             strmid(date_str,6,2)+'/'+$
             strmid(date_str,0,4)+' '+$
             time_str
           hydra_strike, striketime
       endif
   endif

   widget_data.control= control
   widget_control, top, set_uvalue=widget_data
   
end









pro hydra_ppa_jbf, date_in, time_in, papco=papco, get_control=get_control

   common hydra_ppa_jbf, widget_id, a1_, a2_, a3_, a4_

;  select color system
   papco= keyword_set(papco)
   if not papco then begin
       hydra_setcolors
   endif else begin
       common hydra_setcolors_common1, c
       c=1
       r= temporary( c )
   endelse
    
   if n_params() gt 0 then begin
       date= date_in & time= time_in
       hydra_time_io, date, time
   endif   

;  definition of control structure and default settings.
   control= { $
              time:double(0), $ ; seconds since midnight
              date:long(0), $   ; YYYYMMDD, a long
              nsub:fix(1), $    ; time resolution
              zrange:double([1e-2,1e1]), $
              yrange:double([1e2,1e4]), $
              backsub:fix(1), $ ; subtract background              
              reload:fix(1), $  ; explicit reload
              signal_to_background:fix(0) $ ; display ratio of count_rate to background
            }
   
   if n_elements( get_control ) gt 0 then begin
       get_control= control
   endif

   r= xregistered('hydra_ppa_jbf') ; raise window
   if r eq 0 then begin
       widget_id=0
       r= temporary(widget_id)
   endif
   if n_elements(widget_id) gt 0 then begin

       widget_control, widget_id, get_uvalue=widget_data
       base1= widget_id

   endif else begin

       widget_data= { $
                      draw_id:long(0), $
                      date_id:long(0), $
                      time_id:long(0), $
                      nsub_id:long(0), $
                      window:long(0), $
                      dt:double(0), $
                      control:control, $
                      papco:keyword_set(papco) $
                    }
       
       base1= widget_base( title='hydra_ppa_slices', /column )
       draw= widget_draw( base1, xsize=500, ysize=500 )
       base2= widget_base( base1, /row )
       
       hydra_icons, icons

       date_id= widget_text( base2, value='        ', /editable, $
                             ysize=1, xsize=8, uvalue='datetime' )
       time_id= widget_text( base2, value='        ', /editable, $
                             ysize=1, xsize=8, uvalue='datetime' )
       b1= widget_button( base2, value=icons.lft_arrow, uvalue='prev' )
       s1= [ 'One Subblock', 'Two Subblocks', 'Four Subblocks' ]
       nsub_id= widget_droplist( base2, value=s1, uvalue='nsub' )
       b1= widget_button( base2, value=icons.rt_arrow, uvalue='next' )
       b1= widget_button( base2, value='Control', uvalue='control' )
       b1= widget_button( base2, value='Quit', uvalue='quit' )
       widget_control, /realize, base1
       
       widget_control, draw, get_value=window
       wset, window

       widget_data.window= window
       widget_data.draw_id= draw
       widget_data.date_id= date_id
       widget_data.time_id= time_id
       widget_data.nsub_id= nsub_id 
       
       widget_control, base1, set_uvalue= widget_data

       widget_id= base1
   endelse

   if n_elements( date ) gt 0 then $
     widget_control, widget_data.date_id, set_value=date
   if n_elements( time ) gt 0 then $   
     widget_control, widget_data.time_id, set_value= hydra_hms( time*3600. )
   
   if n_params() eq 2 then $
     hydra_ppa_jbf_event, top=base1, uvalue='datetime'
   
   xmanager, 'hydra_ppa_jbf', base1
end

