pro hydra_rw_idlsav, read=read, write=write, spec=spec

; read file name
if keyword_set(write) then title= 'Save ALL Loaded Spectrogram Data Sets'
if keyword_set(read) then title= 'Load Spectrogram Data Sets'

f= pickfile( filter='*.idlsav', get_path=path, $
             title=title )
if f eq '' then return

; preprocess file name
if strpos(f,'/') eq -1 then f=path+f
n= strlen( f )

suffix= strmid(f,n-8,8)
if suffix ne '.idlsav' then f=f+'.idlsav'


if keyword_set( spec ) then begin
    
    common hydra_spec_data, $
      data_context, $           ; selects current data set
      spec_type_names, $
      spec_header, $
      spec_data, $
      spec_aligned_data, $
      spec_perp_data, $
      spec_opposed_data, $
      spec_skew_data, $
      hr_spec_data, $
      hr_spec_aligned_data, $
      hr_spec_perp_data, $
      hr_spec_opposed_data, $
      hr_spec_skew_data
    
    if keyword_set(write) then begin
        save, file=f, /verbose, $
          spec_type_names, $
          spec_header, $
          spec_data, $
          spec_aligned_data, $
          spec_perp_data, $
          spec_opposed_data, $
          spec_skew_data, $
          hr_spec_data, $
          hr_spec_aligned_data, $
          hr_spec_perp_data, $
          hr_spec_opposed_data, $
          hr_spec_skew_data

        r= widget_message( ['file '+f+' written.'] )
    endif
    
    if keyword_set(read) then begin
        restore, file=f, /verbose
        hydra_display_info, /spec
    endif        
endif

return
end
