pro hydra_rw_user_configuration, read=read, write=write, stat=stat, new=new

   rm = 'rm'
   cp = 'cp'                    ; OS specific changes

   close, 11

   common hydra_user_configure_common, user_configure_data, $
     user_configure_data_tmp

   stat='success'

   user_configure_file= getenv( 'PAPCO_HYDRA_USER_CONFIGURE_FILE' )
   if user_configure_file eq '' then $
     user_configure_file='~/.hydra_module_options'

   if keyword_set(read) then begin

       if n_elements( user_configure_data ) eq 0 then begin           
           user_configure_data= { $
                                  user_configure_data_file: $
                                  user_configure_file, $
                                  spec_shift:0, $
                                  spec_dJdE:1, $
                                  ID_base:0L, $
                                  ID_spec_shift:0L, $
                                  ID_spec_dJdE:0L, $
                                  can_save:1, $
                                  ID_save:0L $
                           }
           user_configure_data_tmp=user_configure_data
       endif
       
       on_ioerror, cannot_read
       openr, 11, user_configure_data.user_configure_data_file
       
       ss= ' '
       while not eof(11) do begin
           readf, 11, ss
           r=execute(ss)       
       endwhile

       close, 11


   endif

   if keyword_set(write) then begin
       on_ioerror, cannot_write
       if keyword_set(new) then begin
           openw, 11, user_configure_data.user_configure_data_file           
           ss= 'user_configure_data.spec_shift='+$
             strtrim(user_configure_data.spec_shift,2)
           printf, 11, ss
           ss= 'user_configure_data.spec_dJdE='+$
             strtrim(user_configure_data.spec_dJdE,2)
           printf, 11, ss
           close, 11
           return
       end           
       
       spawn, cp + ' ' + user_configure_data.user_configure_data_file + ' ' + $
         user_configure_data.user_configure_data_file+'.old', cpstat
       
       openr, 10, user_configure_data.user_configure_data_file+'.old'
       
       openw, 11, user_configure_data.user_configure_data_file

       ss=' '
       while not eof(10) do begin
           readf, 10, ss
           ii= strpos( ss, '=' )
           if ii eq -1 then ii=1 ; copy line if no '=' found
           case ( strmid( ss, 0, ii ) ) of
               'user_configure_data.spec_shift': begin
                   ss= 'user_configure_data.spec_shift='+$
                     strtrim(user_configure_data.spec_shift,2)
                   printf, 11, ss
               end
               'user_configure_data.spec_dJdE': begin
                   ss= 'user_configure_data.spec_dJdE='+$
                     strtrim(user_configure_data.spec_dJdE,2)
                   printf, 11, ss
               end
               else: printf, 11, ss
           endcase
       endwhile
       close, 11
       close, 10
       spawn, rm + ' ' + user_configure_data.user_configure_data_file+'.old'
   endif
   return

   cannot_write:
   print, 'hydra_rw_user_configuration: can''t write configuration file.'
   stat='fail'
   return

   cannot_read:
;   assume it needs to be created.
   message, 'Creating configuration file for hydra module.', /cont
   hydra_rw_user_configuration, /write, /new, stat=stat
   if stat eq 'fail' then $
     print, 'hydra_rw_user_configuration: can''t read configuration file.' 

   return
   
end

