pro hydra_strike, date_time_in, $
                  init=init, panelNR=panelNR, xrange=xrange, $
                  date=date, tmid=tmid

; moves the vertical strike in papco to the specified position.
; xrange can be specified in a string in papco's time string format,
;   or if it is a number then it is assumed to be the same units as
;   xrange.
; date_time can be a string or number as well.

   common hydra_strike_common, strikedata
   common plot_composer, widgetData
   common time, xut1, xut2
   
   if n_elements( date_time_in ) gt 0 then begin
       date_time=date_time_in
       s= size( date_time )
       if s(1) eq 7 then begin
           r= convert_TimeToSeconds( date_time, /t90 )
           date_time= double( r.value )
       endif
   endif
   
   if n_elements( date ) gt 0 and n_elements( tmid ) gt 0 then begin
       date2= strtrim( date,2 )
       date3= strmid( date2,4,2 ) + '/' + strmid( date2,6,2 ) + '/' + $
         strmid( date2, 0,4 )
       date_time_in= date3+' 0:00'
       r= convert_TimeToSeconds( date_time_in, /t90 )
       date_time= double( r.value ) + tmid
   endif

   if keyword_set( init ) then begin
       thisPlot=widgetData.plotsDrawn(panelNr)
       if n_elements( xrange ) eq 0 then $
         xrange= [ xut1, xut2 ] ; assumes xut1, xut2 have not been reset    
       xnormal= thisplot.NORMAL_XRANGE
       strikedata= { panelNR:panelNR, $
                     xrange:double(xrange), $
                     xnormal:xnormal }
   endif
   
   if n_elements( date_time ) gt 0 then begin
       xnorm= ( date_time - strikeData.xrange(0) ) / $
         ( strikeData.xrange(1)-strikeData.xrange(0) ) * $
         ( strikeData.xnormal(1)-strikeData.xnormal(0) ) + $
         strikeData.xnormal(0)
       papco_Cursor_ShowSelection, strikeData.panelNr, 0, 0, $
         xnorm, 0
   endif
   
   return
end


