function hydra_ylim_widget_event, event, widgetData, handled=handled

   WIDGET_CONTROL,GET_UVALUE=uval, event.id

   handled=1

   IF strleft(uval, 6) EQ 'pb_opt' THEN BEGIN
       bit= 2^long(strfrom(uval, 6))
       val= ( widgetData.typeVector(3) and bit ) / bit
       val= 1-val               ; toggle bit
       widgetData.typeVector(3)= $
         widgetData.typeVector(3) and (not long(bit)) or bit*val
       goto, done
   ENDIF

   case uval of 
       'pb_yScaleManual' : BEGIN
           widgetData.manualYScaling=1
                     ; check limits, and if one zero or negative set linear
           WIDGET_CONTROL, widgetData.ef_yscaleFrom, GET_VALUE=from
           WIDGET_CONTROL, widgetData.ef_yscaleTo,   GET_VALUE=to
           Min=FLOAT(from(0))
           Max=FLOAT(to(0))
           if (Min le 0) or (Max le 0) then widgetData.yLinLog=0
           papco_panel_Refresh, widgetData, /YSCALE
       END

       'pb_yScaleAuto' : BEGIN
           widgetData.manualYScaling=0
           papco_panel_Refresh, widgetData, /YSCALE
       END
       
       'pb_yLog' : BEGIN
                          ; check if manual scaling is set. If so, don't allow
                          ; log scale if either limit is zero or negative
           WIDGET_CONTROL, widgetData.ef_yscaleFrom, GET_VALUE=from
           WIDGET_CONTROL, widgetData.ef_yscaleTo, GET_VALUE=to
           widgetData.yscaleMin=FLOAT(from(0))
           widgetData.yscaleMax=FLOAT(to(0))
           if (widgetData.manualYScaling eq 1) then begin
               if (widgetData.yscaleMin le 0) or $
                 (widgetData.yscaleMax le 0) then widgetData.yLinLog=0 $
               else widgetData.yLinLog=1
               papco_panel_Refresh, widgetData, /YSCALE
           endif
       END
       
       'pb_yLin' : BEGIN
           widgetData.yLinLog=0
           papco_panel_Refresh, widgetData, /YSCALE
       END
       else: handled=0
   endcase
   done:
   return, widgetData
end


FUNCTION hydra_ylim_widget, aBase1, aPlotInfo

    aBase= widget_base( aBase1, /row, /frame, /align_center )
    yscale_Base=WIDGET_BASE(aBase, col=1, /frame, /align_center)
    options_base= widget_base( abase, /col, /frame, /nonexclusive )
    but1= widget_button( options_base, value='center zero', uvalue='pb_opt0' )
    widget_control, but1, set_button= ( aPlotInfo.typeVector(3) and 1 )
    but2= widget_button( options_base, value='include zero', $
                         uvalue='pb_opt1'  )
    widget_control, but2, set_button= ( aPlotInfo.typeVector(3) and 2 ) / 2
    but3= widget_button( options_base, value='multicycle log only',$
                         uvalue='pb_opt2'  )
    widget_control, but3, set_button= ( aPlotInfo.typeVector(3) and 4 ) / 4
    but4= widget_button( options_base, value='smart autorange', $
                         uvalue='pb_opt3'  )
    widget_control, but4, set_button= ( aPlotInfo.typeVector(3) and 8 ) / 8
    
    yscaleChoice=WIDGET_BASE(yscale_Base, ROW=1,/ALIGN_CENTER)
    yscaleLabel=WIDGET_LABEL(yscaleChoice,VALUE='Y-scaling: ')
    yscaleUse_Base=WIDGET_BASE(yscaleChoice, ROW=1, /FRAME, /EXCLUSIVE)
    pb_yScaleAuto=WIDGET_BUTTON(yscaleUse_Base, $
			VALUE='Automatic',$
			UVALUE='pb_yScaleAuto')
    pb_yScaleManual=WIDGET_BUTTON(yscaleUse_Base, $
			VALUE='Manual   ',$
			UVALUE='pb_yScaleManual')
    linlog_Base=WIDGET_BASE(yscaleChoice, ROW=1, /FRAME, /EXCLUSIVE)
    pb_yLog=WIDGET_BUTTON(linlog_Base, $
			VALUE='Logarythmic',$
			UVALUE='pb_yLog')
    pb_yLin=WIDGET_BUTTON(linlog_Base, $
			VALUE='Linear     ',$
			UVALUE='pb_yLin')
    yscaleInput_Base=WIDGET_BASE(yscale_Base, ROW=1, /ALIGN_CENTER)
    zInputLabel=WIDGET_LABEL(yscaleInput_Base,VALUE='Limits:  ')
    ef_yScaleFrom=CW_FIELD(yscaleInput_Base, $
		TITLE='Low:  ',$
		VALUE=aPlotInfo.yScaleMin, /FLOATING, /FRAME)
    ef_yScaleTo=CW_FIELD(yscaleInput_Base, $
		TITLE='High: ', $
		VALUE=aPlotInfo.yScaleMax, /FLOATING, /FRAME)

; now, set the initial values for the exclusive-buttons
    IF aPlotInfo.manualYScaling THEN BEGIN
	WIDGET_CONTROL, pb_yScaleManual, /SET_BUTTON
        WIDGET_CONTROL, ef_yScaleFrom, SENSITIVE=1
        WIDGET_CONTROL, ef_yScaleTo, SENSITIVE=1
    ENDIF ELSE BEGIN
	WIDGET_CONTROL, pb_yScaleAuto, /SET_BUTTON
        WIDGET_CONTROL, ef_yScaleFrom, SENSITIVE=0
        WIDGET_CONTROL, ef_yScaleTo, SENSITIVE=0
    ENDELSE

; set initial values for lin/log
    IF aPlotInfo.yLinLog THEN BEGIN
	WIDGET_CONTROL, pb_yLog, /SET_BUTTON
    ENDIF ELSE BEGIN
	WIDGET_CONTROL, pb_yLin, /SET_BUTTON
    ENDELSE

    RETURN, {ef_yScaleFrom:ef_yScaleFrom, $
             ef_yScaleTo:ef_yScaleTo, $
             pb_yScaleAuto:pb_yScaleAuto, $
             pb_yScaleManual:pb_yScaleManual, $
             pb_yLog:pb_yLog, $
             pb_yLin:pb_yLin, $
             manualYScaling:aPlotInfo.manualYScaling, $
             yScaleMin:aPlotInfo.yScaleMin, $
             yScaleMax:aPlotInfo.yScaleMax, $
             yLinLog:aPlotInfo.yLinLog}

END
