pro slicer_template_killed, base
;  This function is called when the widget is killed.  Though often 
; unnecessary, it provides a way for the system to cleanup after
; itsself.  For example, it might save the last state to disk so that
; the next start up is closer to the useful state.

  slicer_template_get_state, base, state
  
  print, 'Here was the final state which could be saved to disk:'
  print, '  state.app.diff_method:'+strtrim(state.app.diff_method,2)
  print, '  state.app.zoom:'+strtrim(state.app.zoom,2)

  print, 'Goodbye!'
end

pro slicer_template_event, event

  base= event.top

  slicer_template_get_state, base, state

  widget_control, event.id, get_uvalue=uval

  case uval of 
      'Control': begin
          if not widget_info( state.widget.control_base, /valid_id ) then begin
              
; Set the base widget ID for the control panel extension
              b= widget_base( state.widget.control_parent, /row )
              state.widget.control_base= b
              
; 1st Column of choices - Zoom of the Walen test
              b1= widget_base( b, /column )
              x= cw_field( b1, title='zoom (0,1,2...): ', $
                           /integer, value=state.app.zoom, uval='zoom', /return_ev)
              
; 2nd Column of choices - Method for differencing Walen
              b1= widget_base( b, /column, /exclusive)
              values = ['Mid-referenced',$
                        'Asymptotic']
              x = lonarr(n_elements(values))
              for i=0,n_elements(values)-1 do begin
                  x(i)= widget_button( b1, value=values(i), $
                                       uval='diff'+strtrim(string(i),2) ,/no_release )
              endfor
              widget_control, x(state.app.diff_method), set_button = 1
              
          endif else begin
              widget_control, state.widget.control_base, /destroy
          endelse
      end
      'Draw': slicer_template
      'zoom': begin
          state.app.zoom = event.value
          redraw=1
      end
      'diff0': begin
          state.app.diff_method = 0
          redraw=1
      end
      'diff1': begin
          state.app.diff_method = 1
          redraw=1
      end
      'Print': slicer_template, /print
      'Close': begin
          widget_control, event.top, /destroy
          return
      end
      'Help': begin
          xdisplayfile, papco_helpfile('slicer_template.help'), $
                        title='papco Online-Help', group=event.top      
      end
      else: begin
          message, 'uval not recognised: '+uval, /cont
      end
  end      

  slicer_template_save_state, base, state

  if keyword_set( redraw ) then slicer_template

  return
end


pro slicer_template_state_define, state
;; define the structure that represents the internal state

;;   these are the necessaries for managing the widget
  widget= { control_parent:0L, $
            control_base:0L, $
            winidx:0L $
          }

;;   these are the controllable parameters for this application
  app= { zoom:0L, $
         diff_method:0, $
         start_doy96:150.d, $
         end_doy96:151.d }
  
  state= { widget:widget, $
           app:app }           
end


pro slicer_template_build_widget, base
;;   build the widget, return a reference to the base.

  b= widget_base( title='hydra_slicer_template', /col )
  child= widget_base( b ) 
;;     usually you would store the state in the child.  This
;;   is good because this practice is necessary for compound_widgets.
;;   However, there is a problem with that if you wish to have a
;;   clean-up "killed" method in that the child is destroyed by
;;   the time the clean-up is called!  So for this application, 
;;   we just store the state in the uvalue of the base.  (See get_state and
;;   save_state methods)

  slicer_template_state_define, state

  d= widget_draw( b, xsize=800, ysize=700 )
  b1= widget_base( b, /row )
  bu= widget_button( b1, value='Control', uvalue='Control' )
  bu= widget_button( b1, value='Help', uvalue='Help' )
  bu= widget_button( b1, value='Print', uvalue='Print' )
  bu= widget_button( b1, value='Close', uvalue='Close' )

  state.widget.control_parent= widget_base(b) 

  widget_control, b, /realize  ;; this creates the widget

  widget_control, d, get_value=winidx  ;; the window number for wset

  state.widget.winidx= winidx

  base= b

;  The application state is stored "inside" the widget.  This allows
;  us to have multiple instances of the same widget.  This method is
;  very conventional and most IDL books show how this works.  
  slicer_template_save_state, base, state


end


pro slicer_template_get_state, base, state
  widget_control, base, get_uvalue=state
end


pro slicer_template_save_state, base, state
  child= widget_info( base, /child )
  widget_control, base, set_uvalue=state
end


pro slicer_template_draw, base, print=print, exceptionString=exceptionString

  if keyword_set(print) then begin
      set_plot, 'ps'
      filename='slicer_template.ps'
      device, filename=filename, xsize=7.5, ysize=7,/inches, /color, /landscape
  endif else begin
      hyd_set_plot, 'x'  ;; hyd_set_plot uses 'win' for windows and 'x' for unix
  endelse

  erase, get_color_index('white')
  !p.position=0
  !p.noerase=0
  !p.background = get_color_index('white')
  !p.multi = [0,1,1]
  black= get_color_index('black')

  slicer_template_get_state, base, state

  if ( state.app.zoom gt 3 or state.app.zoom lt 0 ) then begin
      exceptionString= 'Zoom level can only be 0,1,2,3.!cThis is a poor example of an exception, since!c'+$
                       'the controls should be designed to prevent this state'
      return
  endif

  ybase= .7
  xyouts, .5, ybase-0, 'HERE ARE THE CONTROLLABLE PARAMETERS:', /normal, color=black, $
          alignment=.5, charsize=2.0
  xyouts, .5, ybase-0.15, 'start Time: '+gen_time_string(state.app.start_doy96), /normal, color=black, $
          alignment=.5, charsize=1.0
  xyouts, .5, ybase-0.2, 'end Time: '+gen_time_string(state.app.end_doy96), /normal, color=black, $
          alignment=.5, charsize=1.0


  xyouts, .5, ybase-0.25, 'diff_method: '+strtrim(state.app.diff_method,2), /normal, color=black, $
          alignment=.5, charsize=1.0
  xyouts, .5, ybase-0.30, 'zoom: '+strtrim(state.app.zoom,2), /normal, color=black, $
          alignment=.5, charsize=1.0
  

  if keyword_set(print) then begin
      device, /close
      r= widget_message( ['Created ',filename], /info )
      set_plot, 'x'
  endif

end

pro slicer_template_exception_handler, base, exceptionString

  slicer_template_get_state, base, state

  drawOnCanvas=1
  displayPopup=1

  if drawOnCanvas then begin

      hyd_set_plot, 'x'
      wset, state.widget.winidx

      erase, get_color_index('white')
      !p.position=0
      !p.noerase=0
      !p.background = get_color_index('white')
      !p.multi = [0,1,1]
      black= get_color_index('black')
      
      xyouts, .5, .5, exceptionString, /normal, color=black, alignment=.5, charsize=2.0

  endif

  if displayPopup then begin
      x= widget_message(exceptionString)
      
  endif

end

  
PRO slicer_template, start_doy96, end_doy96, print=print

; datestr_in = 'YYYYMMDD'
; starttime_in in seconds since midnight
; stoptime_in in seconds since midnight

;;  It is desirable when developing widget applications that multiple
;;  instances can exist without affecting one another.  This is called
;;  "multiply reentrant code."  To do this, the widget data and
;;  controllable parameters are usually stored within the widget as a
;;  uvalue to a dummy base that is the first child of the widget_base.
;;  For convenience, we use a common block here which breaks the
;;  reentrant nature, but it should be clear that this could be
;;  avoided.  See the widgets chapter in Building IDL Applications for
;;  a more in-depth explaination.

  COMMON slice_template_widgetData, base

  myname='SLICER_TEMPLATE: '

  if n_elements( base ) gt 0 then begin
      if Widget_Info( base, /Valid_ID)  eq 0 then begin
          build_widget=1
      endif else begin
          build_widget=0
      endelse
  endif else begin
      build_widget=1
  endelse

  if build_widget then begin
      slicer_template_build_widget, base      
  endif else begin
      slicer_template_get_state, base, state
      wset, state.widget.winidx
  endelse

  if n_elements( start_doy96 ) ne 0 then begin 
; we've reentered this code.  This means that the code has called
; itsself, generally to access the print method.
      slicer_template_get_state, base, state
      state.app.start_doy96= start_doy96
      state.app.end_doy96= end_doy96
      slicer_template_save_state, base, state
  endif

  widget_control, /hourglass   
  exceptionString=''
  slicer_template_draw, base, $
    exceptionString=exceptionString, $
    print=print

  if exceptionString ne '' then begin
      slicer_template_exception_handler, base, exceptionString
  endif

  if ( build_widget ) then begin
;;      this enables the widget to respond to clicks, etc.
      xmanager, 'slicer_template', base, cleanup='slicer_template_killed'
  endif
  
  return

END




