PRO user_time_range_hydra_spec, panelNr, seconds, Y, event=event, $
                                erase_only=eraseonly

   COMMON PAPCO_DRAWSLICE, sliceWidgetData
   common user_time_range_common, seconds0, Y0, drawn
   common plot_composer, widgetData
   common papco_graphics, papco_drawn_window

   common time, xut1, xut2

   if n_elements( drawn ) eq 4 then begin ; need to erase
       device, set_graphics= 6
       plots, [drawn(0),drawn(2)], [drawn(1), drawn(1)], /normal
       plots, [ drawn(0),drawn(0) ], drawn(1)+[0.005,-0.005], /normal
       plots, [ drawn(2),drawn(2) ], drawn(1)+[0.005,-0.005], /normal
       device, set_graphics= 3
   endif

   if keyword_set( eraseonly ) then begin
       drawn= -1
       return
   endif

   if n_elements( event ) eq 0 then begin
       message, 'Event structure not passed by papco.', /cont
       return
   endif

   if event.press gt 0 then begin
       seconds0= seconds + xut1
       Y0= Y
   endif

;  draw it
   P0= widgetData.mouse_clicked_position
   P1= papco_Data_To_Normal( panelNR, [ seconds, Y ] )
   device, set_graphics= 6
   drawn= [ P0(0), P0(1), P1(0), P1(1) ]
   plots, [drawn(0),drawn(2)], [drawn(1), drawn(1)], /normal
   plots, [ drawn(0),drawn(0) ], drawn(1)+[0.005,-0.005], /normal
   plots, [ drawn(2),drawn(2) ], drawn(1)+[0.005,-0.005], /normal
   device, set_graphics= 3

   if event.release gt 0 then begin       
       print, 'got: ', seconds0 mod 86400, Y0, (seconds+xut1) mod 86400, Y
   endif
END


