PRO gen_op_win, op, bank, plots, redraw, start_doy96_active, end_doy96_active
COMMON share_waves, waves_tlb
;  IN   op;    0-poly_comprs; 1-compress; 2-polytrope
;  IN   bank
;  OUT  redraw
;  OUT  start_doy96_active
;  OUT  end_doy96_active

widget_control, waves_tlb, get_uvalue=state
if not widget_info(state.id.top_base[op,bank], $
                   /valid_id) then begin

; TOP LEVEL BASE
  if state.var.debug then begin
    case op of 
      '0':  state.id.top_base[op,bank] = $
              widget_base( xoffset=20+bank*20, yoffset=310, $
                       title='Poly-Compress'+string(bank), /col )
      '1':  state.id.top_base[op,bank] = $
              widget_base( xoffset=20+bank*20, yoffset=290, $
                       title='Compress'+string(bank), /col )
      '2':  state.id.top_base[op,bank] = $
              widget_base( xoffset=20+bank*20, yoffset=270, $
                       title='Polytrope'+string(bank), /col )
    endcase

  endif else begin
    case op of 
      '0':  state.id.top_base[op,bank] = $
              widget_base(title='Polytrope-Compress'+string(bank),/col )
      '1':  state.id.top_base[op,bank] = $
              widget_base(title='Compress'+string(bank), /col )
      '2':  state.id.top_base[op,bank] = $
              widget_base(title='Polytrope'+string(bank), /col )
    endcase
  endelse

; PLOT AREA
;  if !d.name eq 'X' then begin
;    device, get_screen_size=screen_size
;  endif else begin
;    screen_size=1200
;  endelse

  plot_area = $
    widget_draw(state.id.top_base[op,bank], $
    xsize=plots*400,ysize=400)
  widget_control, plot_area, /realize
  widget_control, plot_area, get_value=plot_area
  state.id.plotarea[op,bank] = plot_area

; TIME/DATE AREA
  lab_area1 = $
    widget_base( state.id.top_base[op,bank],/row )
  lab_area2= $
    widget_base( state.id.top_base[op,bank],/row )
  state.id.text_sta[op,bank]= cw_field( lab_area1, /string, xsize=35, $
    title='Start:', $
    uvalue='start_uval_op'+strtrim(op,2)+'_bank'+strtrim(bank,2))
  state.id.text_end[op,bank]= cw_field( lab_area2, /string, xsize=35, $
    title='End:  ', $
    uvalue='end_uval_op'+strtrim(op,2)+'_bank'+strtrim(bank,2))

; PRINT & CLOSE BUTTON AREA
  but_area1 = $
    widget_base( state.id.top_base[op,bank], /row )
  bu = widget_button( but_area1, $
       value='Print', uvalue='print_op'+strtrim(op,2) + '_bank'+strtrim(bank,2))
  state.id.butt_pri[op,bank]=bu

  bu = widget_button( but_area1, $
       value='Close', uvalue='close_op'+strtrim(op,2) + '_bank'+strtrim(bank,2))
  state.id.butt_clo[op,bank]=bu


  xmanager, 'waves', state.id.top_base[op,bank], /no_block
endif


; TIME/DATE REFRESH FROM MAIN WINDOW VALUES (STRING TO DOUBLE CONVERSION)
widget_control, state.id.st, get_value=start_doy_str
widget_control, state.id.et, get_value=end_doy_str

; STORE TIME STRING BY OPERATION & BANK
widget_control, state.id.text_sta[op,bank], set_value=start_doy_str
widget_control, state.id.text_end[op,bank], set_value=end_doy_str

; STORE DOUBLE PRECISION DECIMAL DAY BY OPERATION & BANK, AND 
;   OUTPUT SAME TO ACTIVE VARIABLES
state.var.start_doy96[op,bank]=gen_time_accurate(start_doy_str)
state.var.end_doy96[op,bank]=gen_time_accurate(end_doy_str)
start_doy96_active=gen_time_accurate(start_doy_str)
end_doy96_active=gen_time_accurate(end_doy_str)

widget_control, waves_tlb, set_uvalue=state
redraw=1

end                             ; end gen OP WINDOW



PRO waves_event, event
COMMON share_waves

;print,'EVENT.TOP=',event.top,'  EVENT.ID=',event.id

widget_control, waves_tlb, get_uvalue=state
widget_control, event.id,  get_uvalue=uval
case uval of

; POLY_COMPRS WINDOW
  'poly_comprs': begin
    op=0
    plots=3
    widget_control, state.id.polcmp_win, get_value=bank
    gen_op_win, op, bank[0], plots, redraw, start_doy96_active, end_doy96_active
    widget_control, waves_tlb, get_uvalue=state ; bring state struc. uptodate
  end

; COMPRESS WINDOW
  'compressible': begin
    op=1
    plots=1
    widget_control, state.id.comprs_win, get_value=bank
    gen_op_win, op, bank[0], plots, redraw, start_doy96_active, end_doy96_active
    widget_control, waves_tlb, get_uvalue=state ; bring state struc. uptodate
  end

; POLYTROPE WINDOW
  'polytropic': begin
    op=2
    plots=2
    widget_control, state.id.polytr_win, get_value=bank
    gen_op_win, op, bank[0], plots, redraw, start_doy96_active, end_doy96_active
    widget_control, waves_tlb, get_uvalue=state ; bring state struc. uptodate
  end

; ERROR FILE EVENT HANDLER
  'errfile': return

; POLYTROPE-COMPRESS PRINT BUTTONS
  'print_op0_bank0': begin
    waves_draw, 0,0,$                       ; op=0,bank=0
               state.var.start_doy96[0,0], $
               state.var.end_doy96[0,0], $
               /print, $
               debug=state.var.debug
    return
  end
  'print_op0_bank1': begin
    waves_draw, 0,1,$                       ; op=0,bank=1
               state.var.start_doy96[0,1], $
               state.var.end_doy96[0,1], $
               /print, $
               debug=state.var.debug
    return
  end
  'print_op0_bank2': begin
    waves_draw, 0,2,$                       ; op=0,bank=2
               state.var.start_doy96[0,2], $
               state.var.end_doy96[0,2], $
               /print, $
               debug=state.var.debug
    return
  end

; COMPRESS PRINT BUTTONS
  'print_op1_bank0': begin
    widget_control, waves_tlb , set_uvalue=state
    waves_draw, 1,0, $                       ; op=1,bank=0
               state.var.start_doy96[1,0], $
               state.var.end_doy96[1,0], $
               /print, $
               debug=state.var.debug
    return
  end
  'print_op1_bank1': begin
    widget_control, waves_tlb , set_uvalue=state
    waves_draw, 1,1,$                       ; op=1,bank=1
               state.var.start_doy96[1,1], $
               state.var.end_doy96[1,1], $
               /print, $
               debug=state.var.debug
    return
  end
  'print_op1_bank2': begin
    widget_control, waves_tlb , set_uvalue=state
    waves_draw, 1,2,$                       ; op=1,bank=2
               state.var.start_doy96[1,2], $
               state.var.end_doy96[1,2], $
               /print, $
               debug=state.var.debug
    return
  end



; POLYTROPE PRINT BUTTONS
  'print_op2_bank0': begin
    widget_control, waves_tlb , set_uvalue=state
    waves_draw, 2,0,$                       ; op=2,bank=0
               state.var.start_doy96[2,0], $
               state.var.end_doy96[2,0], $
               /print, $
               debug=state.var.debug
    return
  end
  'print_op2_bank1': begin
    widget_control, waves_tlb , set_uvalue=state
    waves_draw, 2,1,$                       ; op=2,bank=1
               state.var.start_doy96[2,1], $
               state.var.end_doy96[2,1], $
               /print, $
               debug=state.var.debug
    return
  end
  'print_op2_bank2': begin
    widget_control, waves_tlb , set_uvalue=state
    waves_draw, 2,2,$                       ; op=2,bank=2
               state.var.start_doy96[2,2], $
               state.var.end_doy96[2,2], $
               /print, $
               debug=state.var.debug
    return
  end


; POLY_COMPRS CLOSE BUTTONS
  'close_op0_bank0': widget_control, event.top, /destroy
  'close_op0_bank1': widget_control, event.top, /destroy
  'close_op0_bank2': widget_control, event.top, /destroy
; COMPRESS CLOSE BUTTONS
  'close_op1_bank0': widget_control, event.top, /destroy
  'close_op1_bank1': widget_control, event.top, /destroy
  'close_op1_bank2': widget_control, event.top, /destroy
; POLYTROPE CLOSE BUTTONS
  'close_op2_bank0': widget_control, event.top, /destroy
  'close_op2_bank1': widget_control, event.top, /destroy
  'close_op2_bank2': widget_control, event.top, /destroy




; MAIN WINDOW BANK FIELDS
;   COMPRESS WINDOW NUMBER DETERMINATION
  'wc': begin
    widget_control, event.id, get_value=winnum
    if winnum[0] eq 0 or winnum[0] eq 1 or winnum[0] eq 2 then begin
      print,'COMPRS WINDOW ',winnum[0]
    endif else begin
      widget_control, event.id, set_value='0'
      print, 'VALID VALUES ARE 0, 1, OR 2'
    endelse
  end

;   POLYTROPE WINDOW NUMBER DETERMINATION
  'wp': begin
    widget_control, event.id, get_value=winnum
    if winnum[0] eq 0 or winnum[0] eq 1 or winnum[0] eq 2 then begin
      print,'POLY WINDOW ',winnum[0]
    endif else begin
      widget_control, event.id, set_value='0'
      print, 'VALID VALUES ARE 0, 1, OR 2'
    endelse
  end

; POLYTROPE-COMPRESS WINDOW NUMBER DETERMINATION
  'wpc': begin
    widget_control, event.id, get_value=winnum
    if winnum[0] eq 0 or winnum[0] eq 1 or winnum[0] eq 2 then begin
      print,'POLY_COMPRS WINDOW ',winnum[0]
    endif else begin
      widget_control, event.id, set_value='0'
      print, 'VALID VALUES ARE 0, 1, OR 2'
    endelse
  end


; MAIN WINDOW CLOSE BUTTON
  'Close': begin

    for j=0, 2 do begin
      for k=0, 2 do begin
        if widget_info( state.id.top_base[j,k], /valid_id ) then begin
          widget_control, state.id.top_base[j,k], /destroy
        end
      endfor
    endfor

    widget_control, waves_tlb, /destroy
    waves_tlb=-1L
    return
  end



  'Help': begin
    xdisplayfile, $
                 '/opt/hydra/papco/polar_hydra/papco_interface/waves.help', $
                 title='papco Online-Help', group=event.top
  end

  else: begin
    message, 'uval not recognized: '+uval, /cont
  end

endcase    ; end of main case statement

widget_control, waves_tlb, set_uvalue=state
if keyword_set( redraw ) then waves_draw, $
                         op, bank, start_doy96_active, end_doy96_active

end




PRO waves_exception_handler, exceptionString
COMMON share_waves
widget_control, waves_tlb, get_uvalue=state
drawOnCanvas=1
displayPopup=0

if drawOnCanvas then begin

  hyd_set_plot, 'x'
  wset, state.id.reduwin

  erase, get_color_index('white')
  !p.position=0
  !p.noerase=0
  !p.background = get_color_index('white')
  !p.multi = [0,1,1]
  black= get_color_index('black')

  xyouts, .5, .8, exceptionString, $
          /normal, color=black, alignment=.5, charsize=2.0

endif

if displayPopup then begin
  x= widget_message(exceptionString)
endif
end



PRO waves_killed, waves_tlb
widget_control, waves_tlb, get_uvalue=state
print,''
print, 'Goodbye!'
end




PRO waves_build, a, b, debug=debug
COMMON share_waves

; DEFINE A STRUCTURE FOR THE STATE OF THE APPLICATION
;   This is saved as the uvalue of waves_tlb
id=   { $
       comprs_win:0, $
       polytr_win:0, $
       polcmp_win:0, $
       poly_comprs_err:0, $

       st:0L, $
       et:0L, $
       
; IDs for 4 operations with banks of 3 windows each.
       top_base:[[0L,0L,0L], [0L,0L,0L], [0L,0L,0L], [0L,0L,0L]], $
       plotarea:[[0L,0L,0L], [0L,0L,0L], [0L,0L,0L], [0L,0L,0L]], $
       butt_pri:[[0L,0L,0L], [0L,0L,0L], [0L,0L,0L], [0L,0L,0L]], $
       butt_clo:[[0L,0L,0L], [0L,0L,0L], [0L,0L,0L], [0L,0L,0L]], $
       text_sta:[[0L,0L,0L], [0L,0L,0L], [0L,0L,0L], [0L,0L,0L]], $
       text_end:[[0L,0L,0L], [0L,0L,0L], [0L,0L,0L], [0L,0L,0L]]  $
      }

var=  { $
; saved doy format for later printing
       start_doy96:[[0D,0D,0D], [0D,0D,0D], [0D,0D,0D], [0D,0D,0D]], $
       end_doy96:  [[0D,0D,0D], [0D,0D,0D], [0D,0D,0D], [0D,0D,0D]], $
       debug:debug $
      }

state={ $
       id:id, $
       var:var $
      }

; BUILD THE INITIAL OVERALL WIDGET.
state.var.debug=debug

if debug eq 1 then begin
  device, get_screen_size=screen_size
  waves_tlb = widget_base( $
                           xoffset=screen_size[0]*.63, $
                           yoffset=screen_size[1]*.9, $
                           title='hydra_waves', /col )
endif else begin
  waves_tlb = widget_base( title='hydra_waves', /col )
endelse
print,'waves_tlb id =',strtrim(waves_tlb,2)


; BUILD OPERATIONS BUTTONS FOR WAVES_TLB
button_area1 = widget_base( waves_tlb, /row); ,/align_center)

bu= widget_button( button_area1, value='Poly_Comprs: 0,1or2', $
                                 uvalue='poly_comprs' )
state.id.polcmp_win = widget_text( button_area1, value='0', $
                                 uvalue='wpc', xsize=1, /editable)
bu= widget_button( button_area1, value='ErrorFile', $
                                 uvalue='errfile' )
state.id.poly_comprs_err = widget_text( button_area1, $
                                 value='3', uvalue='pcerr', xsize=2, /editable)
bu= widget_label( button_area1,  value='      ')


bu= widget_button( button_area1, value='Compressible: 0,1or2', $
                                 uvalue='compressible' )
state.id.comprs_win = widget_text( button_area1, value='0', $
                                 uvalue='wc', xsize=1, /editable)
bu= widget_label( button_area1,  value='      ')


bu= widget_button( button_area1, value='Polytropic: 0,1or2', $
                                 uvalue='polytropic' )
state.id.polytr_win = widget_text( button_area1, value='0', $
                                 uvalue='wp', xsize=1, /editable)
bu= widget_label( button_area1,  value='      ')



; BUILD DATE/TIME INPUT FIELDS
input_area1= widget_base( waves_tlb, /row )
state.id.st= cw_field( input_area1, /string, xsize=35, $
              title='Start:', $
              value= gen_time_string(a), $ ; convert float decimal day to string
              uval='start_time_uval')

input_area2= widget_base( waves_tlb, /row )
state.id.et= cw_field( input_area2, /string, xsize=35, $
              title='End:  ', $
              value= gen_time_string(b), $ ; convert float decimal day to string
              uval='end_time_uval')



; BUILD CLOSE/HELP BUTTONS FOR MAIN
button_area2= widget_base( waves_tlb, /row )
bu= widget_button( button_area2, value='Close',   uvalue='Close' )
bu= widget_button( button_area2, value='Help',    uvalue='Help' )

if debug eq 1 then begin
  bu= widget_button( button_area2, value='Compile', uvalue='Compile' , $
                     xsize=500, event_pro='waves_compile')
endif


widget_control, waves_tlb, /realize
widget_control, waves_tlb, set_uvalue=state
end



PRO waves_draw, op, bank, $
               start_doy96_active, $
               end_doy96_active, $
               print=print, $
               exceptionString=exceptionString, $
               debug=debug

COMMON share_waves
widget_control, waves_tlb, get_uvalue=state

case op of
  '0': op_name='polcmp'
  '1': op_name='comprs'
  '2': op_name='polytr'
  else: op_name='noop'
endcase
print, 'OPERATION=',op_name

print, 'START =', gen_time_string_accurate(start_doy96_active[0])
print, 'END   =', gen_time_string_accurate(end_doy96_active[0])
print, ''


if keyword_set(print) then begin
  set_plot, 'ps'

; MAKE A MICROSOFT SAFE FILENAME
  widget_control, state.id.text_sta[op,bank], get_value=start_str
  widget_control, state.id.text_end[op,bank], get_value=end_str

  start_str_time=strmid(start_str,9)
  strput, start_str_time,'_',2
  strput, start_str_time,'_',5
  apos=strpos(start_str_time,'.')
  if apos[0] gt 0 then strput, start_str_time,'_',8
  start_str=strmid(start_str,0,8) + '-' + start_str_time

  end_str_time=strmid(end_str,9)
  strput, end_str_time,'_',2
  strput, end_str_time,'_',5
  apos=strpos(end_str_time,'.')
  if apos[0] gt 0 then strput, end_str_time,'_',8
  end_str=strmid(end_str,0,8) + '-' + end_str_time

  filename=start_str + op_name + end_str + '.ps'
  device, filename=filename[0], /color, /landscape

endif else begin

  if strlowcase(!version.os_family) eq 'windows' then begin
    set_plot, 'win'
  endif else begin
    set_plot, 'x'
  endelse

  wset, state.id.plotarea[op,bank]
endelse


!p.position=0
!p.region=0

!p.background = get_color_index('white')
!p.color      = get_color_index('black')
;!p.background = 'fafafa'XL; where hex rgb positions are 'bbggrr'XL
                           ;   r+256*(g+256*b)
;!p.color      = '030303'XL

!p.noerase=0
erase

err_hdl=''



; DETERMINE WHICH CODE IS BEING USED
;  which, 'compress.pro'
;  which, 'dd_findnorm_with_errors.pro'
;  which, 'new_error_flags_jds.pro'
;  which, 'new_polytropic_test2.pro'
;  which, 'new_compressible_searcher2.pro'
;  which, 'new_gen_fit.pro'
;  print, 'START =', gen_time_string_accurate(start_doy96_active)
;  print, 'END   =', gen_time_string_accurate(end_doy96_active)
;  print, ''


; IF DEBUG=1 THEN USE FAST DUMMY OPERATIONS
if state.var.debug eq 0 then begin

  case op of
    '0': begin
      !p.multi = [0,3,1]

      widget_control, state.id.poly_comprs_err, get_value=jdumb
      jdumb=fix(jdumb)
      print,'ERROR FILE=',strtrim(jdumb,2)

      new_polytropic_test2, $
                   start=start_doy96_active[0], final=end_doy96_active[0], $
                   jdumb = jdumb
    end

    '1': begin
      !p.multi = [0,1,1]
      compress, $
               start_doy96_active[0], $
               end_doy96_active[0], $
               err_hdl=err_hdl

;              print,'ERR_HDL=',err_hdl
      if err_hdl ne 'No errors' then begin
        xdisplayfile, $
          '/opt/hydra/papco/polar_hydra/papco_interface/waves.err', $
          text=err_hdl, $
          title='Application Exception',/modal
      end
    end

    '2': begin
      !p.multi = [0,2,1]
      polytr, start_doy96_active[0], end_doy96_active[0]
    end

    else: print, 'NO OPERATION PERFORMED'
  endcase
endif else begin
  case op of
    '0': begin
      !p.multi = [0,3,1]
      plot, indgen(100), title='Polytrope-Compress'
      plot,-indgen(100), title='Polytrope-Compress'
      plot,-indgen(50), title='Polytrope-Compress'
    end

    '1': begin
      !p.multi = [0,1,1]
      plot, indgen(100), title='Compress'
    end

    '2': begin
      !p.multi = [0,2,1]
      plot,-indgen(100), title='Polytrope'
      plot,-indgen(50), title='Polytrope'
    end

    else: print, 'NO DRAW OPERATION PERFORMED'
  endcase
endelse


if keyword_set(print) then begin
  device, /close
  r= widget_message(['Send this file to the printer of your choice:',$
                     filename], /info )

  if strlowcase(!version.os_family) eq 'windows' then begin
    set_plot, 'win'
  endif else begin
    set_plot, 'x'
  endelse

endif

widget_control, waves_tlb, set_uvalue=state
end




PRO waves, start_doy96, end_doy96
; IN    start_doy96  decimal days (float)
; IN    end_doy96    decimal days (float)

COMMON share_waves
debug=0                   ; make sure this equals 0 for general releases

if n_elements(waves_tlb) eq 0 then begin
  waves_build, start_doy96, end_doy96, debug=debug
  xmanager, 'waves', waves_tlb, cleanup='waves_killed', /no_block
  if debug then print,'BUILD & XMANAGER CALLED'
endif else if waves_tlb eq -1L then begin
  waves_build, start_doy96, end_doy96, debug=debug
  xmanager, 'waves', waves_tlb, cleanup='waves_killed', /no_block
  if debug then print,'BUILD & XMANAGER CALLED'
endif

if debug then print,'THE REST OF THE STORY IN MAIN'

; REFRESH MAIN WINDOW WITH NEW PAPCO MOUSE INPUTS
widget_control, waves_tlb, get_uvalue=state
widget_control, state.id.st, set_value=gen_time_string(start_doy96)
widget_control, state.id.et, set_value=gen_time_string(end_doy96)
widget_control, waves_tlb, set_uvalue=state

end


