PRO PAPCO_payload_to_gsm, date, time, vec_pay, vec_gsm, rate=rate

; Converts vec_pay to vec_gsm, correcting for the S/C velocity if
; rate=1

   COMMON get_error, get_err_no, get_err_msg

   vec_gsm = fltarr(3,n_elements(time))

   myname = 'PAPCO_payload_to_gsm: '

   print, myname+'Not currently correcting for the S/C velocity...'

; Get the ephemeris cdfid
   f= hydra_findfile( date, /ddcal )
   if (f NE '') then begin
      print, myname+'Opening '+f+'...'
      cdfid = cdf_open(f)
   endif else BEGIN
      print, myname+'Findfile error...'
      print, get_err_msg
      return                    ;hydra_findfile sets the error message
   ENDELSE

; First get the gsm spin-vector info
   att_res = 600.               ; Attitude file resolution in seconds
   orb_res = 60.                ; Orbit file resolution in seconds

   rec_start = 0
   rec_count_att = 144
   rec_count_orb = 1440

   hyd_cdf_varget, cdfid, 'GSM_EPHEM_TIME', att_time, rec_start=rec_start, $
    rec_count=rec_count
   hyd_cdf_varget, cdfid, 'GSM_R_ASCENSION', gsm_ra, rec_start=rec_start, $
    rec_count=rec_count
   hyd_cdf_varget, cdfid, 'GSM_DECLINATION', gsm_dec, rec_start=rec_start, $
    rec_count=rec_count

;****** MUST GET THE S/C VELOCITY IN HERE AS SOON AS BOB LOADS IT!

;******


   att_time = reform(att_time)
   gsm_ra = reform(gsm_ra)
   gsm_dec = reform(gsm_dec)

; Create the matrices needed on this crude time-scale (minimize the
; number of trig functions)

   pay2gsm = dblarr(3,3,n_elements(att_time))

   FOR itime=0,n_elements(att_time)-1 DO BEGIN 

      RAC = double(gsm_ra(itime))
      DEC = double(gsm_dec(itime))
;
      EPX = COS(DEC) * COS(RAC)
      EPY = COS(DEC) * SIN(RAC)
      EPZ = SIN(DEC)
;
;-- COMPUTE SINE VALUES AND COSINE VALUES OF ANGLES A AND D
;
      COSA = SQRT(EPY*EPY + EPZ*EPZ)
      SINA = EPX
      COSD = EPZ/COSA
      SIND = EPY/COSA
;
;-- CONSTRUCT THE TRANSFORMATION MATRIX
;
      pay2gsm(0,0,itime) = COSA
      pay2gsm(0,1,itime) = 0.
      pay2gsm(0,2,itime) = SINA
      pay2gsm(1,0,itime) = -SINA * SIND
      pay2gsm(1,1,itime) = COSD
      pay2gsm(1,2,itime) = COSA * SIND
      pay2gsm(2,0,itime) = -SINA * COSD
      pay2gsm(2,1,itime) = -SIND
      pay2gsm(2,2,itime) =  COSA * COSD

   ENDFOR


; Now loop over blocks
   for n=0, n_elements(time)-1 do BEGIN
      
; Which transformation matrix should I use??
      
      near = where(att_time GE time(n)-att_res/2.)
      IF (near(0) NE -1) THEN BEGIN
         jj = near(0)
      ENDIF ELSE BEGIN
         print, myname+'gsm time tag problem...'
         stop
      ENDELSE
      
      print, 'att_time: ',att_time(jj),' block_time: ',time(n)
      
      vec_gsm(0,n) = vec_pay(0,n)*pay2gsm(0,0,jj)+vec_pay(1,n)*pay2gsm(0,1,jj)+vec_pay(2,n)*pay2gsm(0,2,jj)
      vec_gsm(1,n) = vec_pay(0,n)*pay2gsm(1,0,jj)+vec_pay(1,n)*pay2gsm(1,1,jj)+vec_pay(2,n)*pay2gsm(1,2,jj)
      vec_gsm(2,n) = vec_pay(0,n)*pay2gsm(2,0,jj)+vec_pay(1,n)*pay2gsm(2,1,jj)+vec_pay(2,n)*pay2gsm(2,2,jj)
      vec_gsm(3,n) = sqrt(vec_gsm(0,n)^2+vec_gsm(1,n)^2+vec_gsm(2,n)^2)


;      IF (rate) THEN BEGIN      ;Correct for the S/C velocity
;
;      ENDIF

      
   ENDFOR

END
   



