PRO correct_bfield, phib, thetab, bmag, bvalid, rec_start, rec_count, CDF, $
                    nocorrect=nocorrect, highres=highres, cdfcal=CAL

   i4fill = long(-2147483648)
   i2fill = -32768
   rfill = -1.0e-31

   phib= ( phib + 0.5 ) * (2 * !pi / 256.)
   thetab= (thetab + 0.5 ) * (2 * !pi / 256.)

   bmag= make_array( 384, rec_count, /float )

   rhyd= indgen(384)*2+1 ; these are the indeces of measurements that are used.

   bvalid = make_array( size=size(phib), /byte, value=1 )

   hyd_cdf_varget, CDF, 'BLOCK_TIME', rectimes, $
     rec_start=rec_start, rec_count=rec_count
   
   cdf_epoch, mfefixx, 96, 4, 2, 17, 30, /compute 
   
   rflipx= where( rectimes lt mfefixx )
   if rflipx(0) ne -1 then begin
       phib(*,rflipx) = !pi-phib(*,rflipx)
       print, 'phib: x-axis value flipped.'
   ENDIF 

   IF keyword_set(nocorrect) THEN return

   print, 'Correcting B-angles.'

;   
;  B_AVG_RAW is three raw 16-bit components of B from SCR
;
   hyd_cdf_varget, CDF, 'B_AVG_RAW', b_avg_raw, $
     rec_start=rec_start, rec_count= rec_count

; MFE_STATUS bits: 1=OFF/ON, 2=Inb/Out Sensor, 4=Low/High Range,
;                  8=Left/Right Flipper
;         15 = 1+2+4+8 = On, Out, High, Right

   hyd_cdf_varget, CDF, 'MFE_STATUS', mfe_status, $
     rec_start=rec_start, rec_count= rec_count

   rstat = where( ((mfe_status and 1) eq 0) or (b_avg_raw(0,*) EQ i2fill) )
   if (rstat(0) ne -1) then begin
       print, "Fill data found for B, no correction possible."
       bvalid(*,rstat) = 0
   endif
   rokay = where( ((mfe_status and 1) eq 1) and (b_avg_raw(0,*) NE i2fill) )
   if (rokay(0) eq -1) then return

   flipper_index = (mfe_status AND 8) eq  8
   range_index = (mfe_status AND 4) eq 4 
   sensor_index = (mfe_status AND 2) eq 2

;  mfe_offset_flag = 1 -> offsets in nT
;  mfe_offset_flag = 2 -> offsets in Counts
;
   hyd_cdf_varget, CDF, 'MFE_OFFSET_FLAG', mfe_offset_flag

;  mfe_gains: indexed by (x/y/z, Inb/Out, Low/High, Left/Right) in nT/Count
;
;
   hyd_cdf_varget, CDF, 'MFE_GAINS', mfe_gains
       
;  mfe_offset: indexed by (x/y/z, Inb/Out, Low/High, itime) in nT
;
;
   hyd_cdf_varget, CDF, 'MFE_OFFSET', mfe_offset
   hyd_cdf_varget, CDF, 'MFE_OFFSET_RAW', mfe_offset_raw
   
   hyd_cdf_varget, CDF, 'MFE_OFFSET_START', mfe_offset_start
   hyd_cdf_varget, CDF, 'MFE_OFFSET_END', mfe_offset_end
   
;  mfe_matrix: indexed by (x/y/z, x/y/z, Inb/Out, Low/High) in nT/Count
;
;
   hyd_cdf_varget, CDF, 'MFE_MATRIX', mfe_matrix

;  use high resolution 3D (x,y,z) mfe data
   highres=0   
   cdf_control, CDF, var='B_HIGH_RAW', get_var_info=r 

   if n_elements( r ) gt 0 then $
     if r.maxrec gt -1 then begin
       highres=1
       print, '## Using high-res B-field magnitude data...'
       get_hr_bmag, CDF, rec_start, rec_count, bmaghr, t, /hydtim
   endif
   
; now loop over block.
   for n=0, n_elements(rokay)-1 do begin
       i= rokay(n)
       
       gains = mfe_gains(*,sensor_index(i),range_index(i),flipper_index(i))
       
       matrix = mfe_matrix(*,*,sensor_index(i),range_index(i))

       mfe_time_start = mfe_offset_start(sensor_index(i),range_index(i),*)
       mfe_time_end = mfe_offset_end(sensor_index(i),range_index(i),*)

       cdf_epoch, rectimes(i), yr, mn, dy, hr, mn, sc, /break
       time= hr*10000+mn*100+sc

       r = where(time LE mfe_time_end AND time GE mfe_time_start)
       IF (r(0) EQ -1) THEN BEGIN
           print, 'MFE B Correction failed to get offset.'
           bvalid(*,i) = 0
           goto, loopend
       ENDIF 
       itime = r(0)
       
       offset = mfe_offset(*,sensor_index,range_index,itime)
       offset_raw = mfe_offset_raw(*,sensor_index,range_index,itime)
       
       if not keyword_set( highres ) then begin
           bavg_rawi = long(b_avg_raw(*,i))
           bmag_raw = sqrt(total(bavg_rawi*bavg_rawi))
           
           cosphi = cos(phib(rhyd,i))
           sinphi = sin(phib(rhyd,i))
       
           costheta = cos(thetab(rhyd,i))
           sintheta = sin(thetab(rhyd,i))
       
           bx0 = (sintheta*cosphi*bmag_raw)
           by0 = (sintheta*sinphi*bmag_raw)
           bz0 = (costheta*bmag_raw)
       endif else begin
           rblk= 384*i+indgen(384)
           cosphi = cos(phib(rhyd,i))
           sinphi = sin(phib(rhyd,i))
       
           costheta = cos(thetab(rhyd,i))
           sintheta = sin(thetab(rhyd,i))

           r= indgen(384)+384*i
           bx0 = (sintheta*cosphi*bmaghr(r))
           by0 = (sintheta*sinphi*bmaghr(r))
           bz0 = (costheta*bmaghr(r))
       endelse                  

       IF (mfe_offset_flag EQ 1) THEN BEGIN 
           
           bx1 = bx0*gains(0) - offset(0)
           by1 = by0*gains(1) - offset(1)
           bz1 = bz0*gains(2) - offset(2)
           
           b_avg_raw1 = b_avg_raw*gains - offset

       ENDIF ELSE BEGIN 
           
           bx1 = (bx0-offset_raw(0))*gains(0) - offset(0)
           by1 = (by0-offset_raw(1))*gains(1) - offset(1)
           bz1 = (bz0-offset_raw(2))*gains(2) - offset(2)
           
           b_avg_raw1 = (b_avg_raw-offset_raw)*gains - offset
           
       ENDELSE 

       bx2 = bx1*matrix(0,0) + by1*matrix(0,1) + bz1*matrix(0,2)
       by2 = bx1*matrix(1,0) + by1*matrix(1,1) + bz1*matrix(1,2)
       bz2 = bx1*matrix(2,0) + by1*matrix(2,1) + bz1*matrix(2,2)
       
       b_avg_raw2 = fltarr(3)
       b_avg_raw2(0) = total(b_avg_raw1*matrix(0,*))
       b_avg_raw2(1) = total(b_avg_raw1*matrix(1,*))
       b_avg_raw2(2) = total(b_avg_raw1*matrix(2,*))
       
       b_avg = b_avg_raw2
       
       bmag1 = sqrt(bx2^2 +by2^2+bz2^2)
       bhatx = bx2/bmag1
       bhaty = by2/bmag1
       bhatz = bz2/bmag1

       bmag(*,i) = bmag1
       thetab(rhyd,i) = acos(bhatz)
       thetab(rhyd-1,i) = thetab(rhyd,i)
       phib(rhyd,i) = acos( ( bhatx/sin(thetab(rhyd,i))) < 1.0 > (-1.0) )
       phib(rhyd-1,i) = phib(rhyd,i)

       r = where(bhaty LT 0.)
       phib(rhyd(r),i)=!pi*2-phib(rhyd(r),i)
       phib(rhyd(r)-1,i)=!pi*2-phib(rhyd(r)-1,i)
       
       loopend:
   endfor    

   phib= byte( phib / (2 * !pi / 256.) )
   thetab= byte( thetab / (2 * !pi / 256.) )
  
END
