pro r_hydra_spec, context

   if n_elements( context ) eq 0 then return

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_spec_data, $
     data_context, $            ; selects current data set
     spec_type_names, $
     spec_header, $
     spec_data, $
     spec_aligned_data, $
     spec_perp_data, $
     spec_opposed_data, $
     spec_skew_data, $
     hr_spec_data, $
     hr_spec_aligned_data, $
     hr_spec_perp_data, $
     hr_spec_opposed_data, $
     hr_spec_skew_data

   module_name='HYDRA spec'

   forward_function convert_date_to_t90

   get_err_no=0
   get_err_msg= module_name +' data-file read succesfully'

   data_header= spec_header(context)

   survey= context le 4

;  aos is a special mode that indicates that the aligned, opposed and
;     skew plots are to be calculated from the level one file at once.
   aos= ( where( [ 6,8,9 ] eq data_context ) )(0) ne -1 

   if aos then begin
       aligned_header= spec_header( 6 )
       opposed_header= spec_header( 8 )
       skew_header= spec_header( 9 )
   endif

; setup search path for data
   if survey then data_dir_env='HYDRA_SURVEY_DATA_PATH' $
   else data_dir_env='HYDRA_LEVEL1_DATA_PATH'
   data_dir=getenv(data_dir_env)
   if data_dir eq '' then begin
       get_err_no=1
       get_err_msg= module_name+' environmental variable !c('+data_dir_env+$
         ')!c for data path not set'
       print,get_err_msg
       return
   endif

; set spec_header versions to something large.  Final value is
;  the min of all the inputs.
   fill=99999.
   data_header.data_version= fill
   data_header.calibration_version= fill
   data_header.rgains_version= fill
   data_header.igains_version= fill
   data_header.glint_mask_version= fill
   data_header.background_version= fill
   data_header.mfe_calibration_version= fill
   data_header.sc_potential_version= fill
   data_header.intersweep_version= fill

; read data files for time period
   num_files_read=0
   time=xut1
   while time-1 lt xut2 do begin
       day_start= time / 86400 * 86400
       start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
       end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
       end_time= end_time - day_start 
       convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om       
       date_str=string(year,month,day_om,format="(i2.2,i2.2,i2.2)")       
       if end_time gt start_time then begin
           if survey then begin
               r_hydra_spec_survey, $
                 date_str, start_time, end_time, $
                 data_header, data_values
           endif else begin
               if not aos then begin
                   r_hydra_spec_l1, date_str, start_time, end_time,$
                     data_header, data_values
               endif else begin
                   r_hydra_skew_l1, date_str, start_time, end_time, $
                     skew_header, skew_data, $
                     aligned_header, aligned_data, $
                     opposed_header, opposed_data
               endelse
           endelse

           if get_err_no eq 0 then begin
               if not aos then begin
                   data_values(*).time= $
                     data_values(*).time + ( day_start - xut1 )
                   if (num_files_read eq 0) then begin
                       data_buf= [ data_values ]
                   endif else begin
                       data_buf= [ data_buf, data_values ]
                   endelse
               endif else begin
                   skew_data(*).time= $
                     skew_data(*).time + ( day_start - xut1 )
                   aligned_data(*).time= $
                     aligned_data(*).time + ( day_start - xut1 )
                   opposed_data(*).time= $
                     opposed_data(*).time + ( day_start - xut1 )
                   if (num_files_read eq 0) then begin
                       skew_buf= [ skew_data ]
                       aligned_buf= [ aligned_data ]
                       opposed_buf= [ opposed_data ]
                   endif else begin
                       skew_buf= [ skew_buf, skew_data ]
                       aligned_buf= [ aligned_buf, aligned_data ]
                       opposed_buf= [ opposed_buf, opposed_data ]
                   endelse
               endelse
               num_files_read= num_files_read+1
           endif       
       endif
       time=time+86400          ; prepare to read next day
   endwhile
   
   if num_files_read eq 0 then begin
       get_err_no=2
       print,get_err_msg
       return
   endif
   
; At high-time resolutions, electron and ion sweeps are interleaved.
; We attempt to flag species of each data block (for the slicer).
   if aos then data_buf= aligned_buf ; pick any one
   
   n=n_elements( data_buf(0).spectrum )

;  look for spectra that are not all fill data (1e-20).
   rspec= indgen(n/2)           ; electrons
   tot= total( data_buf(*).spectrum(rspec),1 )
   r= where( tot eq 0 or tot ge 1e-10 ) 
   if r(0) ne -1 then data_buf(r).species= data_buf(r).species or 1
   rspec= n-indgen(n/2)         ; ions
   tot= total( data_buf(*).spectrum(rspec),1 )
   r= where( tot eq 0 or tot ge 1e-10 ) 
   if r(0) ne -1 then data_buf(r).species= data_buf(r).species or 2

   if aos then begin
       skew_buf(*).species= data_buf(*).species
       aligned_buf(*).species= data_buf(*).species
       opposed_buf(*).species= data_buf(*).species
   endif


   if not aos then begin
       exe_str= spec_type_names(data_context)+'_data'+'=data_buf'
       r=execute( exe_str )
       spec_header(data_context)= data_header
   endif else begin       
       r= execute( spec_type_names(6)+'_data'+'= aligned_buf' )
       r= execute( spec_type_names(8)+'_data'+'= opposed_buf' )
       r= execute( spec_type_names(9)+'_data'+'= skew_buf' )

       skew_header.start_time= data_header.start_time
       skew_header.end_time= data_header.end_time
       skew_header.reload_flag= 0

       opr= spec_header(6).pitch_range
       spec_header(6)= skew_header
       spec_header(6).pitch_range= opr

       opr= spec_header(8).pitch_range
       spec_header(8)= skew_header
       spec_header(8).pitch_range= opr

       spec_header(9)= skew_header       

   endelse

   get_err_msg=' '
   get_err_no=0

   print,'Read '+module_name+': done'

   return
end


