pro create_Moments_J_saveset_2, test=test

test = keyword_set(test)

dates = ['19980404', $
         '19980416', $
         '19980424', $
         '19980502', $
         '19980504', $
         '19980619', $
         '19980711', $
         '19980716', $
         '19960620', $
         '19960828', $
         '19961008', $
         '19960524', $
         '19960909', $
         '19970512', $
         '19960529']

@hd_include
rfill = hd_fill

for idate=0,n_elements(dates)-1 do begin

    date = dates(idate)
    
; Get the moment times for a whole day - 24 hours
    timetags = 0
    hyd_access_get_timetags, timetags, 'ele_n', $
      gen_time( date=date, time='00:00' ), gen_time( date=date, time='24:00' )
    if (size(timetags,/type) ne 8) then goto, skip_day
    hyd_access, timetags, 'time_bin_start_ssm', mom_time
    
    if (test) then ntime = 100 else ntime = n_elements(mom_time)
    start_time = mom_time(0)
    end_time = mom_time(ntime-1)
    
    cp_delb_24 = fltarr(ntime)
    cp_bmag_avg_24 = fltarr(ntime)
    cp_delta_b_over_b_24 = fltarr(ntime)
    cp_curl_24 = fltarr(ntime)
    t_24 = fltarr(ntime)
    
; Get the 8Hz magnetic field data for this day
    nu8 = 8.
    timetags = 0
    hyd_access_get_timetags, timetags, 'bfield_8Hz', $
      gen_time( date=date, time='00:00' ), gen_time( date=date, time='24:00' )
    if (size(timetags,/type) ne 8) then goto, skip_day
    hyd_access, timetags, 'time_bin_start_ssm', t
    hyd_access, timetags, 'bfield_8Hz', b8
    gd = where(b8(*,0) ne hd_fill and $
               b8(*,1) ne hd_fill and $
               b8(*,2) ne hd_fill)
    t = temporary( t(gd) )
    bx = temporary( b8(gd,0) )
    by = temporary( b8(gd,1) )
    bz = temporary( b8(gd,2) )
    b8 = 0
    
    ileft = 0L
    iright = n_elements(bx)-1
    istart = 0L
    istop = 0L
    tindex_max = long(n_elements(bx)-1)
    novershoot = lonarr(ntime)
    novershoot(0:ntime-2) = long((mom_time(1:ntime-1)-mom_time(0:ntime-2))*(nu8+1.) + 100)
    novershoot(ntime-1) = 10000
    
    FOR itime=0L,ntime-1 DO BEGIN
        
        t_24(itime) = mom_time(itime)
        
        rng = lindgen(iright-ileft+1) + ileft
        il = (where(t(rng) ge mom_time(itime)))(0)
        ir = (where(t(rng) gt mom_time(itime)+13.8))(0) ; mom_time is in ssm
        
        if (il eq -1 or ir eq -1 or il eq ir) then begin
            
            cp_delb_24(itime) = rfill
            cp_bmag_avg_24(itime) = rfill
            cp_delta_b_over_b_24(itime) = rfill
            cp_curl_24(itime) = rfill
            
        ENDIF ELSE BEGIN
            
            istart = rng(il)
            istop = rng(ir)
            ileft = istop
            iright = ileft + novershoot(itime) < tindex_max
            istop = istop-1     ; Want times INSIDE bracket
            
            nsamp = long(istop-istart+1)
            
            if (nsamp le 1) then begin
                
                cp_delb_24(itime) = rfill
                cp_bmag_avg_24(itime) = rfill
                cp_delta_b_over_b_24(itime) = rfill
                cp_curl_24(itime) = rfill
                
            endif else begin
                inside = lindgen(nsamp) + istart
                
; current parameters (cp) variables
                bmag1=sqrt(bx(istart)^2+by(istart)^2+bz(istart)^2)*1.d-9*1.d+4 ;gauss
                bmag2=sqrt(bx(istop)^2+by(istop)^2+bz(istop)^2)*1.d-9*1.d+4 ;gauss
                cp_bmag_avg_24(itime) = (bmag1+bmag2)/2. ;gauss
                cp_delb_24(itime) = abs(bmag2-bmag1) ;gauss
                if (cp_bmag_avg_24(itime) ne 0.) then cp_delta_b_over_b_24(itime) = cp_delb_24(itime)/cp_bmag_avg_24(itime) else cp_delta_b_over_b_24(itime) = rfill
                
; What is the average field from all of the measurements in this
; time period, and the unit vector?
                bavg = [total(bx(inside))/float(nsamp), $
                        total(by(inside))/float(nsamp), $
                        total(bz(inside))/float(nsamp)]
                bmag = sqrt(total(bavg^2))
                bhat = bavg/bmag
                
; Find the components of the high res. measurments which are
; perpendicular to the average vector
                bperp = fltarr(3,nsamp)
                FOR ii=0,nsamp-1 DO BEGIN
                    imeas = inside(ii)
                    dot = bx(imeas)*bhat(0) + by(imeas)*bhat(1) + bz(imeas)*bhat(2)
                    bperp(0,ii) = bx(imeas) - dot*bhat(0)
                    bperp(1,ii) = by(imeas) - dot*bhat(1)
                    bperp(2,ii) = bz(imeas) - dot*bhat(2)
                ENDFOR 
                bperpmag = sqrt(total(bperp^2,1))
                
; Find dsign = sign( (bperp(i) X bperp(i+1)) dot bhat )
                dsign = intarr(nsamp-1)
                FOR ii=0,nsamp-2 DO BEGIN
                    D = crossp(bperp(*,ii),bperp(*,ii+1))
                    dot = total(D*bhat)
                    IF (dot LT 0) THEN dsign(ii) = -1 ELSE dsign(ii) = 1
                ENDFOR
                
; Find curl = < dsign * bperpmag >
                curl = total( dsign(0:nsamp-2)*bperpmag(0:nsamp-2) )/float(nsamp-1)
                cp_curl_24(itime) = curl*1.d-9*1.d+4 ;gauss
                
            endelse
            
        ENDELSE
        
    ENDFOR
    
; Create the IDL save set
    
    ss_dir = getenv('HYD_PAPCO_SCRATCH_DATA')
    if (ss_dir eq '') then message, 'HYD_PAPCO_SCRATCH_DATA environment variable not set'
    
    filename = ss_dir+date+'_Moments_J_PaPCo.idlsav'
    creation_date = systime()
    
    save, creation_date, cp_delb_24, cp_bmag_avg_24, cp_delta_b_over_b_24, cp_curl_24, t_24, file = filename
    
    message, filename+' created...', /cont

    skip_day:
    
endfor

return
end

