pro goodticks, tickv, minor

; Given the start and end times in common time, returns
; tickv and number of minor ticks that are easy to read. 
;
; Axis most start at zero and be in seconds.
;
; Written: 11/21/96 by Jeremy Faden, University of Iowa
;

   common time, xut1_t90, xut2_t90
   xut1= xut1_t90 mod 86400
   xut2= xut1 + (xut2_t90-xut1_t90)
   dsec= xut2-xut1

;                       1 2mn   3   5  15   30  1hr   2     4    6     1day  10day
   Amajtick= [1L,2,5,15,30,60,120,180,300,900,1800,3600,7200,14400,43200,86400,345600L,345600L*3,345600L*10]
   Amintick= [5, 2,5, 3, 2, 4,  4,  3,  5,  3,   3,   4,   4,    4,    6,    4,   10,6,10 ]

   Nticks= dsec / Amajtick
       r= where( Nticks ge 4 and Nticks le 6, count )
   if !d.name eq 'PS' and !d.x_size lt 9000 then begin
       r= where( Nticks ge 2 and Nticks le 3, count )
   endif
   if count eq 0 then begin
       r= where( Nticks le 7 and Nticks gt 0, count )
       if !d.name eq 'PS' and !d.x_size lt 9000 then begin
           r= where( Nticks le 3 and Nticks gt 0, count )
       endif
       if r(0) ne -1 then use= r(0) else begin
           r= where( nticks eq 0 )
           if r(0) ne -1 then nticks(r)=9999999
           x=min(nticks,use)
       endelse
   endif else begin
       use= r(count-1)
   endelse

   majtick= Amajtick(use)
   minor= Amintick(use)

   nummajticks= dsec/majtick + 1
   
   firsttickv= $
     (majtick)*long(ceil(xut1/float(majtick))) ;189302400 at 0:00
   tickv= lindgen(nummajticks)*majtick + firsttickv
   
   r= where(tickv ge xut1 and tickv le xut2)
   if r(0) ne -1 then tickv= tickv(where(tickv ge xut1 and tickv le xut2))
   tickv=tickv-xut1

   return
end
