; $Id: fitdata_plot.pro,v 1.1.1.1 2002/04/10 15:24:55 jbf Exp $
;; This file contains an unsupported function which plots data from a
;; file of fit parameters for a given range of data, as created by
;; fitdata_loop.pro
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FUNCTION myhhmmss, axis, index, value
hours   = value/3600.
minutes = (hours - floor(hours))*60.
;seconds = (minutes - floor(minutes))*60.
;return, string(format='(i2.2,a1,i2.2,a1,i2.2)',$
;               floor(hours), ':', floor(minutes), ':', floor(seconds)) 
return, string(format='(i2.2,a1,i2.2)',$
               floor(hours), ':', floor(minutes))
END
;------------------------------------------------------------------------------
PRO fitdata_plot, file = file, bw = bw, ticksize = ticksize

IF (n_elements(file) NE 1) THEN BEGIN
    result = pickfile( /read, get_path = path, /must_exist, $
                       filter = '*.fitdata', /fix_filter)
ENDIF ELSE BEGIN
    result = findfile(file, count = count)
    IF (count NE 1) THEN BEGIN
        print, 'Non-existent or nonunique filename'
        return
    ENDIF
    result = result(0)
ENDELSE

openr, unit, result, /get_lun

oneline = ''                    ;predefine string variables because IDL sucks
                                ;and readf will read in floats if this
                                ;is not done, even though the format
                                ;statement says to read a string 
readf, unit, oneline
IF keyword_set(bw) THEN begin
    mcolor = !p.color
    kcolor = !p.color
ENDIF ELSE BEGIN
    setcolors, c
    mcolor = c.red
    kcolor = c.blue
ENDELSE

oneline = str_sep(strcompress(oneline), ' ')

;day =         [float(oneline(0))]
timesep = str_sep(oneline(1), ':')
time =        [3600.*float(timesep(0))+60.*float(timesep(1))+float(timesep(2))]
den =         [float(oneline(2))]
sigden =      [float(oneline(3))]
temp =        [float(oneline(4))]
sigtemp =     [float(oneline(5))]
chi2 =        [float(oneline(6))]
prob =        [float(oneline(7))]
denk =        [float(oneline(8))]
sigdenk =     [float(oneline(9))]
tempk =       [float(oneline(10))]
sigtempk =    [float(oneline(11))]
kappa =       [float(oneline(12))]
sigkappa =    [float(oneline(13))]
chi2k =       [float(oneline(14))]
probk =       [float(oneline(15))]

WHILE NOT(eof(unit)) do BEGIN
oneline = ''
readf, unit, oneline

oneline = str_sep(strcompress(oneline), ' ')

;day =         [day,       float(oneline(0))]     
timesep = str_sep(oneline(1), ':')
time =        [time, $
               3600.*float(timesep(0))+60.*float(timesep(1))+float(timesep(2))]
den =         [den,       float(oneline(2))]     
sigden =      [sigden,    float(oneline(3))]  
temp =        [temp,      float(oneline(4))]    
sigtemp =     [sigtemp,   float(oneline(5))] 
chi2 =        [chi2,      float(oneline(6))]    
prob =        [prob,      float(oneline(7))]    
denk =        [denk,      float(oneline(8))]    
sigdenk =     [sigdenk,   float(oneline(9))] 
tempk =       [tempk,     float(oneline(10))]   
sigtempk =    [sigtempk,  float(oneline(11))]
kappa =       [kappa,     float(oneline(12))]   
sigkappa =    [sigkappa,  float(oneline(13))]
chi2k =       [chi2k,     float(oneline(14))]   
probk =       [probk,     float(oneline(15))]   
ENDWHILE

close, unit
free_lun, unit

a = findgen(16)*(!PI*2./16.)
usersym, .5*cos(a), .5*sin(a), /fill

;plot data
oldxtickv = !x.tickv
oldmulti = !p.multi
oldpos = !p.position
olderas = !p.noerase
oldchsz = !p.charsize
oldxticklen = !x.ticklen
oldxminor = !x.minor
oldfont = !p.font
!p.font = 0
!p.position = fltarr(4)
!p.noerase = 0
!p.multi = [0, 0, 4, 0, 0]
!p.charsize = 2
!x.ticklen = .1
!x.minor = 3
;!x.tickv = (lindgen(6)+1)/6
first_tick = time(0)
fhours   = first_tick/3600.
fminutes = (fhours - floor(fhours))*60.
fseconds = (fminutes - floor(fminutes))*60.
fhours = floor(fhours)
fminutes = floor(fminutes)
fseconds = floor(fseconds)
IF (fseconds NE 0) THEN BEGIN
    fseconds = 0
    fminutes = (((fminutes-1)+60) MOD 60)
ENDIF
fminutes = fminutes-(fminutes MOD ticksize)
first_tick = fhours*3600+fminutes*60+fseconds
    
n_times = n_elements(time)
last_tick = time(n_times-1)
lhours   = last_tick/3600.
lminutes = (lhours - floor(lhours))*60.
lseconds = (lminutes - floor(lminutes))*60.
lhours = floor(lhours)
lminutes = floor(lminutes)
lseconds = floor(lseconds)
IF (lseconds NE 0) THEN BEGIN
    lseconds = 0
    lminutes = (lminutes+1 MOD 60)
ENDIF
lminutes = lminutes - (lminutes MOD ticksize) + ticksize
last_tick = lhours*3600+lminutes*60+lseconds

dtyme = last_tick-first_tick
ndtyme = dtyme/(ticksize*60)
FOR i = 7, 2, -1 DO BEGIN
    IF ((ndtyme MOD i) EQ 0) THEN BEGIN
        nticks = i
        GOTO, gottick
    ENDIF
ENDFOR
gottick: tyme = (findgen(nticks+1)/nticks*dtyme)+first_tick

;blanks = replicate(' ', 30)

plot,tyme,tyme, /ylog, title = '!7Temperature', xticks = nticks, $
  yrange=[1e1, 1e4], /nod, xstyle=1, xtickv = tyme, xtickformat = 'myhhmmss'
oplot,time,temp, linestyle = 2, psym = 5, col = mcolor
oplot,time,tempk, psym = 8, col=kcolor
plot,tyme,tyme, linestyle = 2, /ylog, title = '!7Density', $
  yrange=[1e-3, 10], /nod, xticks = nticks, $
  xstyle=1, xtickv = tyme, xtickformat = 'myhhmmss'
oplot,time,den, psym = 5, col = mcolor
oplot,time,denk, psym = 8, col=kcolor
plot,/nod, tyme,tyme, /ylog, title = '!9k!7', yrange = [1, 100], $
  xticks = nticks, xstyle=1, xtickv = tyme, xtickformat = 'myhhmmss'
oplot,time,kappa, psym = 8, col=kcolor
xlabel = str_sep(result, '/')
plot,tyme, tyme, /ylog, title = '!9C!7!U2', /nod, xstyle = 1, $
  yrange=[.1, 1000], xtickformat='myhhmmss', $
  xtitle=xlabel(n_elements(xlabel)-1), xticks = nticks, xtickv = tyme
oplot,time,chi2, linestyle = 2, psym = 5, col = mcolor
oplot,time,chi2k, col=kcolor, psym = 8
!x.tickv = oldxtickv
!p.multi = oldmulti
!p.position = oldpos
!p.noerase = olderas
!p.charsize = oldchsz
!x.ticklen = oldxticklen
!x.minor = oldxminor
!p.font = oldfont
;stop
END
