;$Id: fittempkappa.pro,v 1.2 2002/09/04 15:39:13 jbf Exp $
FUNCTION TempFunctKappa,  x, a, f, pder
COMMON FitPassKappa, accel_p

;IF a(2) LT 0. THEN stop
arg1 = abs(x-accel_p)
brack = 1d0+a(1)*arg1/a(2)
g =  exp((-a(2)-1d0)*alog(brack))
g2 = exp((-a(2)-2d0)*alog(brack))
f = a(0)*g
dumb = where(finite(f) eq 0, num_bad)
IF ( num_bad GT 0 ) THEN BEGIN
    print, 'FitPassKappa function evaluation went wacky!'
;    stop
    return, 0
;    IF a(2) LT 0 THEN a(2) = abs(a(2)) ELSE stop
ENDIF

IF n_params() GE 4 THEN BEGIN
    pder = [[g], $
            [-a(0)*(1d0+1d0/a(2))*arg1*g2], $
            [a(0)*(a(1)*arg1*g2*(1d0+a(2))/a(2)^2 - g*alog(brack))]]
;            [a(1)*arg1*(1d0+a(2))*(f/brack)/((a(2))^2) - f*alog(brack)]]
;            [a(0)*((a(1)*arg1*g2*(1+a(2)))/a(2)^2) - f*alog(brack)]]

ENDIF
return, 1
end
;=========================================================================
FUNCTION FitTempKappa, xarr, yarr, emax, chi2 = chi2, line=fit, xline=xfit, $
                       potential = pot, temperature = temp, $
                       weight = weight, kappa = kappa, errors = errors, $
                       sigma = sig, density = den, iguess = iguess, $
                       maxw_guess = maxw_guess, probability = prob

;+
; NAME:
;       FitTempKappa
;
; PURPOSE:
;       
;       This function fits the given data to a Kappa distribution
;       function and estimate the errors in the parameters.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;       
;     retval = FitTempKappa(energy, f, 0., $
;                           weight = w, iguess=iguess, kappa = kappa, $
;                           density = denk, temperature = tempk, $
;                           sigma = sigk, line = fit2, xline = xfit, $
;                           chi2 = chi2k, /maxw_guess, probability = probk, $
;                           errors = errormode)
;
; INPUTS:
;       energy: The energy of the data point.
;               
;       f:      The value of the distribution function for the data point.
;
;       e:      The value of the centroid for the Maxwellian fit function.
;
; KEYWORD PARAMETERS:
;       chi2:   The return value for chi squared by the fitting procedure.
;
;       density: The density result found by the fit.
;
;       temperature: The temperature result found by the fit.
;
;       kappa:  The kappa parameter result found by the fit.
;
;       weight: An array of sigmas for the distribution function.  The
;               array should have the same number of elements as f and
;               energy.
;
;       iguess: An initial guess of the temperature and density.  The
;               input is a two dimensional array [igden,igtemp]
;
;       maxw_guess: A swwitch to notify routine that the guess in
;               iguess came from a maxwellian fitting routine (perhaps
;               fittempmaxw.  This helps interpretation of the initial
;               guess.
;     
;       line:   The returned values of the distribution function for
;               each energy for the fit function.
;
;       xline:  The returned values of the energy used by the fit.
;
;       sigma:  The extimated errors in the parameters.  A two
;               dimensional array.  [sigdensity, sigtemp, sigkappa].
;
;       probability: The probability that random fluctuations would produce
;               a value of chi-squared larger than chi2.
;
;       errors: The method to use in calculating the errors.  0: Use
;               the hessian returned by spcurvefit to estimate the
;               curvature near the fit values.  1: Search chi-squared
;               space for the appropriate 68% level contour.  If this
;               keyword is not passed, the errors are not calculated
;
; OUTPUTS:
;
;       result: 0 for failure, 1 for sucess
;
; COMMON BLOCKS:
;       accel_p: The value of the centroid of the fit.  This is in a
;                common block so its value can be shared with
;                TempFunctMaxwML with out making it a fit parameter.
;
; PROCEDURE:
;       
;       The non-linear marquardt-levenburg fit of a Maxwellian is
;       perfomed through use of the function spcurvefit.
;
; EXAMPLE:
;       
;       
;       IDL> Result = FitTempKappa(energy, f, 0., chi2 = chi2, den = den, $
;       IDL>             weight=(1d0/sigmaf^2), temp = temp, $
;       IDL>             line = fit1, xline = xfit, sigma = sig, prob = prob, $
;       IDL>             errors = 0)
;
;       IDL> plot, energy,f,/xlog,/ylog,psym=1 ;plot the data
;       IDL> oplot, xfig,fit1,/xlog,/ylog      ;plot the fit result
;
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;-
COMMON FitPassKappa, accel_p
IF (n_elements(errors) EQ 0) THEN errors = -1

accel_p = double(emax)

nonz = where(yarr ne 0)

xfit = double(xarr(nonz))
yfit = double(yarr(nonz))
w = double(weight(nonz))

ylog = alog(yfit)

n = n_elements(yfit)
m = 3
nu = n-m

temp =  !values.f_nan
den = !values.f_nan
kappa = !values.f_nan
pot = !values.f_nan
sig = dblarr(m)
sig(*) = !values.f_nan
chi2 = !values.f_nan
prob = !values.f_nan

IF nu GE (m+1) THEN BEGIN 
    itmax = 20

    a = dblarr(m)

    IF (n_elements(iguess) NE 3) THEN BEGIN
        ;;simple log space slope initial guess
;        a(0) = yfit(0)
;        ii = fix(n/2)
;        a(1) = -(ylog(ii)-ylog(0))/(xfit(ii)-xfit(0))
;        IF (a(1) LT 0) THEN BEGIN
;            a(1) = -(ylog(n-1)-ylog(0))/(xfit(n-1)-xfit(0))
;        ENDIF
;        a(2) = 2.5
        ;;use the mean energy as an initial guess since that is
        ;;related to K_B*T
        ;;
        ;;integrate to get the E_ave
        fave = xfit(0)*1.6e-12*yfit(0) ;crude approx for density integral from
                                ;0 to emin   
        eave = xfit(0)*1.6e-12*fave ;crude approx for energy integral from 0
                                ;to emin   
                                ;integrate from emin to emax (infinity for our purposes)
        FOR i = 0, n-2 DO BEGIN
            incr = (xfit(i+1)-xfit(i))*1.6e-12*(yfit(i+1)+yfit(i))/2.
            fave = fave + incr
            eave = eave + xfit(i)*incr*1.6e-12
        ENDFOR 
        eave = eave/fave/1.6e-12 ;in eV
        a(2) = 2.5
        ibk = exp(lngamma(a(2)+1.)-lngamma(a(2)-0.5))
        ick = 2.*a(2)/(2.*a(2)-3.)
        a(0) = ibk*(9.11d-28*a(2)/2./!pi/eave)^(1.5)/sqrt(fave)
        a(1) = ick/eave
        itemp = ick/a(1)
        iden = a(0)*(2.*!pi/a(1)*(1.6e-12/9.11e-28))^(1.5)
        print, 'initial guess for kappa (moment) temp=',itemp, $
          ';  den=', iden, '; kappa=', a(2), $
          format = '(a,f5.1,a,f7.3,a,f5.1)'

        retval = spcurvefit(xfit, yfit, w, a, curvature = curvature, $
                            FUNCTION_NAME='TempFunctKappa', chi2=chi2, $
                            iter = iter, itmax = itmax, yfit = fit) 
        IF (retval EQ 0) THEN return, 0

;;improve guess by fitting to a maxwellian
;        mguess = dblarr(2)
;        mguess(1) = 1./a(1)
;        mguess(0) = a(0)*(2.*!pi/a(1)*(1.6e-12/9.11e-28))^(1.5) ;cgs
;        ;;  eV->ergs -------------------^

;        retval = FitTempMaxw(xfit, yfit, emax, chi2=initchi2, $
;                             den = mden, temperature=mtemp, $
;                             iguess = mguess, weight=w)

;        IF (retval EQ 1) THEN BEGIN
;            ibk = exp(lngamma(a(2)+1.)-lngamma(a(2)-0.5))
;            ick = 2.*a(2)/(2.*a(2)-3.)
;            a(0) = mden*((9.11d-28/1.6e-12)*ick/2./!pi/mtemp)^(1.5)
;            a(1) = 1./mtemp
;            print, 'initial guess for kappa (MAXW) temp=', mtemp, $
;              ';  den=', mden, '; kappa=', a(2), $
;              format = '(a,f5.1,a,f7.3,a,f5.1)'

;            retval = spcurvefit(xfit, yfit, w, a, $
;                                FUNCTION_NAME='TempFunctKappa', chi2=chi2, $
;                                iter = iter, itmax = itmax, yfit = fit) 
;            IF (retval EQ 0) THEN return, 0
;        ENDIF ELSE BEGIN        ;retval eq 0
;            gtemp = 1./a(1)
;            gden = a(0)*(2.*!pi/a(1)*(1.6e-12/9.11e-28))^(1.5)
;            print, 'initial guess for kappa (linear MAXW) temp=',gtemp, $
;              ';  den=', gden, '; kappa=', a(2), $
;              format = '(a,f5.1,a,f7.3,a,f5.1)'

;            retval = spcurvefit(xfit, yfit, w, a, $
;                                FUNCTION_NAME='TempFunctKappa', chi2=chi2, $
;                                iter = iter, itmax = itmax, yfit = fit) 
;            IF (retval EQ 0) THEN return, 0
;        ENDELSE 
;; end of maxwellian guess improvement code
    ENDIF ELSE BEGIN
        IF (NOT keyword_set(maxw_guess)) THEN BEGIN
            print, 'initial guess for kappa (user) temp=', iguess(1), $
              ';  den=', iguess(0), '; kappa=', iguess(2), $
              format = '(a,f5.1,a,f7.3,a,f5.1)'

            ig = double(iguess)
            ibk = exp(lngamma(ig(2)+1.)-lngamma(ig(2)-0.5))
            ick = 2.*ig(2)/(2.*ig(2)-3.)
            a(0) = ig(0)*ibk*((9.11d-28/1.6e-12)*ick/2./!pi/ig(2)/ig(1))^(1.5)
            a(1) = double(2.*ig(2)/(2.*ig(2)-3.)/ig(1))
            a(2) = double(ig(2))

            retval = spcurvefit(xfit, yfit, w, a, curvature = curvature,$
                                FUNCTION_NAME='TempFunctKappa', chi2=chi2, $
                                iter = iter, itmax = itmax, yfit = fit) 
            IF (retval EQ 0) THEN return, 0
        ENDIF ELSE BEGIN
            print, 'initial guess for kappa (user MAXW) temp=', iguess(1), $
              ';  den=', iguess(0), '; kappa=', iguess(2), $
              format = '(a,f5.1,a,f7.3,a,f5.1)'

            ig = double(iguess)
            ibk = exp(lngamma(ig(2)+1.)-lngamma(ig(2)-0.5))
            ick = 2.*ig(2)/(2.*ig(2)-3.)
            a(0) = ig(0)*((9.11d-28/1.6e-12)*ick/2./!pi/ig(1))^(1.5)
            a(1) = 1./ig(1)
            a(2) = double(ig(2))

            retval = spcurvefit(xfit, yfit, w, a, curvature = curvature, $
                                FUNCTION_NAME='TempFunctKappa', chi2=chi2, $
                                iter = iter, itmax = itmax, yfit = fit) 
            IF (retval EQ 0) THEN return, 0
        ENDELSE
    ENDELSE
    
    pot = accel_p
    
    ck = 2.*a(2)/(2.*a(2)-3.)
    temp = ck/a(1)
    
    ak = exp(lngamma(a(2)-0.5)-lngamma(a(2)+1.))
    bk = (2.*!pi*a(2)*(1.6e-12/9.11e-28)/a(1))^(1.5)
    den = a(0)*ak*bk
    kappa = a(2)

    IF (errors EQ 0) THEN BEGIN 
        ;;estimate errors by using curvature matrix (see scudder write
        ;;up on fitting routines for the best explaination of this and
        ;;Press sec.  15.6
        ;;
        ;;find the sigmas associated with the desired _joint_
        ;;confidence level. For the 68% confidence level this is 1.00
        ;;for one degree of freedom, 2.30 for two degrees of freedom,
        ;;and 3.53 for three degrees of freedom.  See page 212 in
        ;;Bevington or sec 15.6 in Press et al.  get the correct
        ;;dchisquare limit for the current nu (degrees of freedom) and
        ;;the desired confidence limit 1sigma=68.3% dchisq_lim =
        ;;confidence(68.3, m)
        variance = dblarr(m)
        sig = dblarr(m)
        cm = curvature*2.       ;the hessian matrix
        tau = dblarr(m)
        xi = dblarr(m, m)
        omega = dblarr(m)
        denom = dblarr(m)
        FOR l = 0, m-1 DO BEGIN
            FOR i = 0, m-1 DO BEGIN
                ;;tau(i) = -(cm(i, l) - (1.+cm(i, l))*(i EQ l))
                ;;rewrite to make insusceptible to problems when cm
                ;;adding 1 to cm is below precision.
                tau(i) = -(cm(i,l)*(1-(i eq l))-(i eq l)) 
                FOR j = 0, m-1 DO BEGIN
                    ;;rewrite to make insusceptible to round-off problems 
                    ;;xi(i,j) = cm(i,j) - cm(i,j)*(i EQ l) - cm(i,j)*(j EQ l)+$
                    ;;  (1.+cm(i, j))*(i EQ j)*(i EQ l)*(j EQ l)
                    xi(i,j) = cm(i,j)*(1 - (i EQ l) - (j EQ l) + $
                                       (i EQ j)*(i EQ l)*(j EQ l)) + $
                      (i EQ j)*(i EQ l)*(j EQ l)
                ENDFOR
            ENDFOR
            omega= invert(xi) ## tau
            FOR i = 0, m-1 DO BEGIN
                FOR j = 0, m-1 DO BEGIN
                    denom(l) = denom(l)+cm(i, j)*omega(i)*omega(j)
                ENDFOR
            ENDFOR
            variance(l) = sqrt(3.53/denom(l))
        ENDFOR

        dnda0 = ak*bk
        dnda1 = -1.5*a(0)*1.6e-12/a(1)*ak*bk
        ;;if kappa is very very large, set dnda2 to zero, because the
        ;;variance calculation method breaks down in this limit, and
        ;;dnda2 should go to zero to cancel the large variance.
        IF (a(2) LT 10000.) THEN BEGIN 
            dnda2 = a(0)*ak*bk*(polygamma(a(2)-.5) - polygamma(a(2)+1.) + $
                                1.5/a(2))
        ENDIF ELSE BEGIN
            dnda2 = 0.
        ENDELSE

        sig(0) = sqrt((variance(0)*dnda0)^2+(variance(1)*dnda1)^2 +$
                      (variance(2)*dnda2)^2)
        sig(1) = sqrt((variance(1)*(-ck/a(1)^2))^2 + $
                      (variance(2)*(2./a(1)/(2.*a(2)-3.) - $
                                    2.*ck/a(1)/(2.*a(2)-3.)))^2)
        sig(2) =  variance(2)
    ENDIF ELSE IF (errors EQ 1) THEN BEGIN 
        ;;estimate errors by forming delta chi squared surface
        print, 'Computing Errors...'
        xsz = 31
        xof = (xsz-1)/2
        ysz = 31
        yof = (ysz-1)/2
        zsz = 21
        zof = (ysz-1)/2
        ;;param 1 range in amp
        asamp = (dindgen(xsz)-xof)/xof*0.50*a(0) + a(0)
        bsamp = (dindgen(ysz)-yof)/yof*0.50*a(1) + a(1)
        csamp = (dindgen(zsz)-zof)/zof*1.00*a(2) + a(2)
        ;; adjust this fraction --------^ to pick the relative size of the
        ;; chisquared space constructed (1/2 is an approximate guess, but
        ;; one needs to judge this number by balancing the average width
        ;; of the dchisquare surface at the level for the specified joint
        ;; or single parameter confidence level and the resolution of the
        ;; surfaces required in order to see said level)

        ;; calculated in call to spcurvefit:    chi2 = total(w*(yfit-fit)^2)/nu
        dchisquare = dblarr(xsz, ysz, zsz)
        arg1 = abs(xfit-accel_p)
        FOR k = 0, zsz-1 DO BEGIN
            FOR j = 0, ysz-1 DO BEGIN
                FOR i = 0, xsz-1 DO BEGIN
                    ;;kappa form
                    yf = asamp(i)*exp((-csamp(k)-1.)*$
                                      alog(1.+bsamp(j)*arg1/csamp(k)))
                    dchisquare(i, j, k) = total(w*(yfit-yf)^2) - chi2*nu
                ENDFOR
                ;; maxwellian form
                ;; yf = asamp(i)*exp(-bsamp(j)*(xfit(0:npts-1)-pot))
                ;; dchisquare(i, j) = total(w*(yfit(0:npts-1)-yf)^2) - chi2*nu
            ENDFOR
        ENDFOR

        ;;here are some commands to view the dchi-square surfaces
        ;;contour,reform(dchisquare(*,*,zof)),asamp,bsamp,$
        ;;        levels=[0,.1,1,2.3,3.53,10],/follow 
        ;;contour,reform(dchisquare(*,yof,*)),asamp,csamp,$
        ;;        levels=[0,.1,1,2.3,3.53,10],/follow 
        ;;contour,reform(dchisquare(xof,*,*)),bsamp,csamp,$
        ;;        levels=[0,.1,1,2.3,3.53,10],/follow 
        ;; ----------or--------- 
        ;;COMMON volume_data, aaaa
        ;; aaaa = bytscl(dchisquare)
        ;; slicer
        ;;
        ;;find the sigmas associated with the desired _joint_ confidence
        ;;level. dchisquare obeys chisquared statistics for the number of
        ;;degrees of freedom specified by the number of parameters jointly
        ;;varied.  For the 68% confidence level this is 1.00 for one
        ;;degree of freedom, 2.30 for two degrees of freedom, and 3.53 for
        ;;three degrees of freedom.  See page 212 in Bevington or sec 15.6
        ;;in Press et al.
        ;;
        ;;delta_reg = where(dchisquare LT 2.30)
        ;;dchisq_lim = confidence(68.3, m)
        delta_reg = where(dchisquare LT 3.53)
        ;; 

        IF (delta_reg(0) NE -1) THEN BEGIN
            ;;find the coordinates of the delta_reg surface in
            ;;(cora,corb,corc) space 
            cora = delta_reg mod xsz
            corb = delta_reg mod (xsz*ysz)/xsz
            corc = delta_reg/(xsz*ysz)

            mina = min(asamp) & maxa = max(asamp)
            minb = min(bsamp) & maxb = max(bsamp)
            minc = min(csamp) & maxc = max(csamp)
            dumb = where(((mina EQ asamp(cora)) OR (maxa EQ asamp(cora)) OR $
                          (mina EQ bsamp(corb)) OR (maxb EQ bsamp(corb)) OR $
                          (mina EQ csamp(corc)) OR (maxc EQ csamp(corc)) ), nnn)
            IF (nnn NE 0) THEN BEGIN
                print, 'Sampled dchisquare surface may not be big enough '+ $
                  'in fittempkappa.'
                print, 'Reported sigmas are lower limits on the true sigma.'
            ENDIF

            variance = [(max(asamp(cora))-min(asamp(cora)))/2., $
                        (max(bsamp(corb))-min(bsamp(corb)))/2., $
                        (max(csamp(corc))-min(csamp(corc)))/2.]
            sig = variance

            dk = 0.01
            dnda0 = ak*bk
            dnda1 = -1.5*a(0)*1.6e-12/a(1)*ak*bk
            ;;if kappa is very very large, set dnda2 to zero, because the
            ;;variance calculation method breaks down in this limit, and
            ;;dnda2 should go to zero to cancel the large variance.
            IF (a(2) LT 10000.) THEN BEGIN 
                dnda2 = a(0)*ak*bk*(polygamma(a(2)-.5) - polygamma(a(2)+1.) + $
                                    1.5/a(2))
            ENDIF ELSE BEGIN
                dnda2 = 0.
            ENDELSE
            
            sig(0) = sqrt((variance(0)*dnda0)^2+(variance(1)*dnda1)^2 +$
                          (variance(2)*dnda2)^2)
            sig(1) = sqrt((variance(1)*(-ck/a(1)^2))^2 + $
                          (variance(2)*(2./a(1)/(2.*a(2)-3.) - $
                                        2.*ck/a(1)/(2.*a(2)-3.)))^2)
            sig(2) =  variance(2)
        ENDIF ELSE BEGIN
            sig = fltarr(3)
            sig(*) = !values.f_nan
        ENDELSE
    ENDIF ELSE BEGIN
        sig = replicate(!values.f_nan, m)
    ENDELSE 

    amp = a(0)
    kappa = a(2)
    
    prob = (1.-igamma(nu/2., chi2*nu/2.))*100.

    return, 1                   ; since f= A exp (-3 m v^2 / (2KT)), 
                                ;        = A exp (-3E/2KT)
                                ;   log f= log A - 3E/2KT
                                ; temperature is therefore -3/2/a(1)
ENDIF

return, 0

END

