;$Id: init_fitf.pro,v 1.2 2002/09/04 15:39:13 jbf Exp $
PRO init_fitf, path, t0, state, group = group, papco = papco, window = window
;+
; NAME:
;       init_fitf
;
; PURPOSE:
;       
;       This procedure creates and initializes the state vector for a
;       hydra_fitf slice widget.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;
;    init_fitf, path, t0, state, group = group, papco = papco, window = window
;
; INPUTS:
;       path:  The date to display data for in the form 'yyyymmdd'.
;
;       t0:    The time to display data for in the form 'hh:mm:ss'.
;
; KEYWORD PARAMETERS:
;       papco:   A swwitch to tell the widget that papco is the caller.
;
;       group:   A variable containing the group id of the caller.
;                Thus, if the calling widget is destroyed, this widget
;                and all its children will be destroyed too.
;               
;       window:  The number of the papco draw window which called this
;                program. 
;
;
; OUTPUTS:
;
;       state:   Return the initialized state vector.
;
; OPTIONAL OUTPUTS:
;       Describe optional outputs here.  If the routine doesn't have any, 
;       just delete this section.
;
; EXAMPLE:
;
;           IDL> init_fitf, '960529', '19:00:00', state, group=group_leader
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;       Thu Apr 20 15:55:27 2000, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Cast version 1.11.
;
;       Tue Mar 16 21:42:07 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Cast version 1.10.
;
;       Sun Feb 21 15:35:56 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Cast version 1.09.
;
;       Sun Feb 21 15:18:28 1999, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;               Update comment block to be consistent with new use of
;               four character year string instead of old two
;               character year string.
;
;       Fri Sep 11 12:17:19 1998, Eric E. Dors <edors@universe.lanl.gov>
;
;               Fixed printing bug in print_window.pro relating to the
;               use of the obsolete parameter group.
;               Cast "version 1.08".
;
;       Wed Sep 9 08:44:08 1998, Eric E. Dors <edors@universe.lanl.gov>
;
;               Fixed bug in user_hydra_fitf_hydra_spec.pro.
;               Cast "version 1.07".
;
;       Thu Aug 27 16:32:18 1998, Eric E. Dors <edors@universe.lanl.gov>
;
;               Added missing file time_stamp.pro to distribution.
;               Default diagnostic popup windows now disabled by default.
;               Cast "version 1.06".
;
;       Fri Apr 10 13:56:38 1998, Eric Dors <eed@cis>
;
;               Fixed bug in fitf_plot.pro.  Cast "version 1.05".
;
;       Tue Apr 7 00:05:12 1998, Eric Dors <eed@cis>
;
;               Fixed bug in fitf_control.pro. Cast "version 1.04".
;
;       Thu Apr 2 17:01:10 1998, Eric Dors <eed@wind>
;
;               Fixed bug in generating helpfile name for hydra_fitf.pro
;               and fitf_control.pro. Cast "version 1.03".  
;
;       Mon Mar 16 14:46:14 1998, Eric Dors <eed@cis>
;
;               Bug in fitf_plot fixed having to do with foreground
;               and background colors.  Cast "version 1.02".
;
;       Mon Mar 16 11:08:16 1998, Eric Dors <eed@cis>
;
;               Bug fix in hydra_fif and fitf_read, cast "version 1.01". 
;
;       Mon Mar 9 19:36:39 1998, Eric Dors <eed@cis.physics.uiowa.edu>
;
;               Changed the structure names to make them more unique.
;
;-

ver = 1.11
ver_string = strtrim(ver, 1)
ver_string = strmid(ver_string, 0, 4)

init_level1, path, block_data, mode_info
ele0 = where(mode_info.energy(*, 0) LT 0)
eonec = abs(float(mode_info.energy(ele0, 0)))
fonec = float(mode_info.facv4(ele0, 0))
faconec = fonec(0)*eonec(0)^2

;set the parent_id to the group value passed or the very top level widget
IF (n_elements(group) NE 0) THEN parent_id=group ELSE parent_id=0

IF (n_elements(window) eq 0) THEN window=0

fitf_cntl_ids = {fitf_cntl_ids, $
                 species_buttons: -1L, $ ;species select base id
                 xstyle_buttons: -1L, $ ; xstyle select base id
                 ystyle_buttons: -1L, $ ; ystyle select base id
                 emin: -1L, $   ;energy min select base id
                 emax: -1L, $   ;energy max select base id
                 zmin: -1L, $   ;dist f min select base id
                 zmax: -1L, $   ;dist f max select base id
                 abin: -1L, $   ;angle bin size select base id
                 asel: -1L, $   ;angle bin select base id
                 asel_base: -1L, $ ;base id of asel, to control visibility
                 ebin: -1L, $   ;energy bin size select base id
                 nfrag: -1L, $  ;number of segments select base id
                 seg_idx: -1L, $ ;segment select base id
                 seg_base: -1L, $ ;baseid to of seg_idx to control visibility
                 fitmin: -1L,$  ;fit energy min select base id
                 fitmax: -1L, $ ;fit energy max select base id
                 errors_buttons: -1L, $ ;error method select base id
                 diag_buttons: -1L,$ ;diagnostics swwitch base id
                 correct_buttons: -1L, $ ;count correct select base id
                 potential_buttons: -1L, $ ;potential subtract select base id
                 ofilename: -1L, $ ;output filename widget id
                 ofile_buttons: -1L, $ ;output file button base id
                 ofile_bnames: ['Open File', 'Close File'], $ ;names for button
                 errlabel:['Curvature', 'Chi2 Search'], $ ;names for error style                 
                 errlabelg:['Curvature', '!MX!3!E2!N Search'], $ ;errlabel for graphis output
                 diaglabel:['Off', 'On']} ;diagnostics labels

fitf_args = {fitf_args, $
             path: path, $      ;requested date of plot
             t0: t0}            ;requested time of plot

fitf_mode_ele = {fitf_mode, $
                 prev: 0, $     ;prev block request(set in hydra_fitf_event)
                 next: 0, $     ;next block request(set in hydra_fitf_event)
                 zrange: [1e-34, 1e-24], $ ;current dist funct range
                 erange: [1., 2e4], $ ;current range of energies to plot
                 fitrange: [1., 2e4], $;range of energies to fit
                 dalph: 4., $   ;number of angular bins
                 ahigh: 180., $ ;maximum angular bin size
                 alow: 4., $    ;minimum angular bin size
                 asel: 1, $     ;which angular bin to use
                 den: 0.06, $   ;energy resolution to average to
                 denlow: 0.06, $ ;minimum energy resolution
                 denhigh: 1., $ ;maximum energy resolution
                 zhigh: 1e-10, $ ;max dist funct plot range
                 zlow: 1e-37, $ ;min dist funct plot range      
                 ehigh: 100000., $ ;max energy plot range
                 elow: 0., $    ;min energy plot range
                 normpos: [0.15, 0.1, .95, 0.95], $;default plot position
                 hres: 1, $     ;number of sub-blocks
                 seg_idx: 0, $  ;current sub-block
                 xlog: 1, $     ;x linear or log (0:lin,1:log)
                 ylog: 1, $     ;y linear or log (0:lin,1:log)
                 errors:0, $    ;error calculate style (0:curve,1:chi2 search)
                 diag:0, $      ;plot diagnostics flage (0: off, 1: on)
                 correct: 1, $  ;use corrected counts (0: no, 1:yes)
                 potential: 1, $ ;subtract s/c pot. (0: no, 1: yes)
                 fileunit: -1, $ ;output file unit
                 filename: ''}  ;output file name                            

fitf_mode_ion = {fitf_mode, $
                 prev: 0, $     ;prev block request(set in hydra_fitf_event)
                 next: 0, $     ;next block request(set in hydra_fitf_event)
                 zrange: [1e-34, 1e-20], $ ;current dist funct range
                 erange: [1., 2e4], $ ;current range of energies to plo
                 fitrange: [1., 2e4], $ ;range of energies to fit
                 dalph: 4., $   ;number of angular bins
                 ahigh: 180., $ ;maximum angular bin size       
                 alow: 4., $    ;minimum angular bin size       
                 asel: 1, $     ;which angular bin to use       
                 den: 0.06, $   ;energy resolution to average to
                 denlow: 0.06, $ ;minimum energy resolution     
                 denhigh: 1., $ ;maximum energy resolution      
                 zhigh: 1e-10, $ ;max dist funct plot range     
                 zlow: 1e-37, $ ;min dist funct plot range
                 ehigh: 100000., $ ;max energy plot range
                 elow: 0., $    ;min energy plot range
                 normpos: [0.15, 0.1, 0.95, 0.95], $ ;default plot position
                 hres: 1, $     ;number of sub-blocks                        
                 seg_idx: 0, $  ;current sub-block                           
                 xlog: 1, $     ;x linear or log (0:lin,1:log)               
                 ylog: 1, $     ;y linear or log (0:lin,1:log)               
                 errors:0, $    ;error calculate style (0:curve,1:chi2 search)
                 diag:0, $      ;plot diagnostics flage (0: off, 1: on)      
                 correct: 1, $  ;use corrected counts (0: no, 1:yes)         
                 potential: 1, $ ;subtract s/c pot. (0: no, 1: yes)          
                 fileunit: -1, $ ;output file unit                           
                 filename: ''}  ;output file name                            

fitf_info = {fitf_info, $
             ver: ver, $        ;version of the hydra_fitf package (float)
             ver_string: ver_string} ;text form of the version info.

state = {fitf_state, $
         cw_ids: fitf_cntl_ids, $ ;a substructure holding control widget ids
         papco: keyword_set(papco), $ ;is the caller
         window: -1, $          ;papco window number for this state vector
         select: 0, $           ;electron or ion mode
         species: ['Electrons', 'Ions'], $ ; mode labels
         winidx: -1, $          ;plot window id
         parent_id: parent_id, $ ;parent window widget id
         base_id: -1L, $        ;hydra_fitf  widget id 
         control_id: -1L, $     ;control widget id
         draw_x: 500, $         ;default draw widget size
         draw_y: 500, $         ;default draw widget size
         min_xsz: -1L, $        ;minimum allowed xsize of the hydra_fitf window
         min_ysz: -1L, $        ;minimum allowed ysize of the hydra_fitf window
         mode: [fitf_mode_ele, fitf_mode_ion], $ ;plot state settings
         info: fitf_info, $     ;version info
         args: fitf_args, $     ;date and time of last click in spec panel 
         faconec: faconec, $    ;distribution function at one count level
         slice_draw: -1L, $     ;draw widget base id
         button_base: -1L}      ;button bar widget id
         

END

