FUNCTION setcolors
;+
; NAME:
;       setcolors
;
; PURPOSE:
;       This procedure tries to find the 9 nine basic colors in the
;       current colormap.
;
; CATEGORY:
;       Utilitiy
;
; CALLING SEQUENCE:
;
;       cs = setcolors()
;
; OUTPUTS:
;       
;       cs:    A structure containing the color indices of black, red, 
;              green, blue, cyan, magenta, yellow, grey, and white; if 
;              they could be found in the current color table.
;
; PROCEDURE:
;       The RGB values of the color table are searched for 9 basic
;       colors.  The color table indices of these colors are returned, 
;       or -1, if the color wasn't found.  
;
;       This code was built for experimentation, it was written in an
;       rather brute force fasion.  It may be more sucessful in
;       another color space, I hope to try this in the future.
;
; EXAMPLE:
;
;               cs = setcolors()
;
; Written by:   Eric E. Dors, 29 March 1999.
;
; MODIFICATION HISTORY:
;
;-

  cs={ white:0, black:0, yellow:0, magenta:0, cyan:0, $
       red:0, green:0, blue:0, grey:0, colortable:intarr(2) }

  red_arr=bytarr(!d.table_size)
  green_arr=bytarr(!d.table_size)
  blue_arr=bytarr(!d.table_size)

  tvlct, /get, r, g, b
    
  cs.black  =(where((r EQ   0) AND (b EQ   0) AND (g EQ   0)))(0)
  cs.red    =(where((r EQ 255) AND (b EQ   0) AND (g EQ   0)))(0) 
  cs.green  =(where((r EQ   0) AND (b EQ   0) AND (g EQ 255)))(0)
  cs.blue   =(where((r EQ   0) AND (b EQ 255) AND (g EQ   0)))(0)
  cs.cyan   =(where((r EQ   0) AND (b EQ 255) AND (g EQ 255)))(0)
  cs.magenta=(where((r EQ 255) AND (b EQ 255) AND (g EQ   0)))(0)
  cs.yellow =(where((r EQ 255) AND (b EQ   0) AND (g EQ 255)))(0)
  cs.grey   =(where((r EQ 200) AND (b EQ 200) AND (g EQ 200)))(0)
  cs.white  =(where((r EQ 255) AND (b EQ 255) AND (g EQ 255)))(0)

  deltafuzz = 10
  botfuzz = 50
  topfuzz = 200
  IF cs.black EQ -1 THEN BEGIN
      tmpcolor = where( (r le botfuzz) AND (b LE botfuzz) AND (g LE botfuzz), $
                        n_hits)
      cs.black = tmpcolor(n_hits/2)
  ENDIF
  IF cs.red EQ -1 THEN BEGIN
      tmpcolor = where((r GE topfuzz) AND (b LE botfuzz) AND (g LE botfuzz), $
                       n_hits)
      cs.red = tmpcolor(n_hits/2)
  ENDIF

  IF cs.green EQ -1 THEN BEGIN
      tmpcolor = where((r LE botfuzz) AND (b LE botfuzz) AND (g GE topfuzz), $
                       n_hits)
      cs.green = tmpcolor(n_hits/2)
  ENDIF
  IF cs.blue EQ -1 THEN BEGIN
      tmpcolor = where((r LE botfuzz) AND (b GE topfuzz) AND (g LE botfuzz), $
                       n_hits)
      cs.blue  = tmpcolor(n_hits/2)
  ENDIF
  IF cs.cyan EQ -1 THEN BEGIN
      tmpcolor = where((r LE botfuzz) AND (b GE topfuzz) AND (g GE topfuzz), $
                       n_hits)
      cs.cyan = tmpcolor(n_hits/2)
  ENDIF
  IF cs.magenta EQ -1 THEN BEGIN
      tmpcolor = where((r GE topfuzz) AND (b GE topfuzz) AND (g LE botfuzz), $
                       n_hits)
      cs.magenta = tmpcolor(n_hits/2)
  ENDIF
  IF cs.yellow EQ -1 THEN BEGIN
      tmpcolor = where((r GE topfuzz) AND (b LE botfuzz) AND (g GE topfuzz), $
                       n_hits)
      cs.yellow = tmpcolor(n_hits/2)
  ENDIF
  IF cs.grey EQ -1 THEN BEGIN
      tmpcolor = where( ((r GT 200-deltafuzz) AND (r LT deltafuzz*200+deltafuzz)) AND $
                         ((b GT 200-deltafuzz) AND (b LT deltafuzz*200+deltafuzz)) AND $
                          ((g GT 200-deltafuzz) AND (g LT deltafuzz*200+deltafuzz)), $
                        n_hits)
      cs.grey  = tmpcolor(n_hits/2)
  ENDIF
  IF cs.white EQ -1 THEN BEGIN
      tmpcolor = where((r GE topfuzz) AND (b GE topfuzz) AND (g GE topfuzz), $
                       n_hits)
      cs.white = tmpcolor(n_hits/2)
  ENDIF

  return, cs
end

