;$Id: time_stamp.pro,v 1.1.1.1 2002/04/10 15:24:56 jbf Exp $
PRO Time_stamp, OPTstring
;+
; NAME:
;       time_stamp
;
; PURPOSE:
;       
;       This function marks the date and time of a plot creation and
;       optionally a string associated with the plot on the middle
;       right side of the output.
;
; CATEGORY:
;       utility funcitons
; 
; CALLING SEQUENCE:
;       
;       time_stamp, OPT_string
;
; OPTIONAL INPUTS:
;       OPTstring:  An optional string to appear after the date and time.
;       
; SIDE EFFECTS:
;       The time and date of the are written to the current output device.
;
; EXAMPLE:
;
;       plot, findgen(100)
;       time_stamp, 'generated by command: plot,findgen(100)'
;
; Written by:   Bill Peria, Date ?.
;
; MODIFICATION HISTORY:
;
;       Thu Aug 27 16:26:57 1998, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Removed special handeling for VT330's.
;
;-

sz = size(stamp)
IF (sz(0) EQ 0) THEN BEGIN
    stamp = 'plotted : '+systime()
ENDIF ELSE BEGIN
    stamp = 'plotted : '+systime()+'  OPTstring: '+ OPTstring
endelse    

chsize = 0.5
xpos = 1.0

xyouts, xpos, 0.5, /normal, /noclip, orient = 90.0, align = 0.5, size = chsize, stamp

return
END
