PRO fv_control_event, event

COMMON control_info, control_id, winidx, state, $
  species_store, control_ele, control_ion

fv_input = state
fv_input_set = fv_input

widget_control, event.id, get_uvalue = control_string

CASE control_string OF 
    'species': $
      BEGIN
        IF event.value EQ 0 THEN BEGIN
            fv_input_set.control = control_ele
            fv_input_set.species.ele = 1
            fv_input_set.species.ion = 0
            widget_control, event.top, /destroy
        ENDIF ELSE BEGIN
            fv_input_set.control = control_ion
            fv_input_set.species.ele = 0
            fv_input_set.species.ion = 1
            widget_control, event.top, /destroy
        ENDELSE
     END
    'zselect': $
    CASE event.value OF
        0: $
          BEGIN
            fv_input_set.control.dflux = 0
            fv_input_set.control.deflux = 0
          END
        1: $
          BEGIN
            fv_input_set.control.dflux = 1
            fv_input_set.control.deflux = 0
          END
        2: $
          BEGIN
            fv_input_set.control.dflux = 0
            fv_input_set.control.deflux = 1
          END
    ENDCASE
    'zmin': $
      fv_input_set.control.zmin = event.value
    'zmax': $
      fv_input_set.control.zmax = event.value
    'vxrange1': $
      fv_input_set.control.vxrange(0) = event.value
    'vxrange2': $
      fv_input_set.control.vxrange(1) = event.value
    'vyrange1': $
      fv_input_set.control.vyrange(0) = event.value
    'vyrange2': $
      fv_input_set.control.vyrange(1) = event.value
    'abin': $
      fv_input_set.control.dalph = event.value
    'ebin': $
      fv_input_set.control.den = event.value
    'lowcnt': $
      fv_input_set.control.lowcnt = event.value
    'close': $
      BEGIN
        widget_control, event.top, /destroy
        return
      END
    'ncon': $
      fv_input_set.control.ncon = event.value
    'convect': $
      IF event.value EQ 0 THEN BEGIN
        fv_input_set.control.convect = 1
    ENDIF ELSE BEGIN
        fv_input_set.control.convect = 0
    ENDELSE
    'nfrag':$
      BEGIN
        fv_input_set.control.hres = event.value
        fv_input_set.control.seg_idx = 0
      END
    'seg_idx':$
      fv_input_set.control.seg_idx = event.value
ELSE: return
ENDCASE

state = fv_input_set
IF state.species.ele THEN BEGIN
    control_ele = state.control
ENDIF ELSE BEGIN
    control_ion = state.control
ENDELSE
species_store = state.species

fv_control, state

END

