PRO fv_fragment, z_ele_to_tot, z_ion_to_tot, nfrag, $
                 z_ele_to_array, z_ion_to_array

ndet = 12
IF nfrag NE 0 THEN BEGIN
    n_ele = long(z_ele_to_tot.n_ele/nfrag)
    n_ion = long(z_ion_to_tot.n_ion/nfrag)
ENDIF ELSE BEGIN
    print, 'FV_FRAGMENT:  zero fragments selected.  Setting number of'
    print, 'fragments equal to one....'
    n_ele = long(z_ele_to_tot.n_ele)
    n_ion = long(z_ion_to_tot.n_ion/nfrag)
ENDELSE

IF n_ele EQ 0 THEN n_ele = 1
IF n_ion EQ 0 THEN n_ion = 1

z_ele_to_frag = {$
            time_ele: dblarr(n_ele), $
            theta_ele: fltarr(n_ele, ndet), $
            phi_ele: fltarr(n_ele, ndet), $
            thetab_ele: fltarr(n_ele, ndet), $
            phib_ele: fltarr(n_ele, ndet), $
            bvalid: intarr(n_ele), $
            bflags: intarr(n_ele), $
            alpha_ele: fltarr(n_ele, ndet), $
            energy_ele: fltarr(n_ele, ndet), $
            energy_ele_old: fltarr(n_ele, ndet), $
            z_ele: dblarr(n_ele, ndet), $
            dm_ele: bytarr(n_ele, ndet), $
            idx_ele: intarr(n_ele), $
            n_ele: 0 $
           }

z_ion_to_frag = {$
            time_ion: dblarr(n_ion), $
            theta_ion: fltarr(n_ion, ndet), $
            phi_ion: fltarr(n_ion, ndet), $
            thetab_ion: fltarr(n_ion, ndet), $
            phib_ion: fltarr(n_ion, ndet), $
            bvalid: intarr(n_ion), $
            bflags: intarr(n_ion), $
            alpha_ion: fltarr(n_ion, ndet), $
            energy_ion: fltarr(n_ion, ndet), $
            energy_ion_old: fltarr(n_ion, ndet), $
            z_ion: dblarr(n_ion, ndet), $
            dm_ion: bytarr(n_ion, ndet), $
            idx_ion: intarr(n_ion), $
            n_ion: 0 $
           }

z_ele_to_array = replicate(z_ele_to_frag, nfrag)
z_ion_to_array = replicate(z_ion_to_frag, nfrag)

FOR i = 1, nfrag DO BEGIN
    z_ele_to_array(i-1).time_ele = $
      z_ele_to_tot.time_ele(n_ele*(i-1):n_ele*i-1)
    z_ele_to_array(i-1).theta_ele = $
      z_ele_to_tot.theta_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).phi_ele = $
      z_ele_to_tot.phi_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).thetab_ele = $
      z_ele_to_tot.thetab_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).phib_ele = $
      z_ele_to_tot.phib_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).alpha_ele = $
      z_ele_to_tot.alpha_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).energy_ele = $
      z_ele_to_tot.energy_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).energy_ele_old = $
      z_ele_to_tot.energy_ele_old(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).z_ele = $
      z_ele_to_tot.z_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).dm_ele = $
      z_ele_to_tot.dm_ele(n_ele*(i-1):n_ele*i-1, *)
    z_ele_to_array(i-1).idx_ele = $
      z_ele_to_tot.idx_ele(n_ele*(i-1):n_ele*i-1)
    z_ele_to_array(i-1).n_ele = n_ele
    z_ele_to_array(i-1).bvalid = $
      z_ele_to_tot.bvalid(n_ele*(i-1):n_ele*i-1)
    z_ele_to_array(i-1).bflags = $
      z_ele_To_tot.bflags(n_ele*(i-1):n_ele*i-1)

    z_ion_to_array(i-1).time_ion = $
      z_ion_to_tot.time_ion(n_ion*(i-1):n_ion*i-1)
    z_ion_to_array(i-1).theta_ion = $
      z_ion_to_tot.theta_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).phi_ion = $
      z_ion_to_tot.phi_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).thetab_ion = $
      z_ion_to_tot.thetab_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).phib_ion = $
      z_ion_to_tot.phib_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).alpha_ion = $
      z_ion_to_tot.alpha_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).energy_ion = $
      z_ion_to_tot.energy_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).energy_ion_old = $
      z_ion_to_tot.energy_ion_old(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).z_ion = $
      z_ion_to_tot.z_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).dm_ion = $
      z_ion_to_tot.dm_ion(n_ion*(i-1):n_ion*i-1, *)
    z_ion_to_array(i-1).idx_ion = $
      z_ion_to_tot.idx_ion(n_ion*(i-1):n_ion*i-1)
    z_ion_to_array(i-1).n_ion = n_ion
    z_ion_to_array(i-1).bvalid = $
      z_ion_to_tot.bvalid(n_ion*(i-1):n_ion*i-1)
    z_ion_to_array(i-1).bflags = $
      z_ion_to_tot.bflags(n_ion*(i-1):n_ion*i-1)
ENDFOR

END


