PRO fv_pitch_to_vel, species, xgrid, ygrid, zgrid, vxgrid, vygrid, vzgrid, $
                     speed_low_meas, xraw, yraw, xrawv, yrawv

IF species LT 0 THEN BEGIN
    mass = 9.11d-28
ENDIF ELSE BEGIN
    mass = 1.67d-24
ENDELSE

ndata = n_elements(zgrid)

vmag = sqrt(2.*ygrid*1.6d-19*1d7/mass)
vmag_raw = sqrt(2.*yraw*1.6d-19*1d7/mass)
speed_low_meas = min(vmag)
xrawv = vmag_raw*cos(xraw)
yrawv = vmag_raw*sin(xraw)

vxgrid1 = vmag*cos(xgrid)
vygrid1 = vmag*sin(xgrid)
vzgrid1 = zgrid

vxgrid2 = vxgrid1
vygrid2 = -vygrid1
vzgrid2 = vzgrid1

vxgrid = dblarr(2*ndata)
vygrid = dblarr(2*ndata)
vzgrid = dblarr(2*ndata)

vxgrid(0:ndata-1) = vxgrid1
vygrid(0:ndata-1) = vygrid1
vzgrid(0:ndata-1) = vzgrid1

vxgrid(ndata:2*ndata-1) = vxgrid2
vygrid(ndata:2*ndata-1) = vygrid2
vzgrid(ndata:2*ndata-1) = vzgrid2

END

