PRO fv_zavg, z_ele_to, z_ion_to, species, zavg2d, abar, ebar, $
             ndb2d, xraw, yraw, da, de, lowcnt, zs, eta, $
             ahigh, alow, ehigh, elow, nba, nblogE, enmax, enmin, err_zavg

err_zavg = 0

IF(species EQ -1)THEN BEGIN
    time = z_ele_to.time_ele
    alpha = z_ele_to.alpha_ele
    en = z_ele_to.energy_ele
    z = z_ele_to.z_ele
    dm = z_ele_to.dm_ele
    ndata = z_ele_to.n_ele
    bvalid = z_ele_to.bvalid
    bflags = z_ele_to.bflags
ENDIF ELSE BEGIN
    time = z_ion_to.time_ion
    alpha = z_ion_to.alpha_ion
    en = z_ion_to.energy_ion
    z = z_ion_to.z_ion
    dm = z_ion_to.dm_ion
    ndata = z_ion_to.n_ion
    bvalid = z_ion_to.bvalid
    bflags = z_ion_to.bflags
ENDELSE
ndet = 12

xraw = reform(alpha, ndet*ndata)
yraw = reform(en, ndet*ndata)
zraw = reform(z, ndet*ndata)
dmraw = reform(dm, ndet*ndata)
bvalidraw = reform(bvalid#make_array(12, value = 1), ndet*ndata)
bflagsraw = reform(bflags#make_array(12, value = 1), ndet*ndata)

IF species GT 0 THEN $
  mass = 1.67d-24 $
ELSE IF species LT 0 THEN $
  mass = 9.11d-28

facv4p = 2.*en*en*1.6d-12*1.6d-12/mass/mass*eta

IF zs EQ 1 THEN $
  convert = 1.6d-12*en*eta $
ELSE IF zs EQ 2 THEN $
  convert = eta $
ELSE convert = facv4p

data_ok = where(dmraw NE 0 AND yraw GE 0.1 AND zraw*convert GE lowcnt $
               AND yraw GT elow AND yraw LT ehigh AND xraw GT alow* $
                !pi/180. AND xraw LT ahigh*!pi/180. $
                AND bvalidraw EQ 1 $
                AND ((bflagsraw and 2) ne 2))

IF data_ok(0) EQ -1 THEN BEGIN
    print, 'FV_ZAVG:  The data mask, S/C potential, the lowcnt threshold,'
    print, ' and the specified energy and pitch-angle limits' 
    print, ' have filtered out all of the data for the selected interval....'
    err_zavg = 1
    return
ENDIF

xraw = xraw(data_ok)
yraw = yraw(data_ok)
zraw = zraw(data_ok)
nraw = n_elements(data_ok)
;stop

pi = acos(-1.)

da = 2*da*1d0
dlogE = alog10((2.+de)/(2.-de))*1d0

nblogE = long((alog10(enmax)-alog10(enmin))/dlogE)+1
nba = long(pi/da)+1

eb0 = enmin
epsleft = alog10(eb0)+findgen(nblogE)*dlogE
epsbar = epsleft+0.5*dlogE
ebar = 10^epsbar

ab0 = 0.
aleft = findgen(nba)*da
abar = aleft+0.5*da

blogE = long((alog10(yraw)-alog10(eb0))/dlogE)+1
ba = long((xraw-ab0)/da)+1

ndb2d = replicate(long(0), nba, nblogE)
zavg2d = replicate(0d0, nba, nblogE)

FOR i = 1, nraw DO BEGIN
    k = ba(i-1)
    l = blogE(i-1)
    ndb2d(k-1, l-1) = ndb2d(k-1, l-1)+1
    zavg2d(k-1, l-1) = double(zavg2d(k-1, l-1)+zraw(i-1))
ENDFOR

bin_ok = where(ndb2d NE 0)
bin_nok = where(ndb2d EQ 0)

nbin_ok = n_elements(bin_ok)
nbin_nok = n_elements(nbin_nok)

zavg2d(bin_ok) = zavg2d(bin_ok)/double(ndb2d(bin_ok))

END


















