PRO test_f, theta, phi, speed, mass, f

@model_include

zero = 1d-50

bhat1 = replicate(bhat(0), 384, 12)
bhat2 = replicate(bhat(1), 384, 12)
bhat3 = replicate(bhat(2), 384, 12)

vhat1 = sin(theta)*cos(phi)
vhat2 = sin(theta)*sin(phi)
vhat3 = cos(theta)

uhatc1 = sin(thetauc)*cos(phiuc)
uhatc2 = sin(thetauc)*sin(phiuc)
uhatc3 = cos(thetauc)

uh1 = uc*uhatc1+uch*bhat1
uh2 = uc*uhatc2+uch*bhat2
uh3 = uc*uhatc3+uch*bhat3

uh = sqrt(uh1^2+uh2^2+uh3^2)+zero

uhath1 = uh1/uh
uhath2 = uh2/uh
uhath3 = uh3/uh

us1 = uc*uhatc1+ucs*bhat(0)
us2 = uc*uhatc2+ucs*bhat(1)
us3 = uc*uhatc3+ucs*bhat(2)

us = sqrt(us1^2+us2^2+us3^2)+zero

uhats1 = us1/us
uhats2 = us2/us
uhats3 = us3/us

v_dot_b = vhat1*bhat1+vhat2*bhat2+vhat3*bhat3
uc_dot_b = uhatc1*bhat1+uhatc2*bhat2+uhatc3*bhat3
v_dot_uc = vhat1*uhatc1+vhat2*uhatc2+vhat3*uhatc3
uh_dot_b = uhath1*bhat1+uhath2*bhat2+uhath3*bhat3
v_dot_uh = vhat1*uhath1+vhat2*uhath2+vhat3*uhath3
us_dot_b = uhats1*bhat1+uhats2*bhat2+uhats3*bhat3
v_dot_us = vhat1*uhats1+vhat2*uhats2+vhat3*uhats3

pi = acos(-1.)

v = double(speed)
logfc = alog(nc/(pi^(3./2.)*wcparl*wcperp^2)+zero) $
  -((v*v_dot_b-uc*uc_dot_b)^2/wcparl^2+ $
  (v^2+uc^2-2*uc*v*v_dot_uc)/wcperp^2- $
  (v*v_dot_b-uc*uc_dot_b)^2/wcperp^2)

logfh = alog(nh/(pi^(3./2.)*whparl*whperp^2)+zero) $
  -((v*v_dot_b-uh*uh_dot_b)^2/whparl^2+ $
  (v^2+uh^2-2*uh*v*v_dot_uh)/whperp^2- $
  (v*v_dot_b-uh*uh_dot_b)^2/whperp^2)

logfs = alog(ns/(pi^(3./2.)*wsparl*wsperp^2)+zero) $
  -((v*v_dot_b-us*us_dot_b)^2/wsparl^2+ $
  (v^2+us^2-2*us*v*v_dot_us)/wsperp^2- $
  (v*v_dot_b-us*us_dot_b)^2/wsperp^2)

fzeroc = where(logfc LE -200)
fzeroh = where(logfh LE -200)
fzeros = where(logfs LE -200)

IF fzeroc(0) NE -1 AND fzeroh(0) NE -1 AND fzeros(0) NE -1 THEN BEGIN
    logfc(where(logfc LE -200)) = -200
    logfh(where(logfh LE -200)) = -200
    logfs(where(logfs LE -200)) = -200
ENDIF

fc = exp(double(logfc))
fh = exp(double(logfh))
fs = exp(double(logfs))

f = fc+fh+fs

END


