pro hydra_xyouts, x,y,string_in, charsize=charsize, _extra=e, limit=limit
;    clips text at length limit, in normal coords.
;
;  Assumtions:
;    assumes /normal keyword is set
;    does not handle !c 
;
;  Side Effects:
;    plots string off the page at (-1,-1) normal coorinates,
;      in !p.background

if n_elements( charsize ) eq 0 then charsize=1.0
if n_elements( limit ) eq 0 then limit=1.0

ymin= !p.position(1)
ymax= !p.position(3)

string=string_in

ymaxlen= y-ymin                 ; normal coord

; measure width per character, nominal, normal crd
w= float(!d.x_ch_size) * charsize / !d.x_size

buff= 0.75                       ; percent to leave as buffer

n= fix( limit * buff / w  )

strings= str_sep( string, '!c' )
newstring=''
for i=0,n_elements(strings)-2 do begin
    newstring= newstring+strmid( strings(i), 0, n ) + '!c'
endfor
newstring= newstring+strings(n_elements(strings)-1)

xyouts, x, y, newstring, charsize=charsize, _extra=e    

end


;******************************************************************************
;*  NAME:        panel_label
;*
;*  DESCRIPTION: Puts a label to mark a panel.
;*               calculates position form system variable !p.position
;*               Does "correct" new line with enough space
;*
;*  INPUT:       panel : 3 element vector for position of panel
;*               label : string to be used as label 
;*
;*  KEYWORDS     ROT90 : rotates output string by 90 degrees, used for plots
;*                       with papco_colorbars
;*               _extra: extra keywors to be passed to xyouts procedure
;*
;*  OUTPUT:      plots on current plotting device
;*
;*  DATE:        August 1995
;*
;*  AUTOR:       R. Friedel
;*
;*  SIDEEFFECTS: -
;*
;*  MODIFICATIONS: Jan 1997 -  made charsize controlled by !P.CHARSIZE
;*                             system variable R. Friedel
;*                 Oct 1997 -  Better New Line spacing added
;*                 Dec 1997 -  Checks panel boundry breaks and 
;*                              renamed hydra_right_side_label
;******************************************************************************
pro hydra_right_side_label,panel,label, ROT90=ROT90, _extra=extra_Par
  
; get character size in normal coordinates  
  chrs=convert_coord(!D.x_ch_size,!D.y_ch_size,/device,/to_normal)
  chrd=chrs*!P.CHARSIZE
  newlst=chrd(1)
  
; divide up input sting into lines
  res=strpos(label,'!C')   ; check if sting contains carriage returns
  if res ne -1 then lines=str_sep(label,'!C') else begin
    lines=strarr(1) & lines(0)=label
  endelse  
  
  if keyword_set(rot90) then begin
    newlst=newlst*1.5
    deg=-90 
    stpos=[!p.position(2)+0.045,!p.position(3)-0.000]
    xcr=newlst & ycr=0
  endif else begin
    deg=0
    stpos=[!p.position(2)+0.02,!p.position(3)-0.012]
    xcr=0 & ycr=newlst
  endelse
  
  if keyword_set(extra_Par) then begin
    ;only copy over the color tag if it exists
    tags=tag_names(extra_par)
    res=strpos(tags,'COLOR')
    index=where(res ne -1,count)
    if count ne 0 then col=extra_par.color else col=1    
  endif else col=1
  extra_Par={color:col,orientation:deg,charsize:!P.CHARSIZE,normal:1}
  
  for i=0,n_elements(lines)-1 do begin
      hydra_xyouts,stpos(0)-xcr*i,stpos(1)-ycr*i,lines(i), _extra=extra_Par, $
        limit= stpos(1)-ycr*i - !p.position(1)
  endfor  
  
end


