pro hydra_interp1, avg1, sc_pot, energy, yrange=yrange

   print, 'hydra_interp: shifting f by S/C Potential'

   energy_scale = fltarr(n_elements(energy)) ; interpolated energies
   nspec= n_elements( energy )

   if not keyword_set( yrange ) then yrange= [min(energy), $
                                              max(energy)]
   emax= yrange(1)
   emin= yrange(0)
   
   loge = (findgen(nspec)-1)/(nspec-1)*alog10(emax/emin)
   energy_scale= emin* 10^loge
   
   energy_shift=make_array(size=size(energy))

   FOR r=0,(size(avg1))(2)-1 DO BEGIN
       avg1a = avg1(*,r)
       if (abs(sc_pot(r)) gt 1e-31) then begin
           energy_shift=energy-sc_pot(r) 
       endif else begin
           energy_shift(*)=0.0  ; don't know energy: make nodata
       endelse
       
       ii= hyd_findex( energy_shift, energy_scale ) ;returns brackets
       i1= fix(ii)
       i2= i1+1
       rinterp= where( avg1a(i1) ne 1e-20 and avg1a(i2) ne 1e-20 )
       
       rv = where(avg1a NE 1.e-20,nrv) ; valid measurements
;               downshift energies by s/c pot 

       if rinterp(0) ne -1 then begin
           rinterp2= where( energy_scale( rinterp ) ge energy_shift(rv(0)) $
                            and $
                            energy_scale( rinterp ) le energy_shift(rv(nrv-1)))
           if rinterp2(0) ne -1 then rinterp= rinterp(rinterp2) else rinterp=-1
       endif

       if rinterp(0) ne -1 then begin
           avg1(*,r) = 1.e-20
           f= avg1a(rv)* ( (energy(rv)-sc_pot(r))/energy(rv) )^2.0 
           avg1(rinterp,r) = $
             interpolate(f,$
                         hyd_findex(energy_shift(rv),$
                                    energy_scale(rinterp)))
       endif else avg1(*,r)= 1.e-20
   endfor 
   
   energy= energy_scale

   return
end


pro hydra_shift, data_io, header
;  wraps hydra_interp, shifting both species.
;     data is an array of data structures returned by read routines.
;     header is the header for these data

   rvalid= where( data_io(*).mode ne 0 )
   if rvalid(0) eq -1 then return

   data= data_io(rvalid)

   m= data(*).mode
   u= uniq( m )
   u= ( [ 0, u ] )    
   
   for i=0,n_elements( u )-2 do begin
       pot_ma= max( data(u(i):u(i+1)).sc_pot )

       mode= m(u(i))-1
       
       if mode ge 0 then begin
           en= header.mode_energy( *, mode )
           
           r= where( en lt 0.0 ) 
           avg1= rotate( data(u(i):u(i+1)).spectrum(r), 5 )
           sc_pot= data(u(i):u(i+1)).sc_pot
           pot_ma= max( sc_pot )
           energy= reverse( -header.mode_energy( r, mode ) )
           hydra_interp1, avg1, sc_pot, energy, $
             yrange=[ (min(energy)-pot_ma)>1.0, max(energy)  ]
           data(u(i):u(i+1)).spectrum(r)= rotate( avg1, 5 )
           header.mode_energy(r,mode)= reverse( -energy )
           
           r= where( en gt 0.0 ) 
           avg1= data(u(i):u(i+1)).spectrum(r)
           sc_pot= -data(u(i):u(i+1)).sc_pot
           energy= header.mode_energy( r, mode )   
           hydra_interp1, avg1, sc_pot, energy ;, $
;         yrange= [ min(energy)+pot_ma, max(energy) ]
           data(u(i):u(i+1)).spectrum(r)=avg1
           header.mode_energy(r,mode)= energy
       endif
   endfor

   data_io(rvalid)= data
   
   return
end
   



