function hydra_juldate,axis,index,t
;  Plots date on time axis.

COMMON shift_label, down
COMMON mjdt, mjdt_start, mjdt_end

   if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')

   down_str=''
   if not keyword_set(down) then down=1
   for i=0,down-1 do down_str=down_str+'!C'

   mjdt_now=mjdt_start

   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = mjdt_start.t   + add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $ ; y2k
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   date_str=string(dom,cmonth,year,format="(i2.2,a3,i4.4)")
   return,font+down_str+date_str

end


function hydra_timeticks,axis,index,t_in
; print the time in either hh:mm or hh:mm:ss, depending on the
;   resolution needed.  Also, date is printed under first time tick
;   and each midnight tick.
;  hydra_timeticks expects that the axis be seconds since xut1.
;  i.e. ranging from zero to (xut2-xut1).
;  if time ranges over less than 300 seconds, then seconds are plotted.

   common time, xut1, xut2

   if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')

   dt= xut2-xut1

   t= t_in
   t= (long(t)+xut1) mod 86400
   hour = fix(t/3600.)
   minute = (t mod 3600)/60
   if (dt gt 300) then begin
       return= string(hour,minute,format="(i2.2,':',i2.2)")
   endif else begin
       sec= fix(t mod 60)
       return= string(hour,minute,sec, format="(i2.2,':',i2.2,':',i2.2)")
   endelse

   if t eq 0 or index eq 0 then begin
       return= return + $
          hydra_juldate( axis, index, t_in )
   endif
   return, return
end


function log_minus, axis, index, val
  return, '-'+strtrim(string(val,format='(i4)'),2)
end

function hyd_log_ticks, axis, index, val
  return, '10!a'+strtrim(fix(alog10(val)),2)
end



