pro hydra_ylim2, yray_in,yst,yen,ylog,smart=smart,_extra=e

; just like hydra_ylim, except that the 10% is not added--what a bad
; idea!  7-23-98, jbf.



; smart: takes the median 99% of the data to set bottom and top bounds,
; else:
; then these bounds are expanded an additional 10% for linear...
;
; For logarythmic:
;    range is enough cycles to cover data
;    if data fits within a cycle, then swwitch ylog to linear.
; 
; if e.minvalue is set then it is used as the minimum.  This will be
; used for positive definate data, and where 0 should always be the minimum.
;
; ylog parameter passes back what ylog has been reset to.

  yray= yray_in

  if n_elements( e ) gt 0 then begin
      t= tag_names(e)
      if (where(t eq 'MIN_VALUE'))(0) ne -1 then minvalue=e.min_value
      if (where(t eq 'YLOG'))(0) ne -1 then ylog=e.ylog
  endif

  r= where( yray gt -1e30 and yray lt 1e30 )
  if r(0) ne -1 then yray= yray(r)

  if keyword_set(ylog) then begin
      r= where( yray gt 0 )
      if r(0) ne -1 then yray= yray(r)
  endif

  ord=sort(yray)
  n=n_elements(ord)

  redo:
  if keyword_set(smart) then begin
      yst=yray(ord(n/200))
      yen=yray(ord(long((n-1)-(n/200.)+0.5)))
  endif else begin
      yst=yray(ord(0))
      yen=yray(ord(n-1))
  endelse

  if keyword_set(ylog) then begin 
      yst=10.^floor(alog10(yst))
      yen=10.^ceil( alog10(yen))
      if yen/yst eq 10. then begin 
          print, 'Only one cycle, plotting linear instead of logarytmic'
          e.ylog=0              ; turn off log if only once cycle
          ylog=0
          minvalue=0.0
          goto, redo
      endif
  endif

end




