pro p_hydra_fv, panel, type, $
                OVERPLOT=OVERPLOT,PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
                subtable=subtable, _EXTRA=extra_par

   common time, xut1, xut2

   common coordinateSystems, plotted_x, plotted_y

   common p_hydra_fv_common, fv_header, fv_input_global, fv_spec, species

   common rp_hydra_fv_common, fv_out_header, fv_ele, fv_ion
   
   panelset, panel              ; set the panel veiwport
;   PAPCO_set_subtable, subtable ;set the color space
;  read panel vector
   species= type(0)
   traceup= 1-type(1)
   nrow= type(2)

; get the data
   hydra_fv_rw_list, /read, species, fv_header, fv_data, fv_input_global
   if species eq 0 then begin
       fv_spec= fv_ele
   endif else begin
       fv_spec= fv_ion
   endelse
   
;  HYDRA-IOWA uses gif file output, which is converted to pcl.  The
;  following line uses a double stroke font for this case.
   if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')

;  select ticks that fall on even minutes, hours, days, etc...
   goodticks, xtickv, xminor
   xticks= n_elements(xtickv)-1

;  set the plot title 
   title= 'HYDRA'
   if species eq 1 then title=title+'!cIons' else $
     title=title+'!cElectrons'
  
;  here are the keywords that are always used.
   extra_plotPar_common={ xrange:[0,xut2-xut1], xstyle:1, $
                          noerase:1, ticklen:-0.03, xticklen:-0.03, $
                          xminor:xminor, xtickv:xtickv, xticks:xticks }
   

; add keyword structure specific to the subtype of plot chosen here (this)
   axis_plotPar= create_struct( extra_plotPar_common, {color:1} )

;  if this is the bottom panel, then it should print the time ticks.
   if panel(0) eq 0 then $
     xtickformat='hydra_timeticks' $
   else $
     xtickformat='noticks'

   if (panel(0) eq 0) and not keyword_set(OVERPLOT) $
     and traceup eq 0 then begin
       x_side_label,panel,font+'time (UT)!CDate'
   endif

   time= fv_spec(*).start_time + fv_header.start_time - xut1
   delta_time= fv_spec(*).delta_time 
   
;  pertanent parameters
   zmin= fv_input_global.control.zmin
   zmax= fv_input_global.control.zmax

;  now fo the actual plot
   pold= !p
   !p.color=1
   aspect=1.2
   thumb_plot, time, callFormat='p_hydra_fv_one', $
     _extra=axis_plotPar, xtickformat=xtickformat, traceup=traceup, $
     delta= delta_time, aspect=aspect, rows=nrow
   !p=pold
   hydra_color_bar, zrange=[zmin,zmax], ztitle='f'

   if panel(0) eq 0 then begin
       axis, xaxis=0, _extra=axis_plotPar, xtickformat=xtickformat
   endif
   
; store the coordinate information into common block
   plotted_x = !x
   plotted_y = !y

   right_side_label,panel,title, /rot90
   
   return
end
   
function p_hydra_fv_one, index, time, traceUp=traceUp, _extra=e
   common time, xut1, xut2
   common papco_color
   common papco_color_names
   common p_hydra_fv_common, fv_header, fv_input_global, fv_spec, species

; find colorbar range
   cindex= where( papco_color(*,2) eq 1 ) ; search the active vector
   if (cindex(0) eq -1) then begin
       print, 'Color system failure, consult jbf@space-theory.physics.uiowa.edu'
       print, 'Using color set 0'
       cindex=0
   endif
   color_range= PAPCO_get_Colorindices( cindex )
   colorbase= color_range(0)
   ncolors= color_range(1)-color_range(0)
   colortop= color_range(1)

   c_colors= findgen( fv_input_global.control.ncon ) / $
     (fv_input_global.control.ncon-1) * $
     ncolors + colorbase

   n= fv_header.n & m= fv_header.m

   contours= findgen( fv_input_global.control.ncon ) *  $
     ( fv_input_global.control.zmax-fv_input_global.control.zmin ) / $
     ( fv_input_global.control.ncon-1 ) + $
     fv_input_global.control.zmin
   
   sp= species
   units=[1e5,1e4]
   vmax= abs(fv_spec(index).x(0)) / units(sp)
   
   plotparm= {  $
                xtickname:[' ',' '], xticks:1, $
                ytickname:[' ',' '], yticks:1, color:1, $
                xrange:[-vmax,vmax]*units(sp), xstyle:1, $
                yrange:[-vmax,vmax]*units(sp), ystyle:1 }
   
   overplot=0

   if fv_input_global.mode.colorplot then begin
       hydra_plotcolor, $
         fv_spec(index).data, fv_spec(index).x, fv_spec(index).y, $
         zrange=[fv_input_global.control.zmin, $
                 fv_input_global.control.zmax ], $
         ctable= color_range, $
         _extra=plotparm
       overplot=1
   endif
       
   if fv_input_global.mode.fillcon then begin
       contour, fv_spec(index).data, fv_spec(index).x, fv_spec(index).y,  $
         c_colors=c_colors, /fill, levels= contours, $
         _extra=plotparm
       overplot=1
   endif 
   
   if fv_input_global.mode.drawcon or overplot eq 0 then begin
       contour, fv_spec(index).data, fv_spec(index).x, fv_spec(index).y,  $
         levels= contours, $
         _extra=plotparm, overplot=overplot
   endif

;  plot pitch angle measurement range
   oplot, fv_spec(index).valid_vparl0, fv_spec(index).valid_vperp0, $
     color=get_color_index('grey'), thick=2
   oplot, fv_spec(index).valid_vparl180, fv_spec(index).valid_vperp180, $
     color=get_color_index('grey'), thick=2

   xcirc= sin(findgen(37)/36.*2*!pi)
   ycirc= cos(findgen(37)/36.*2*!pi)
   
   polyfill, xcirc*fv_spec(index).speed_low_meas, $
     ycirc*fv_spec(index).speed_low_meas, $
     color=white

   oplot, !x.crange, [0,0], color=1, linestyle=3
   polyfill, ([ 0,1,0,0 ]*0.1+0.9)*vmax*units(sp), $
     [-1,0,1,-1]*vmax*units(sp)*0.10, color=1
   oplot, [0,0], !y.crange, color=1, linestyle=3

   if fv_spec(index).warning ne 0 then begin
       charsize=  ( !p.position(2)-!p.position(0) ) * 8.
       xyouts, vmax*units(sp)*0.85, vmax*units(sp)*0.85, $
         '*', charsize=charsize
   endif

   xyouts, -vmax*units(sp)*0.95, -vmax*units(sp)*0.95, $
     strtrim( fix( vmax/1000 + 0.5 ),2 ), charsize=0.8
   
   return, ''
end
   

