pro p_hydra_temp, panel, typeVector, _extra=extra_kw, $
                     plots_atthisposition=plots_atthisposition, $
                     subtable=subtable, overplot=overplot

   common hydra_temp_data, $
     initialized, $
     loaded, $                  ; bit0=efi
     efi_head, efi_data, $
     efi34_head, efi34_data
   common time, xut1, xut2
   common papco_color_names
   
   dxut= xut2-xut1
   
   type= typeVector(0)

   if 0 le type  and type le 10 then begin
       time= efi_head.start_time - xut1 + efi_data.time
       case type of 
           0: begin
               data= efi_data.vx
               title='MFE ExB X'
               units='km/s'
           end
           1: begin
               data= efi_data.vy
               title='MFE ExB Y'
               units='km/s'
           end
           2: begin
               data= efi_data.vz
               title='MFE ExB Z'
               units='km/s'
           end
           3: begin
               data= sqrt( efi_data.vx^2 + efi_data.vy^2 + efi_data.vz^2 )
               title='MFE !9!!!xExB!9!!!x'
               units='km/s'
           end
           4: begin
               data= efi_data.ex_gsm
               title='MFE Ex'
               units='mV/m'
           end
           5: begin
               data= efi_data.ey_gsm
               title='MFE Ey'
               units='mV/m'
           end
           6: begin
               data= efi_data.ez_gsm
               title='MFE Ez'
               units='mV/m'
           end
           7: begin
               data= sqrt( efi_data.ex_gsm^2 + $
                           efi_data.ey_gsm^2 + efi_data.ez_gsm^2 )
               title='MFE !9!!!xE!9!!!x'
               units='mV/m'
           end
           8: begin
               data= efi_data.ex_fac
               title='MFE Ex FAC'
               units='mV/m'
           end
           9: begin
               data= efi_data.ey_fac
               title='MFE Ey FAC'
               units='mV/m'
           end
           10: begin
               data= efi_data.ez_fac
               title='MFE Ez FAC'
               units='mV/m'
           end
       endcase

       hp_kw= { reference:0., $
                poly_above_ref:red, $
                poly_below_ref:blue }

   endif else if type ge 11 and type le 12 then begin

       ltype= type-11           ; "local" type

       Eparl= efi_data.ez_fac
       Egsm= transpose( [ [ efi_data.ex_gsm ], $
                          [ efi_data.ey_gsm ], $
                          [ efi_data.ez_gsm ] ] )
       Etim= efi_data.time + ( efi_head.start_time - xut1 )
       common hydra_current_data, $
         current_header, $
         current_data
       Jparl= current_data.j_parl
       Jgsm= current_data(*).j_gsm
       Jgsm= Jgsm(0:2,*)
       Jtim= current_data(*).time + ( current_header.start_time - xut1 )

       message, 'syncronizing data sets', /cont
       m= 13.8
       b= Jtim(0) - m/2

       iloc= long( ( Etim - b ) / m )
       S= dblarr( max(iloc)+1 )
       N= lonarr( max(iloc)+1 )
       SEgsm= dblarr( 3, max(iloc)+1 ) 
       JS= dblarr( max(iloc)+1 )
       JN= lonarr( max(iloc)+1 )
       JgsmS= dblarr( 3, max(iloc)+1 )
       for i=0,n_elements(iloc)-1 do begin
           if iloc(i) ge 0 then begin
               S(iloc(i))= S(iloc(i)) + Eparl(i)
               SEgsm(*,iloc(i))= SEgsm(*,iloc(i)) + Egsm(*,i)
               N(iloc(i))= N(iloc(i)) + 1
           endif
       endfor

       iloc= long( ( Jtim - b ) / m )
       JS(iloc)= Jparl
       JN(iloc)= 1
       JgsmS(*,iloc)= Jgsm

       r= where( N gt 0 and JN gt 0 )

       Eparl= S(r)/N(r)
       Egsm= SEgsm(*,r)/([1,1,1]#N(r))
       Etim= (r) * m + b 

       Jparl= JS(r)
       Jgsm= JgsmS(*,r)
       
       time= Etim
       case ltype of 
           0: begin
               if getenv( 'hydra_presentation_mode' ) eq '1' then $
                 title= 'E!i!9#!n.!xJ!i!9#!n!x' $
               else title= 'E!i!9#!n.!xJ!i!9#!n!x!cMFE,HYDRA'
               units='!7l!xW/km!e2!n'
               data= Jparl * Eparl * 33.33 ; microwatts / Km^2
           end
           1: begin
               title= 'E!9.!xJ'
               units= '!7l!xW/km!e2!n'
               data= total( Jgsm*Egsm, 1 ) * 33.33 
           end
           else: begin
               message, 'Internal Error, plot not implemented (2)', /cont
               return
           end
       endcase
       
       hp_kw= { reference:0., $
                poly_above_ref:red, $
                poly_below_ref:blue }

   endif else if type gt 12 and type le 14 then begin       
       ltype= type-12
       case ltype of 
           1: begin
               title= 'V34raw'
               units= ''
               data= efi34_data.v34raw
               time= efi34_data.v34raw_time + ( efi34_head.start_time - $
                                                xut1 )
           end
           2: begin
               title= 'scpot34'
               units= ''
               data= -1.0 * efi34_data.scpot34
               time= efi34_data.scpot34_time + ( efi34_head.start_time - $
                                                 xut1 )
           end    
       endcase
       r= where( time gt 0 )
       if r(0) ne -1 then begin
           data= data(r)
           time=time(r)
       endif
       
   endif else begin

       message, 'Internal Error -- Plot Unimplemented', /cont
       return

   endelse

   dts= time(1:*)-time(0:*) 
   dt= median(dts)   

; set all the plot keywords
   goodticks, xtickv, xminor
   xticks=n_elements(xtickv)-1

   rvis= where( 0 lt time and time lt dxut )
   if rvis(0) ne -1 then begin
       time= time(rvis)
       data= data(rvis)
   endif

   common yscale, yscl		
   ylog=yscl(panel(0),3)
   if (yscl(panel(0),0) eq 1) then begin
       print, '% p_hydra_kp: getting manual scale specifications: '
       yst= yscl(panel(0),1)
       yen= yscl(panel(0),2)
       ylog= yscl(panel(0),3)
       
       IF (yst LE 0 AND ylog EQ 1) THEN BEGIN
           print, '% p_hydra_kp: Negative ymin: swwitching from log to linear...'
           yscl(panel(0),3) =  0
           ylog = yscl(panel(0),3)
       ENDIF
       
   endif else begin             ; use autoscale results
       rv=where(data lt 1e31)
       if rv(0) ne -1 then rt=where( time(rv) ge 0 and time(rv) le dxut ) $
       else rt=-1
       if (rt(0) ne -1) then begin
           yen= max( data, min=yst )
       endif else begin
           yst=0 & yen=1
       endelse
       yscl(panel(0),1)= yst
       yscl(panel(0),2)= yen
   endelse
   yrange=[yst,yen]
   if yst lt 0 then ylog=0

   common_kw= { xrange:[0,dxut], yrange:yrange, ylog:ylog, $
                noerase:1, ticklen:-0.03, xticklen:-0.03, $
                xtickv:xtickv, xminor:xminor, xticks:xticks, $
                ytitle:units }

   if n_elements( extra_kw ) eq 0 then extra_kw={ color:1 }

   axis_kw= create_struct( common_kw, { color:1 } ) ; contains color
   plot_kw= create_struct( common_kw, extra_kw ) ; contains color

   if panel(0) eq 0 then  $
     xtickformat='hydra_timeticks' $
   else $
     xtickformat='noticks'

;  plot axis if not an overplot   
   if not keyword_set( overplot ) then begin
       plot, time, data, /nodata, _extra=axis_kw, $
         xtickformat=xtickformat, xstyle=1, ystyle=1
   endif

;  plot data 
   rvis= where( time+dt gt !x.crange(0) and time lt !x.crange(1) )
   if rvis(0) ne -1 then begin
       if n_elements( hp_kw ) gt 0 then $
         plot_kw= create_struct( plot_kw, hp_kw )
       hydra_plot, time(rvis), data(rvis), _extra= plot_kw, $
         xstyle=5, ystyle=5, dx=dt
   endif

;  label plot right of panel
   abunchoflfs='!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c'
   lfs= strmid( abunchoflfs, 0, 6*(plots_atthisposition<10) )
   right_side_label,panel,lfs+title, _extra=extra_kw

   return

end
