function papco_interactive, draw_ID=draw_id
;  Detects if papco is in interactive mode, ie not printing.
;  A result of 1 indicates interactive mode.
;  The widget ID of the draw window is returned in draw_ID.

;  detect interactive mode (enable pop-ups, etc.)
   interactive= (!d.name eq 'X' or !d.name eq 'WIN' )
   common plot_composer, widgetData
   if n_elements( widgetData ) ne 0 then begin
       valid= widget_info( widgetData.dw_draw, /valid_id )
       if valid then begin
           draw_id= widget_info( widgetData.dw_draw, /parent ) 
       endif else begin
           draw_id= 0
       endelse 
   endif else $
     draw_id=0
   return, interactive
end

       
