pro r_hydra_kp

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_kp_data, $
    kp_species, $
    kp_header, $
    kp_lr_ele_data, $
    kp_lr_ele_attr, $
    kp_lr_ion_data, $
    kp_lr_ion_attr, $
    kp_hr_ele_data, $
    kp_hr_ele_attr

     my_name='r_hydra_kp'
     module_name='HYDRA-kp'

     forward_function convert_date_to_t90
     
     get_err_no=0
     get_err_msg= my_name +': data-file read succesfully'

; read data files for time period
   num_files_read = 0
   time=xut1
   while time-1 lt xut2 do begin
       day_start= time / 86400 * 86400
       start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
       end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
       end_time= end_time - day_start 
       convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ; y2k
       if year lt 100 then year=year+1900
       date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")       

       if start_time ne end_time then begin
           r_hydra_kp_oneday, date_str, start_time, end_time, data_values, data_attr
           
           if get_err_no eq 0 then BEGIN
              num_files_read = num_files_read + 1
              data_values(*).time= $
               data_values(*).time + ( day_start - xut1 )
              IF (num_files_read EQ 1) THEN BEGIN
                 data_buf = [data_values]
              ENDIF ELSE BEGIN
                 data_buf = [data_buf,data_values]
              ENDELSE

           endif       
       ENDIF

       time=day_start+86400          ; prepare to read next day
   endwhile
   
   if (n_elements(data_buf) gt 0) then BEGIN
      IF (kp_species EQ 0) THEN BEGIN
         kp_lr_ele_data = data_buf
         kp_lr_ele_attr = data_attr
      ENDIF ELSE IF kp_species EQ 1 THEN BEGIN
         kp_lr_ion_data = data_buf
         kp_lr_ion_attr = data_attr
      ENDIF ELSE BEGIN
         kp_hr_ele_data = data_buf
         kp_hr_ele_attr = data_attr
      ENDELSE

       get_err_no=0             ; all's well
   endif else begin
       get_err_no=2
       print,get_err_msg
       return
   endelse

   print,'Read '+module_name+': done'

   return
end


pro r_hydra_kp_oneday, date_str, start_time, end_time, data_values, data_attr

   common  get_error, get_err_no, get_err_msg
   common hydra_kp_data, $
    kp_species, $
    kp_header, $
    kp_lr_ele_data, $
    kp_lr_ele_attr, $
    kp_lr_ion_data, $
    kp_lr_ion_attr, $
    kp_hr_ele_data, $
    kp_hr_ele_attr   

   myname= 'r_hydra_kp_oneday'
   
   IF (kp_species EQ 0) THEN BEGIN ;--------low res electrons------------
      
      f= hydra_findfile( date_str, /lrkp )
      
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf = cdf_open(f)
         n= strlen(f)
         kp_header(kp_species).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         get_err_no=1
         get_err_msg= myname+': no file found'
         return
      ENDELSE

      cdf_control, cdf, variable='TIME', get_var_info=r
      hyd_cdf_varget, cdf, 'TIME', time, rec_count=r.maxrec+1
      rec_start = ( where( time ge start_time ) )(0)
      if rec_start(0) eq -1 then begin
         get_err_msg= myname+': No data found after start_time '
         print, get_err_msg
         get_err_num = 1
         return
      ENDIF
      
      rec_count = r.maxrec+1 - rec_start

      ffill =  -1.e+31
      
      data_values1= { hydra_kp_dum_data1, $ ; needed to concatenate
                      time:0.0, $
                      mean_energy:0.0, $ ; kT, NOT 3/2kT!!!
                      density:0.0, $
                      density_fit:0.0, $
                      mean_energy_fit:0.0, $
                      kurtosis:0.0, $
                      kurtosis_black_frac:0.0, $
                      density_hot:0.0, $
                      mean_energy_hot:0.0, $
                      status:0 $
                    }   
      
      hyd_cdf_varget, cdf, 'TIME', t, $
        rec_start=rec_start, rec_count=rec_count
      hyd_cdf_varget, cdf, 'MODE', mode, $
        rec_start=rec_start, rec_count=rec_count
      hyd_cdf_varget, cdf, 'KP_DENSITY_ELE',den, $
        rec_start=rec_start, rec_count=rec_count
      hyd_cdf_varget, cdf, 'KP_MEAN_ENERGY_ELE', me, $ ; kT, NOT 3/2kT!!!
        rec_start=rec_start, rec_count=rec_count
      if cdf_varexist( cdf, 'KP_KURTOSIS_ELE' ) then begin
          hyd_cdf_varget, cdf, 'KP_KURTOSIS_ELE', KP_KURTOSIS_ELE, $
            rec_start=rec_start, rec_count=rec_count
          hyd_cdf_varget, cdf, 'KP_KURTBLACK_FRAC_ELE', KP_KURT_BLACK_FRAC_ELE, $
            rec_start=rec_start, rec_count=rec_count
          hyd_cdf_varget, cdf, 'KP_DENSITY_FIT_ELE', KP_DENSITY_FIT_ELE, $
            rec_start=rec_start, rec_count=rec_count
          hyd_cdf_varget, cdf, 'KP_MEAN_ENERGY_FIT_ELE', KP_MEAN_ENERGY_FIT_ELE, $
            rec_start=rec_start, rec_count=rec_count
      endif else begin
          KP_KURTOSIS_ELE= replicate( ffill, rec_count )
          KP_KURT_BLACK_FRAC_ELE= replicate( ffill, rec_count )
          KP_DENSITY_FIT_ELE= replicate( ffill, rec_count )
          KP_MEAN_ENERGY_FIT_ELE= replicate( ffill, rec_count )
      endelse
      hyd_cdf_varget, cdf, 'KP_IRETU_ELE', ir, $
        rec_start=rec_start, rec_count=rec_count

      cdf_close,cdf

; Only data filter here is on the mode variable of the survey
; file...The ffill filter has been moved to p_hydra_kp.pro since
; with the addition of the fit and kurtosis variables, the ffill
; filter is no longer unique...3/15/99, ppq.

      good = where(mode NE 0)   ; AND den NE ffill AND me NE ffill)
      IF (good(0) NE -1) THEN BEGIN 
         time = t(good)
         density = den(good)
         mean_energy = me(good)         
         density_fit= KP_DENSITY_FIT_ELE(good)
         mean_energy_fit= KP_MEAN_ENERGY_FIT_ELE(good)
         kurtosis=KP_KURTOSIS_ELE(good)
         kurtosis_black_frac=KP_KURT_BLACK_FRAC_ELE(good)
         iretu = ir(good)
      ENDIF ELSE BEGIN
         get_err_msg= myname+': No data found between start and end times '
         get_err_no= 1
         print, get_err_msg           
         return
      ENDELSE

; Calculate the 'hot' variables
      nhot = fltarr(n_elements(time)) + ffill
      kthot = fltarr(n_elements(time)) + ffill
      gd = where(density ne ffill and mean_energy ne ffill and $
                 density_fit ne ffill and mean_energy_fit ne ffill)
      if (gd(0) ne -1) then begin
          ptot = density(gd)*mean_energy(gd)*1.6d-12 ; pressure, cgs
          pcold = density_fit(gd)*mean_energy_fit(gd)*1.6d-12 ; pressure, cgs
          phot = ptot - pcold
          nhot(gd) = density(gd) - density_fit(gd) ; cgs
          kthot(gd) = phot/nhot(gd)/1.6d-12 ; eV
      endif

      data_values = replicate( data_values1, n_elements(time))

      r= lindgen(n_elements(time))

; One-dimensional data arrays
      data_values(r).time = reform(time)  
      data_values(r).mean_energy= reform(mean_energy) ; kT, NOT 3/2kT!!!
      data_values(r).density = reform(density)
      data_values(r).density_fit = density_fit 
      data_values(r).mean_energy_fit = mean_energy_fit ; kT, NOT 3/2kT!!!
      data_values(r).kurtosis= kurtosis
      data_values(r).kurtosis_black_frac= kurtosis_black_frac 
      data_values(r).density_hot = nhot
      data_values(r).mean_energy_hot = kthot ; kT, NOT 3/2kT!!!
      data_values(r).status = reform(iretu)
      
      data_attr = 13.8
      
   ENDIF ELSE IF (kp_species EQ 1) THEN BEGIN ;--------low res ions-------

      f= hydra_findfile( date_str, /lrkp )
      
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf = cdf_open(f)
         n= strlen(f)
         kp_header(kp_species).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return
      ENDELSE

      cdf_control, cdf, variable='TIME', get_var_info=r
      hyd_cdf_varget, cdf, 'TIME', time, rec_count=r.maxrec+1
      rec_start = ( where( time ge start_time ) )(0)
      if rec_start(0) eq -1 then begin
         get_err_msg= myname+': No data found after start_time '
         print, get_err_msg
         get_err_num = 1
         return
      ENDIF
      
      rec_count = r.maxrec+1 - rec_start
      
      data_values1= { hydra_kp_dum_data, $
                      time:0.0, $
                      mean_energy:0.0, $
                      density:0.0, $
                      status:0 $
                    }   
      
      hyd_cdf_varget, cdf, 'TIME', t, $
       rec_start=rec_start, rec_count=rec_count
      hyd_cdf_varget, cdf, 'MODE', mode, $
       rec_start=rec_start, rec_count=rec_count
      hyd_cdf_varget, cdf, 'KP_DENSITY_ION',den, $
       rec_start=rec_start, rec_count=rec_count
      hyd_cdf_varget, cdf, 'KP_MEAN_ENERGY_ION', me, $
       rec_start=rec_start, rec_count=rec_count

      cdf_close,cdf

      ffill =  -1.e+31
      good = where(mode NE 0 AND den NE ffill AND me NE ffill)
      IF (good(0) NE -1) THEN BEGIN 
         time = t(good)
         density = den(good)
         mean_energy = me(good)
      ENDIF ELSE BEGIN
         get_err_msg= myname+': No data found between start and end times '
         get_err_no= 1
         print, get_err_msg           
         return
      ENDELSE

      data_values = replicate( data_values1, n_elements(time))

      r= lindgen(n_elements(time))

; One-dimensional data arrays
      data_values(r).time = reform(time)  
      data_values(r).mean_energy= reform(mean_energy)
      data_values(r).density = reform(density)

      data_attr = 13.8      
      
   ENDIF ELSE BEGIN ;------------high res electrons-----------------

      f= hydra_findfile( date_str, /ddcal ) 
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf = cdf_open(f)
         n= strlen(f)
         kp_header(kp_species).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return
      ENDELSE

      cdf_control, cdf, variable='HRKP_TIME', get_var_info=r
      if r.maxrec eq -1 then begin
          message, 'No highres KP records found.', /cont
          get_err_msg= myname+': No highres KP records found.'
          get_err_no=1
          return
      endif 
      hyd_cdf_varget, cdf, 'HRKP_TIME', time, rec_count=r.maxrec+1
      rec_start= ( where( time ge start_time ) )(0)
      if rec_start eq -1 then begin
          get_err_msg= myname+': No data found after start_time, resetting'
          print, get_err_msg
          rec_start=0
      endif
      rec_count= n_elements( where( time(rec_start:*) lt end_time $
                                    and time(rec_start:*) $
                                    gt start_time, $
                                    count ))
      
      if ( count ) eq 0 then begin
          get_err_msg= myname+': No data found within selected interval '
          get_err_no= 1
          print, get_err_msg           
          return
      endif      
      
      data_values1= { hydra_kp_dum_data, $
                      time:0.0, $
                      mean_energy:0.0, $
                      density:0.0, $
                      status:0 $
                    }   
      
      hyd_cdf_varget, cdf, 'HRKP_TIME',time, $
       rec_start=rec_start, rec_count=rec_count

      hyd_cdf_varget, cdf, 'HRKP_DENSITY',density, $
       rec_start=rec_start, rec_count=rec_count
      
      hyd_cdf_varget, cdf, 'HRKP_MEAN_ENERGY', mean_energy, $
       rec_start=rec_start, rec_count=rec_count
      
      hyd_cdf_varget, cdf, 'HRKP_DQF',status, $
       rec_start=rec_start, rec_count=rec_count


      cdf_close,cdf
      
      time = reform(time)
      density = reform(density)
      mean_energy = reform(mean_energy)
      status = reform(status)

      good = where(status NE 0)
      rec_count =  n_elements(good)

      data_values  = replicate( data_values1, rec_count )

; One-dimensional data arrays
      data_values.time = time(good)  
      data_values.mean_energy= mean_energy(good)
      data_values.density = density(good)
      data_values.status = status(good)

      data_attr =  13.8/12.

   ENDELSE 

   return
end
