PRO r_hydra_pwi_power, date, time_ssm, data, mcab=mcab, mcae=mcae, sfra=sfra, sfrb=sfrb, rfill=rfill
   
   common get_error, get_err_no, get_err_msg
   
   my_name = 'r_hydra_pwi_power'
   get_err_no=0
   get_err_msg= my_name +': data-file read succesfully'

   IF ((date NE '19960529') AND (date NE '19960620')) THEN BEGIN
      get_err_msg=my_name+': PWI power only available for 19960529 or 19960620'
      get_err_no = 2
      print, get_err_msg
      return
   ENDIF

   dir = '/net/supras/export/data9/ftp/pub/polar/other/pwi/'
   IF (keyword_set(mcab)) THEN BEGIN
      fn = dir+date+'_mcab_bu.pwr'
      conversion = (1.d-9*1.d+4)^2/(8.d0*!pi) ; nT^2 to a cgs pressure
   ENDIF ELSE IF (keyword_set(mcae)) THEN BEGIN
      fn = dir+date+'_mcae_eu.pwr'
      conversion = (1./(3.d+4))^2/(8.d0*!pi) ; (V/m)^2 to a cgs pressure     
   ENDIF ELSE IF (keyword_set(sfra)) THEN BEGIN
      fn = dir+date+'_sfra_ez.pwr'
      conversion = (1./(3.d+4))^2/(8.d0*!pi) ; (V/m)^2 to a cgs pressure
   ENDIF ELSE IF (keyword_set(sfrb)) THEN BEGIN
      fn = dir+date+'_sfrb_L.pwr'
      conversion = (1.d-9*1.d+4)^2/(8.d0*!pi) ; nT^2 to a cgs pressure
   ENDIF ELSE BEGIN
      get_err_msg = my_name+': Keywords not working...'
      get_err_no = 2
      print, get_err_msg
      return
   ENDELSE
   
   filename = findfile(fn)
   filename = filename(0)
   IF (filename NE '') THEN BEGIN 
      message, 'Opening '+filename,/cont
      openr, unit, filename, /get_lun
   ENDIF ELSE BEGIN
      get_err_msg = my_name+': File !c'+fn+'!cdoes not exist...'
      get_err_no = 2
      print, get_err_msg
      return
   ENDELSE 
   
   hr_time = dblarr(50000)
   hr_data = dblarr(50000)
   data = dblarr(n_elements(time_ssm))
   
   IF (keyword_set(rfill)) THEN dfill = rfill ELSE dfill = 1e31
   dum = string(0)
   
   ii = -1
   WHILE NOT (eof(unit)) DO BEGIN
      
      readf, unit, dum
      
      IF (strmid(dum,0,2) NE '//') THEN BEGIN 
         
         datestr = strmid(dum,0,10)
         timestr = strmid(dum,11,12)
         pwr = double(strmid(dum,23,12)) ; nT^2 or (V/m)^2
         red_pwr = double(strmid(dum,35,12)) ; nT^2 or (V/m)^2
         
;         print, '^'+strmid(timestr,0,2)+'^','^'+strmid(timestr,3,2)+'^','^'+strmid(timestr,6,2)+'^'

         hr = double(strmid(timestr,0,2))
         mn = double(strmid(timestr,3,2))
         sc = strmid(timestr,6,2)
         IF (sc NE '  ') THEN sc = double(sc) ELSE GOTO, skip_one
         
         ii = ii+1
         hr_time(ii) = hr*3600. + mn*60. + sc
         hr_data(ii) = red_pwr*conversion ; cgs, pressure
         
         skip_one:
         
      ENDIF 
      
   ENDWHILE
   close, unit & free_lun, unit
   
   hr_time = hr_time(0:ii)
   hr_data = hr_data(0:ii)
   
   rvis = where(hr_time GE time_ssm(0) AND hr_time LE time_ssm(n_elements(time_ssm)-1) + 13.8*2 )

   IF (rvis(0) EQ -1) THEN BEGIN
      get_err_msg = my_name+': Data for this time range not in file'
      get_err_no = 2
      print, get_err_msg
      return
   ENDIF 

   hr_time = hr_time(rvis)
   hr_data = hr_data(rvis)
   
; Average the power down to time_ssm resolution
   FOR itime=0L,n_elements(time_ssm)-1 DO BEGIN

      istart = (where(hr_time GE time_ssm(itime)))(0)
      istop = (where(hr_time GT time_ssm(itime) + 13.8))(0)

      IF (istart EQ -1 OR istop EQ -1 OR (istop-istart) LE 2) THEN BEGIN

         data(itime) = dfill

      ENDIF ELSE BEGIN

         istop = istop-1        ; Want measurments inside the bracket

;         print, 'TIME: ',time_ssm(itime),time_ssm(itime)+13.8,istop-istart+1,hr_time(istart),hr_time(istop)
         
; Samples for this 'block'
         samp = hr_data(istart:istop)
         
; Find the block average
         data(itime) = total(samp,/double)/float(n_elements(samp))

      ENDELSE 

   ENDFOR

   data = data/1.e-8            ; Normalization the Moments use for pressure

   return
END


   
   

