PRO rediag_hydra_moments, mass, time, temp_tensor, b_block_avg, b_block_avg_status, b_block_avg_angle_cone, q, density, diagonalization_status, tparl, tperp, gyrotropy, skew, angle_bavg_bproxy, angle_bavg_bproxy_sig, b_proxy
   
   myname = 'rediag_hydra_moments'

   print, myname+': Rediagonalizing the moments...'
   
   rfill = -1.e+31
   
   ntime = n_elements(time)
   diagonalization_status = intarr(ntime)
   tparl = fltarr(ntime)
   tperp = fltarr(ntime)
   gyrotropy = fltarr(ntime)
   skew = fltarr(ntime)
   angle_bavg_bproxy = fltarr(ntime)
   angle_bavg_bproxy_sig = fltarr(ntime)
   b_proxy = fltarr(3,ntime)
   
   FOR itime=0,n_elements(time)-1 DO BEGIN 
      
      trace0=temp_tensor(0,0,itime)+temp_tensor(1,1,itime)+temp_tensor(2,2,itime)
      
      IF (trace0 LE 0.0 OR b_block_avg_status(itime) EQ 0) THEN BEGIN 
         
;         print, myname+': Either temperature tensor or bfield is not valid ', $
;          time(itime)/3600.
         diagonalization_status(itime) = 0
         tparl(itime) = rfill
         tperp(itime) = rfill
         gyrotropy(itime) = rfill
         skew(itime) = rfill
         angle_bavg_bproxy(itime) = rfill
         angle_bavg_bproxy_sig(itime) = rfill
         b_proxy(*,itime) = rfill
         
      ENDIF ELSE BEGIN 
         
; Diagonalize the temperature tensor
         
         a = reform(temp_tensor(*,*,itime))
         trired, a, d, e, /double
         triql, d, e, a, /double
         
         eig_vectors = a
         eigenvalues = d
         
         bavg = reform(b_block_avg(*,itime))
         bavgmod = sqrt(total(bavg^2))
         
         qvec = reform(q(*,itime))
         qmod = sqrt(total(qvec^2))
         
         cde = density(itime)
         
         xb = fltarr(3)
         FOR ipick=0,2 DO BEGIN 
            xmod=sqrt(total(eig_vectors(*,ipick)^2))
            xb(ipick)=abs(total(bavg*eig_vectors(*,ipick))/xmod/bavgmod)
         ENDFOR
         
         IF ((xb(0) GE xb(1)) AND (xb(0) GE xb(2))) THEN BEGIN 
            tpar=eigenvalues(0)
            tper=0.5*(eigenvalues(1)+eigenvalues(2))
            gyro= abs(-eigenvalues(1)+eigenvalues(2))/tper
            ipick=0
         ENDIF ELSE IF ((xb(2) GE xb(1)) AND (xb(2) GE xb(0))) THEN BEGIN 
            tpar=eigenvalues(2)
            tper=0.5*(eigenvalues(0)+eigenvalues(1))
            gyro= abs(-eigenvalues(0)+eigenvalues(1))/tper
            ipick=2
         ENDIF ELSE BEGIN  
            tpar=eigenvalues(1)
            tper=0.5*(eigenvalues(0)+eigenvalues(2))
            gyro=abs(-eigenvalues(0)+eigenvalues(2))/tper
            ipick=1
         ENDELSE
         saturated=0.5*cde*1.6e-17*tpar*(2*1.6e-12*tpar/mass)^0.5
         skew(itime)=qmod/saturated
         
; Bproxy is just the MOST PARALLEL eigenvector, be it aligned or opposed 
; Since this direction is determined only to within a sign, 
; we have leaway to choose bproxy so that the angle it makes with 
; Bavg is between 0 and 90 degrees
         
         xmod=sqrt(total(eig_vectors(*,ipick)^2)) ;Should be unity
         bproxy = eig_vectors(*,ipick)/xmod
         bproxymod = sqrt(total(bproxy^2))
         angle_bavg_bproxy(itime) = acos(total(bavg*bproxy)/bavgmod/bproxymod)
         IF (angle_bavg_bproxy(itime) GT !pi/2.) THEN BEGIN 
            angle_bavg_bproxy(itime) = !pi - angle_bavg_bproxy(itime)
            bproxy = -1.*bproxy
         ENDIF
         angle_bavg_bproxy_sig(itime) = sqrt(b_block_avg_angle_cone(itime)^2 + $
                                             (10.*!pi/180.)^2) ;10 deg error for bproxy
         
; Define output variables
         diagonalization_status(itime) = 1
         tparl(itime) = tpar
         tperp(itime) = tper
         gyrotropy(itime) = gyro
         b_proxy(*,itime) = bproxy
         
      ENDELSE
      
   ENDFOR
   
   return
   
END

