pro frequency_spectrum, x, y, _extra=e
;+
; NAME: frequency_spectrum
; PURPOSE: plots the FFT power spectrum of f(x) verses frequency.  
; CATEGORY: analysis
; CALLING SEQUENCE: frequency_spectrum, x, f, [plot_keywords]
; INPUTS: 
;    x   is the free variable, (e.g., time)
;    f   is the dependant variable
; KEYWORD PARAMETERS:
;    Plot keywords are passed on to plot.  These include:
;       xrange, yrange, /xlog, /ylog, xstyle, etc.
; OUTPUTS:
;    plots to the current graphics device.
; RESTRICTIONS: x is assumed to be monotonic and regular.
; EXAMPLE:
;   time=findgen(1000)*0.01 
;   f= 0.5 ; Hz 
;   w= f * 2 * !pi 
;   wav= sin( time * w ) 
   
;   f= 4.5
;   w= f * 2 * !pi
;   wav2= sin( time * w ) 

;   plot, time, wav+wav2
;   frequency_spectrum, time, wav+wav2, xrange=[0,5] 
;-

   n= n_elements( x )
   t= x(1)-x(0)
   n21= n/2 + 1
   
   f= lindgen(n)
   f(n21)= n21 - n + findgen(n21-2)

   f= f/(n*t)
   
   plot, _extra=e, $
     shift( f, -n21), $
     shift( abs( fft( y, -1 ) ), -n21 )
   
   return
end
