function gcd1, a_in,b_in, errtot=errtot

   if n_elements( errtot ) eq 0 then errtot=0
   
   a= a_in > b_in
   d= a_in < b_in
   
   r= a mod d

   r_imp= ( r < (d-r) )

   limit=15

   while r gt errtot and limit gt 0 do begin
       d= r
       r= a mod d
       limit= limit-1
   endwhile
   
   return, d
end


function gcd, A, errtot=errtot, guess=guess 
; gcd: return the greatest common divisor of a set of numbers A.
; I/O: A, array of int, long or float.
;      errtot=errtot  same as errpct, but err is in same units as a,
;                     and is independent of d, specifically:
;                   r < errtot
;        
;      guess=guess  a number that is likely to be the gcd, improve calculation.
;

  if n_elements( guess ) eq 0 then begin
      r= where( A ne 0 )
      if r(0) ne -1 then guess= A(r(0)) else return, 0
  endif
          
  if n_elements( errtot ) eq 0 then errtot= 0

  gcd= guess
  
  for i=0,n_elements(A)-1 do gcd= gcd1( gcd, A(i), errtot=errtot )
  
  return, gcd
end
