;+
; NAME: gen_time_string
; PURPOSE: convert gen_time number which is decimal days 
;     since midnight 12/31/1995, to a formatted string.
;     The integer part is printed as a date, and the decimal
;     part is printed as time.  If the argument is an integer,
;     then no time is printed.  If the argument is <1, then no
;     date is printed.
; CALLING SEQUENCE: print, gen_time_string( 150.5 )
; INPUTS: time, in gen_time or doy96 format.
; OUTPUTS: a string.
; OPTIONAL OUTPUTS: month=month, day=day, year=year, julian=julian
;                   hours=hours, minutes=minutes, seconds=seconds
; KNOWN BUGS:
;   gen_time_string( gen_time( '19960529 01:59:59.3' ) ) rounds up.
;-

function gen_time_string_accurate, time, julian=julian, nocolon=nocolon
;print,time,format='(d25.16)'

  if n_elements( time ) gt 1 then begin
      message, 'Input must be a scalar.  Use gen_time_to( /string )'
  endif
  doy96= long( time )
  if keyword_set( julian ) then begin
      julian= doy96 
  endif else begin
      julian= doy96 + 2450083
  endelse
  caldat, julian, month, day, year
   date_str= string(year,format='(i4.4)') + $
     string( month, format='(i2.2)' ) + $
     string( day, format='(i2.2)' )

   time_part= ( time - doy96 )
;print,time_part,format='(d25.16)'

   hours= fix( time_part * 24 )
   minutes= fix( time_part * 1440 ) - 60 * hours
   seconds= long( time_part * 86400 - 3600L * hours - 60 * minutes)

   decimal_seconds= $
	(time_part * 86400 - 3600L * hours - 60 * minutes) - $
	long(time_part * 86400 - 3600L * hours - 60 * minutes)

;print, hours,minutes,seconds

   if ( decimal_seconds gt 0.999999999d ) then begin
       decimal_seconds= 0
       seconds=seconds+1
   endif


;help,decimal_seconds
;print,'decimal_seconds=',decimal_seconds,format='(A,d25.16)'

   decimal_seconds_str = string(decimal_seconds,format='(f5.3)')
   dot_position        = strpos(decimal_seconds_str,'.')
   decimal_seconds_str = strmid(decimal_seconds_str,dot_position+1,6)



   if ( seconds eq 60 ) then begin
       seconds= 0
       minutes= minutes+1
   endif
   if ( minutes eq 60 ) then begin
       minutes= 0
       hours= hours+1
   endif
   if ( hours eq 24 ) then begin 
       hours=0
       julian=julian+1
       caldat, julian, month, day, year
       date_str= string(year,format='(i4.4)') + $
         string( month, format='(i2.2)' ) + $
         string( day, format='(i2.2)' )
   endif

   if keyword_set(nocolon) then begin
     time_str= string( hours,   format='(i2.2)' ) + '_' + $
               string( minutes, format='(i2.2)' ) + '_' + $
               string( seconds, format='(i2.2)' ) + '_' + $
               decimal_seconds_str
   endif else begin
     time_str= string( hours,   format='(i2.2)' ) + ':' + $
               string( minutes, format='(i2.2)' ) + ':' + $
               string( seconds, format='(i2.2)' ) + '.' + $
               decimal_seconds_str
   endelse

   if time ge 1.0 then return= date_str else return=''
   s= size( time ) 
   if s(1) eq 4 or s(1) eq 5 then $
     return= return+ ' ' + time_str
   return= strtrim( return, 2 )

   return, return
end
       
   
