pro hyd_4d_scatter, x_in, y_in, z_in, c_in, dots=dots, $
                    xrange=xrange_in, xlog=xlog, $
                    yrange=yrange_in, ylog=ylog, $
                    zrange=zrange_in, zlog=zlog, psym=psym, $
                    crange=crange_in, clog=clog, $
                    draw_colorbar=draw_colorbar, inset_colorbar=cbar_inset, $
                    cbar_xpos=cbar_xpos, $
                    cbar_title=zword, ztitle=ztitle, $
                    _extra=e
                 
;    emulate plot keyword defaults
    if n_elements( xlog ) eq 0 then xlog=0
    if n_elements( ylog ) eq 0 then ylog=0
    if n_elements( xrange_in ) eq 0 then xrange_in=[0,0]
    if n_elements( yrange_in ) eq 0 then yrange_in=[0,0]    

;    handle keywords
    if n_elements(z_in) eq 0 then z_in= x*0.+1
    if n_elements(zrange_in) eq 0 then $
      zrange_in= [ min(z_in), max(z_in) ]

    if keyword_set(zlog) then begin
        z= alog10(z_in)
        zrange= alog10(zrange_in)
    endif else begin
        z= z_in
        zrange= zrange_in
    endelse

    if n_elements(c_in) eq 0 then c_in= x*0.+1
    if n_elements(crange_in) eq 0 then $
      crange_in= [ min(c_in), max(c_in) ]

    if keyword_set(clog) then begin
        c= alog10(c_in)
        crange= alog10(crange_in)
    endif else begin
        c= c_in
        crange= crange_in
    endelse

    if keyword_set(xlog) then begin
        x= alog10(x_in)
        xrange= alog10(xrange_in)
    endif else begin
        x= x_in
        xrange= xrange_in
    endelse

    if keyword_set(ylog) then begin
        y= alog10(y_in)
        yrange= alog10(yrange_in)
    endif else begin
        y= y_in
        yrange= yrange_in
    endelse

;    draw axes and set plot coordinates
    surface, findgen(2,2), /nodata, $
      xrange=xrange_in, yrange=yrange_in, zrange= zrange_in, $
      xlog=xlog, ylog=ylog, zlog=zlog, $
      _extra=e

    hydra_setcolors, cs

    ccolor= bytscl( c, min=crange(0), max=crange(1), top= cs.ct_ncol ) + $
      cs.ct_base
    
;    handle psym
    if keyword_set(dots) then begin
        usersym, cos( findgen(12)/2 )*dots, sin( findgen(12)/2)*dots, /fill
        psym=8
    endif
    if n_elements( psym ) eq 0 then psym=1

;    clip points out of field and plot data
    r=where( x gt !x.crange(0) and x lt !x.crange(1) and $
             y gt !y.crange(0) and y lt !y.crange(1) )
;    
    if r(0) ne -1 then $
      plots, x_in(r), y_in(r), z_in(r), /t3d, color=ccolor(r), psym=psym

    if keyword_set( colorbar ) then begin
        hydra_colorbar, zrange=crange_in, zlog=clog, $
          xpos= cbar_xpos, zword= zword, ztitle= ztitle, ctable=cs.colortable
    endif
    
    if n_elements( cbar_inset ) then begin
        hydra_colorbar, zrange=crange_in, zlog=clog, $
          inset= cbar_inset, zword= zword, ztitle= ztitle, ctable=cs.colortable
    endif
 
    return
end
    
       
   
