pro testit, print=print
  if keyword_set(print) then begin
      set_plot, 'ps'
  endif
  x= randomn(s,1000000)
  y= randomn(s,1000000)
  hydra_pointdensityplot, x, y
  if keyword_set(print) then begin
      device, /close
      set_plot, 'x'
  endif
end
  
pro hydra_pointdensityplot, x_in, y_in, _extra=e
  
  loadct, 0

  print= !d.name eq 'PS'
  
  x= x_in
  y= y_in

  plot, x, y, /nodata, _extra=e
  
  xdata=!x.crange & ydata=!y.crange ; ranges in data space
  xlog=!x.type & ylog=!y.type
  if (xlog) then begin
      xdata=10^xdata
      x= alog10(x)
  endif
  if (ylog) then begin
      ydata=10^ydata
      y= alog10(y)
  endif
  ll=fix(convert_coord(xdata(0),ydata(0),/data,/to_device))
  ur=fix(convert_coord(xdata(1),ydata(1),/data,/to_device))

  if !d.name eq 'PS' then begin
      sizedev=((ur-ll)(0:1))/35 ; 72 dpi
      dfactor=1./35               ; device factor
  endif else begin
      sizedev=((ur-ll)(0:1))
      dfactor=1.
  endelse      
  
  nx= sizedev[0]
  ny= sizedev[1]
  hmat= make_array( nx, ny, value=0, /float )
  
  ix= ( x-xdata[0] ) / ( xdata[1]-xdata[0] ) * nx 
  iy= ( y-ydata[0] ) / ( ydata[1]-ydata[0] ) * ny
  onh= ( ix ge 0 and ix < nx $
         and iy ge 0 and iy < ny )
  ix= ix > 0 < ( nx-1 )
  iy= iy > 0 < ( ny-1 )

  for i=0L,n_elements(x)-1 do begin            
      hmat[ix[i],iy[i]]= hmat[ix[i],iy[i]]+1
  endfor

  hmax= max(hmat)

  arr= bytscl( hmat, top=!d.table_size-1,max=maxh)

  if print then begin
      narr= ( 1 - float( arr ) / ( !d.table_size-1 ) ) ^ 4
      arr= (!d.table_size-1)*narr <  (!d.table_size-1)
  endif

  if print then begin
      ll=convert_coord(!x.crange(0)+0.5,!y.crange(0),$
                       /data, /to_normal)
      ur=convert_coord(!x.crange(1)-0.5,!y.crange(1),$
                       /data, /to_normal)
      
      tv, transpose(arr), ll(0), ll(1), /normal, $
        xsize= ur(0)-ll(0), ysize=ur(1)-ll(1)
  endif else begin
      tv, congrid(transpose(arr), $
                  ur(0)-ll(0)-1, ur(1)-ll(1)-1), $
        ll(0), ll(1), /device
  endelse

  plot, x, y, /nodata, _extra=e, /noerase

  hydra_setcolors

end

