function hyd_time_ssm_bug_correct, time_ssm

; NAME: hyd_time_ssm_bug_correct
;
; PURPOSE: fix time_ssm bug where last records are relative to the
;    next day.
;
; CATEGORY: util
;
; CALLING SEQUENCE: time_ssm= hyd_time_ssm_bug_correct( time_ssm )
; 
; INPUTS: time in seconds since midnight
;
; OUTPUTS: time in seconds since midnight, relative to the first midnight.
;
; RESTRICTIONS: 
;
; PROCEDURE:
;    look for successive records that are nearly 86400 seconds before thier
;    predicessor.
;
; MODIFICATION HISTORY:
;    written, Jun 18, 2002, jbf, Univ of Iowa


  r= where( abs( (  time_ssm(1:*) - time_ssm(0:*) + 86400.0 ) - $
                 (13.8) ) lt 100. )
  if r(0) ne -1 then begin
      time_ssm((r(0)+1):*)= time_ssm((r(0)+1):*) + 86400
  endif
  
  return, time_ssm

end

