pro hydra_busy_killed, id
   common hydra_busy_common, base
   r= temporary( base )
end

pro test_hydra_busy
   for i=0,1000 do begin
       wait, 0.1
       hydra_busy, i/1000.
   endfor
end

function hydra_busy_event, event
   return, event
end

pro hydra_busy, percent, busy=busy, provide_cancel=provide_cancel, $
                cancel=cancel, done=done, wxx=wxx

   common hydra_busy_common, base

   uval= { window:0L, $
           percent:0 }

   w= widget_event(/nowait) 
   print, w.id
;   xmanager, /cleanup

   if n_elements( base ) eq 0 then build_widget=1 else begin
       if not widget_info( base, /valid_id ) then build_widget=0 else $
         build_widget=0
   endelse

   if build_widget then begin
       b= widget_base( title='progress', ysize=90, /column, $
                       event_func='hydra_busy_event' )
       wdraw= widget_draw( b, xsize=100, ysize=60, /button )
       if keyword_set( provide_cancel ) then begin
           wxx= widget_text( b, yoffset=30, xoffset=5, $
                             value=' ', xsize=1, /editable )
;           w= widget_label( b, yoffset=36, xoffset=35, value='cancel' )
;           b1= cw_field( b, xoffset=0, yoffset=30, $
;                         xsize=1, title='cancel: ', value='' )
           x= widget_button( b, xoffset=0, yoffset=60, ysize=30, $
                             value='Cancel' )
       endif
       
       widget_control, b, /realize
       widget_control, wdraw, get_value=window
       
       uval.window=window
       uval.percent=0
       
       widget_control, b, set_uvalue=uval
       base= b 

       widget_center, b
       xmanager, 'hydra_busy', b, /just_reg, cleanup='hydra_busy_killed'

   endif
   
   oldwin= !d.window
   catch, err
   if err eq 0 then wset, oldwin else oldwin=-1
   catch, /cancel
   
   widget_control, base, get_uval= uval
   wset, uval.window
   
   if n_elements(busy) gt 0 then begin
       if busy eq 1 then busy_q=10 else busy_q= busy
       percent= ( uval.percent + busy_q ) mod 100
       uval.percent= percent
       polyfill, [0,1,1,0,0], [1,1,0,0,1], /norm, $
         color=get_color_index( 'white' )
       x= [0,1,1,0,0]*0.3 + percent / 100.
       polyfill, x < 1.0, [1,1,0,0,1], /norm, $
         color= get_color_index('red')
       polyfill, x > 0.0, [1,1,0,0,1], /norm, $
         color= get_color_index('red')
   endif

   widget_control, base, set_uvalue= uval

   return
end
       

