function doy96_date_tick, axis, index, time
 
  s= gen_time_to( /string, time )
  year= fix( strmid(s,0,4) )
  month= fix( strmid( s,4,2 ) )
  day= fix( strmid( s,6,2 ) )
 
  monthname=[ '', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'June', $
              'July', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec' ]
  return, strtrim(day,2)+' '+monthname(month)+' '+string(year,format='(i4.4)')
end


function doy96_datetime_tick, axis, index, time
 
  seconds= (time mod 1.) * 86400
 
  s= gen_time_to( /string, time )
  year= fix( strmid(s,0,4) )
  month= fix( strmid( s,4,2 ) )
  day= fix( strmid( s,6,2 ) )
 
  monthname=[ '', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'June', $
               'July', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec' ]
  return, $
    strtrim(day,2)+' '+monthname(month)+' '+string(year,format='(i4.4)') + $
    '!c'+hydra_hms(seconds)
end

function doy96_hr_datetime_tick, axis, index, time
 
  seconds= (time mod 24.) * 3600
 
  s= gen_time_to( /string, time/24. )
  year= fix( strmid(s,0,4) )
  month= fix( strmid( s,4,2 ) )
  day= fix( strmid( s,6,2 ) )
 
  monthname=[ '', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'June', $
               'July', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec' ]
  if ( time mod 24. eq 0 ) or index eq 0 then begin
      return, $
        strmid(hydra_hms(seconds),0,5)+'!c'+$
        strtrim(day,2)+' '+monthname(month)+' '+$
        string(year,format='(i4.4)') 
  endif else begin
      return, $
        strmid(hydra_hms(seconds),0,5)
  endelse      
end

function doy96_min_hm_tick, axis, index, time
  fp= time mod 1440 / 1440
  return, strmid( gen_time_to( /string, fp ), 0, 5 )
end

function doy96_sec_hms_tick, axis, index, time
  fp= time mod 86400 / 86400
  return, gen_time_to( /string, fp )
end

function doy96_sec_hmss_tick, axis, index, time
  fp= time mod 86400 / 86400
  milli= time mod 1 * 1000
  return, gen_time_to( /string, fp ) + string( milli, format='(i3.3)' )
end

pro hydra_plot, xdat_in, ydat_in, dx=dx_in, events=events, $                
                max_value=max_value, min_value=min_value, $
                overplot=overplot, psym=psym, $
                reference=reference, $
                xtickformat=xtickformat, $
                xrange=xrange, $
                color=color, $
                poly_below_ref=poly_below_ref, $
                poly_above_ref=poly_above_ref, $
                fill_above_ref= fill_above_ref, $
                fill_below_ref= fill_below_ref, $
                errors= errors, $
                thick=thick, $
                _extra=e

  if n_params() eq 1 then begin
      ydat= xdat_in
      xdat= findgen(n_elements(xdat_in))
  endif else begin
      ydat= ydat_in
      xdat= xdat_in
  endelse
  
  if n_elements( xrange ) eq 0 then xrange=!x.range

  
  if n_elements( thick ) eq 0 then begin
      thick=0.
  endif

  if n_elements( color ) eq 0 then begin
      color= !p.color
  endif
  
;  if xdat is hyd_access timetags, then decode timetags.
  s= size( xdat )
  if s(n_elements(s)-2) eq 8 then begin 
      dx= min(xdat.bin_width)
      xdat= xdat.bin_start
@hd_include
      r= where( ydat eq hd_fill )
      if r(0) ne -1 then ydat(r)=1e38
      if n_elements( xtickformat ) eq 0 then begin
          if xrange(0) ne 0 and xrange(1) ne 0 then $
            xx= xrange(1)-xrange(0) else $
            xx= max(xdat,min=mi)-mi
          xtickformat= 'doy96_datetime_tick'
          units_fac=1.
          units_offset=0.
          case 1 of 
              xx gt 4: xtickformat='doy96_date_tick' 
              xx gt 1: xtickformat='doy96_datetime_tick'
              xx*24 gt 4: begin
                  xtickformat='doy96_hr_datetime_tick'
                  units_fac= 24
                  units_offset= 0
              end
              xx*1440 gt 4: begin
                  xtickformat='doy96_min_hm_tick'
                  units_fac= 1440
                  units_offset= long( xdat(0) )
              end
              xx*86400 gt 4: begin
                  xtickformat='doy96_sec_hms_tick'
                  units_fac= 86400
                  units_offset= long( xdat(0) )
              end
              else: begin
                  xtickformat='doy96_sec_hmss_tick'
                  units_fac= 86400
                  units_offset= long( xdat(0) )
              end
          endcase
          if not keyword_set( overplot ) then begin
              xdat= ( xdat - units_offset ) * units_fac
              xrange= ( xrange - units_offset ) * units_fac
              dx= dx * units_fac
          endif
      endif 
  endif
  
  n=( n_elements( xdat )-1)<100
  if n lt 1 then return
  dxs= xdat(1:n)-xdat(0:(n-1))
  s= sort( dxs )
  n= n_elements(s)
  dx= dxs(s(n/5))
  if n_elements( dx_in ) eq 0 then begin
      dx_width= dx
  endif else begin
      dx_width= median([dx_in])
  endelse

  if n_elements( xtickformat ) eq 0 then xtickformat=!x.tickformat
  
  if (not keyword_set(max_value)) then max_value= 1e37
  if (not keyword_set(min_value)) then min_value= -!values.f_infinity
  
  if getenv( 'hydra_plot_access_idlsav' ) eq '1' then begin
      common time, xut1, xut2
      time_t90= xdat + xut1
      hd_make_timetags, q_timetags1, time_t90, dx, /t90
      q_output1= ydat
      help, calls=a
      s= str_sep(a(2),' ')
      filename= s(0)+'.access.idlsav'
      save, /verbose, file=filename, q_timetags1, q_output1
  endif
  
  common plot_Composer, widgetData ; from papco
  
  if n_elements( widgetData ) gt 0 then begin
      xpixels= widgetData.default_draw_size(0) * 0.675
  endif else begin
      hydra_get_device_space, x0, y0, xpixels, ypixels
  endelse
  
  if getenv('hydra_plot_events') ne '0' and $
    getenv('hydra_plot_events') ne '' then begin      
      plot, xdat, xdat*0., $
        /nodata, $
        xstyle=5, ystyle=5, xrange=xrange ; set data coords.
      if not keyword_set(overplot) then hydra_events
  endif

  overplot= keyword_set( overplot )

  if n_elements( psym ) eq 0 then psym= !p.psym

  if psym eq 10 then begin
      message, 'psym=10 not allowed, using psym=0', /cont
      psym=0
  endif
  
; set plot coordinates.
;  if not keyword_set( overplot ) then begin
      plot, [xdat], [ydat], psym=psym, $
        max_value=max_value, min_value=min_value, _extra=e, /nodata, $
        xtickformat=xtickformat, xrange=xrange, color=color
;  endif
  
; decide whether or not to use "xbin plot" xpixels is ~ 5.x" x 72dpi
      npixels= xpixels / ( !x.crange(1)-!x.crange(0) ) * dx_width
      use_xbin_plot= ( npixels gt 3.0 and psym le 0 )

; Deside whether to "box" avg the plot to remove excessive resolution.
      npixels1= xpixels / ( !x.crange(1)-!x.crange(0) ) * dx
      if getenv('hydra_publication_mode') eq '' then begin
          use_box_plot= ( npixels1 lt 0.01 and psym le 0 )
      endif else begin
          use_box_plot= ( npixels1 lt 0.25 and psym le 0 )
      endelse

; now do the actual data plot
  if (use_xbin_plot) then begin
      
      xin= xdat
      xout= xdat+dx

      nx= n_elements(xin)
      newx= fltarr( 4*nx )
      newy= fltarr( 4*nx )
      r= lindgen( nx ) * 4
      
      newx(r)= xin
      newx(r+1)= xin
      newx(r+2)= xout
      newx(r+3)= xout
      
      newy(r)= max_value*10
      newy(r+1)= ydat
      newy(r+2)= ydat
      newy(r+3)= max_value*10
      
;      if (not keyword_set(overplot)) then begin
      if thick eq 0. then xbin_thick=2.0 else xbin_thick=thick
      plot, newx, newy, max_value=max_value, min_value=min_value,$
        _extra=e, thick=thick, $
        xtickformat=xtickformat, xrange=xrange, color=color
      if n_elements(errors) gt 0 then begin
          for ii=0,n_elements(errors)-1 do begin
              if errors[ii] gt -1e30 and errors[ii] lt 1e30 then begin
                  oplot, [1,1]*(xin[ii]+dx[ii]/2), $
                    ydat[ii]+[-1,1]*errors[ii], color=color
              endif
          endfor
      endif
;      endif else begin
;          oplot, newx, newy, max_value=max_value, _extra=e, thick=2.0
;      endelse
  endif else if (use_box_plot) then begin
;      
;     Find Min/Max of Data in a bin and plot as "box"
;
      if getenv('hydra_publication_mode') eq '' then begin
          dxbin=(!x.crange[1]-!x.crange[0])/xpixels/10.0
      endif else begin
          dxbin=(!x.crange[1]-!x.crange[0])/xpixels/4.0
      endelse
      if dxbin gt 1.0 then dxbin=long(dxbin)
      nbins=long((!x.crange[1]-!x.crange[0])/dxbin+1)

      xbin0=!x.crange[0]+dindgen(nbins)*dxbin
      xbin1=xbin0+dxbin

      hydra_box_data, xdat, ydat, xbin0, dxbin, xnew, ynew_min, ynew_max, $
        max_value=max_value, min_value=min_value
      
      if thick eq 0. then xbin_thick=2.0 else xbin_thick=thick
      plot, xnew, ynew_min, max_value=max_value, min_value=min_value,$
        _extra=e, thick=thick, $
        xtickformat=xtickformat, xrange=xrange, color=color
      ;;plot, xnew, ynew_max, max_value=max_value, min_value=min_value,$
      ;;  _extra=e, thick=thick, $
      ;;  xtickformat=xtickformat, xrange=xrange, color=color
      oplot, xnew, ynew_max, _extra=e, thick=thick, color=color

      newx= xdat
      newy= ydat

      if n_elements(errors) gt 0 then begin
          message, 'ERRORs not coded for box plot.', /cont
      endif

  endif else begin
;      if (not keyword_set(overplot)) then begin
      plot, [xdat], [ydat], psym=psym, $
        max_value=max_value, min_value=min_value,$
        _extra=e, $
        xtickformat=xtickformat, xrange=xrange, color=color, thick=thick
      if n_elements(errors) gt 0 then begin
          for ii=0,n_elements(errors)-1 do begin
              if errors[ii] gt -1e30 and errors[ii] lt 1e30 then begin
                  oplot, [1,1]*xdat[ii], ydat[ii]+[-1,1]*errors[ii], $
                    _extra=e, color=color
              endif
          endfor
      endif

;      endif else begin
;          oplot, xdat, ydat, psym=psym, max_value=max_value, _extra=e
;      endelse
      newx= xdat
      newy= ydat
  endelse

  if n_elements( reference ) gt 0 then begin
      
      replot=0
      
      r= where( newy gt max_value or newy lt min_value )
      if r(0) ne -1 then begin
          newy(r)= reference
      endif 

      n= n_elements( newx )
      
      if not( use_xbin_plot ) then begin
          s= sort( newx )
          newx= newx(s)
          newy= newy(s)
      endif
      
      if !y.type eq 0 then ycrange=!y.crange else ycrange=10^!y.crange
      if !x.type eq 0 then xcrange=!x.crange else xcrange=10^!x.crange      

      if not overplot then begin

          if n_elements( fill_above_ref ) gt 0 then begin
              polyfill, !x.crange([0,0,1,1,0]), $
                ycrange([0,1,1,0,0]) > reference < ycrange(1), $
                color= fill_above_ref
              replot=1
          endif
      
          if n_elements( fill_below_ref ) gt 0 then begin
              polyfill, !x.crange([0,0,1,1,0]), $
                ycrange([0,1,1,0,0]) < reference > ycrange(0), $
                color= fill_below_ref
              replot=1
          endif
          
          if n_elements( poly_above_ref ) gt 0 then begin
              r= where( newy lt max_value and newy gt min_value, nr )
              x= [ newx(r(0)), newx(r), newx(r(nr-1)) ] $
                > xcrange(0) < xcrange(1)
              y= [ reference, newy(r), reference ] > reference $
                < ycrange(1) > ycrange(0)
              polyfill, x, y, color= poly_above_ref, $
                /line_fill, spacing=0.1, orient=45
              replot=1
          endif

          if n_elements( poly_below_ref ) gt 0 then begin
              r= where( newy lt max_value and newy gt min_value, nr )
              x= [ newx(r(0)), newx(r), newx(r(nr-1)) ] $
                > xcrange(0) < xcrange(1)
              y= [ reference, newy(r), reference ] < reference $
                < ycrange(1) > ycrange(0)
              polyfill, x, y, color= poly_below_ref, $
                /line_fill, spacing=0.1, orient=-45
              replot=1
          endif

      endif                     ; overplot

      oplot, !x.crange, [ reference, reference ], color=1, linestyle=1

      if replot then begin
          hydra_plot, [xdat], [ydat], dx=dx, events=events, $
            max_value=max_value, min_value=min_value, $
            overplot=overplot, psym=psym, $
            reference=reference, $
            xrange=xrange, xtickformat=xtickformat, $
            color=color, thick=thick, $
            /noerase, $
            _extra=e
      endif
  endif

  xmin_n= !x.crange(0) * !x.s(1) + !x.s(0) ; normal pos x axis left end
  if n_elements( units_fac ) gt 0 then begin
      !x.crange= !x.crange / units_fac 
      !x.s(1)= !x.s(1) * units_fac
  endif
  if n_elements( units_offset ) gt 0 then begin
      !x.crange= !x.crange + units_offset
      if n_elements( units_fac ) eq 0 then units_fac=1.
      !x.s(0)= xmin_n - ( !x.crange(0) * !x.s(1) )
  endif
  return
  
end

