pro test_it_event, event
   help, /str, event
end

pro test_it
   b= widget_base()
   r= hydra_plot_widget(b)
   widget_control, b, /real
   widget_control, r, get_value=x
   widget_control, r, set_value=x
   xmanager, 'test_it', b
end

function u_law, op, imax=imax, fmax=fmax, encode=encode, decode=decode
;  reference is encoded using U-Law encoding:
;   m= value.reference  &  u= 2^30-1 mp=1e31
;          sgn(m)   (     |m |)       |m |
;   y=    ------- ln( 1+ u|--|)       |--| =< 1
;         ln(1+u)   (     |mp|)       |mp|
;   u= double(2L^29-1)  ; maximum magnitude of encoded data.
   if n_elements( imax ) eq 0  then u= double(2L^15-1) else u=double(imax)
   if n_elements( fmax ) eq 0  then mp= double(1e3) else mp= double(fmax)

   sign= (op ge 0.)*2.-1
   if keyword_set(encode) then begin
       b30=  sign  *  u  *  alog( 1 + u * abs(op/mp) ) / alog(1+u) 
       return, long(b30)
   endif
   if keyword_set(decode) then begin       
       b30= op
       f=  sign  *  mp * ( exp( abs(b30) / u * alog( u + 1 ) ) - 1 ) / u
       return, f
   endif
end


function hydra_plot_widget_codei4, op, encode=encode, decode=decode
   if keyword_set(decode) then begin
       codei4= op
       value={ hydra_plot_widget_value, $
               codei4:0L, reference:0., $
               poly_above_ref:0, $
               poly_below_ref:0, $
               draw_reference:0 }
       refvalb24= ishft( codei4, -3 )
       if refvalb24 gt 4096 then refvalb24= refvalb24-4096-4097
       refval= float( (refvalb24)/10. )
       value.reference= refval
       value.poly_above_ref= 1 - ( ( codei4 and 4 ) / 4 )
       value.poly_below_ref= 1 - ( ( codei4 and 2 ) / 2 )
       value.draw_reference= ( codei4 and 1 ) / 1
       value.codei4= codei4
       return, value
   endif 
   if keyword_set(encode) then begin
       value=op
       value.reference= value.reference > (-4096) < 4096
       refvalb24= long(value.reference*10) ;up to 4096 okay. ; 13 bits
       if refvalb24 lt 0 then refvalb24= refvalb24+4096+4097
       codei4=  $               ; valid
         ishft( refvalb24, 3 ) + $ ; ref 
         ( 1 - value.poly_above_ref ) *4 + $ ; poly_above_ref
         ( 1 - value.poly_below_ref ) *2 + $ 
         value.draw_reference *1
       return, codei4
   endif
end
   
function hydra_plot_widget_get_value, base
   child= widget_info( base, /child )
   widget_control, child, get_uvalue=widgetData
   value={ hydra_plot_widget_value, $
           codei4:0L, reference:widgetData.refval, $
           poly_above_ref:widgetData.polyButtons(0), $
           poly_below_ref:widgetData.polyButtons(1), $
           draw_reference:widgetData.draw_reference }
   codei4= hydra_plot_widget_codei4( value, /encode )
   value.codei4= codei4
   return, value
end

pro hydra_plot_widget_set_value, base, value_in
;  if value is an long, then it is decoded.  Otherwise other
;  fields are the input
;         
   s= size(value_in)
   if s(n_elements(s)-2) ne 8 then begin
       value= hydra_plot_widget_codei4( value_in, /decode )
   endif else value=value_in
   
   child= widget_info( base, /child )
   widget_control, child, get_uvalue=widgetData
   widgetData.refval= value.reference
   widgetData.polyButtons= $
     [ value.poly_above_ref, value.poly_below_ref ]
   widgetData.draw_reference= value.draw_reference
   widget_control, child, set_uvalue=widgetData
   widget_control, widgetData.ref_id, set_value= value.reference
   widget_control, widgetData.poly_id, set_value=widgetData.polybuttons
   widget_control, widgetData.draw_ref_id, set_value=widgetData.draw_reference
   widget_control, widgetData.poly_id, sensitive= widgetData.draw_reference
   widget_control, widgetData.refval_id, sensitive= widgetData.draw_reference
end
   
   
function hydra_plot_widget_event, event

   child= widget_info( event.handler, /child )
   widget_control, child, get_uvalue= widgetData
   widget_control, event.id, get_uvalue=uval

   case uval of
       'ref1': begin
           widget_control, event.id, set_uval='ref0'
           widget_control, widgetData.refval_id, sensitive=1
           widget_control, widgetData.poly_id, sensitive=1
           widgetData.draw_reference= 1
       end
       'ref0': begin
           widget_control, event.id, set_uval='ref1'
           widget_control, widgetData.refval_id, sensitive=0
           widget_control, widgetData.poly_id, sensitive=0
           widgetData.draw_reference= 0
       end
       'ref_val': begin
           widgetData.refval= event.value
       end
       'poly': begin           
           widgetData.polybuttons(event.value)= $
             1 - widgetData.polybuttons(event.value)
           widget_control, event.id, set_value=widgetData.polybuttons
       end
       else: message, uval+' received.', /cont
   endcase
   widget_control, child, set_uvalue= widgetData
   value=  hydra_plot_widget_get_value( event.handler )
   event_new= { widget_hydra_plot, $
                id:event.handler, $
                top:event.top, $
                handler:event.handler, $
                value:value }
   return, event_new
end

function hydra_plot_widget, base, _extra=base_kw

   widgetData= { ref_id:0L, $
                 refval_id:0L, $
                 refval:0., $
                 poly_id:0L, $
                 polybuttons:[0,0], $
                 draw_ref_id:0L, $
                 draw_reference:0 }

   b= widget_base( base, event_func='hydra_plot_widget_event', $
                   func_get_value='hydra_plot_widget_get_value', $
                   pro_set_value='hydra_plot_widget_set_value', $
                   _extra=base_kw )
   
   child= widget_base( b )      ; store widget information here
   
   widgetData.draw_ref_id= $
     cw_bgroup( b, [''], /nonexclusive, yoffset=10, uval='ref1' ) 
   widgetData.ref_id= $
     cw_hyd_field( b, title='Reference:', value=0.0, /float, $
                   yoffset=5, xoffset=28, xsize=9, text_id=refval_id, $
                   uvalue='ref_val', /return_events )
   widgetData.refval_id= refval_id
   widget_control, refval_id, sensitive=0
   widgetData.poly_id= $
     cw_bgroup( b, $
                ['polyfill red above ref', 'polyfill blue below ref'], $
                /nonexclusive, xoffset=200, uvalue='poly' )
   widgetData.polyButtons=[0,0]
   widget_control, widgetData.poly_id, sensitive=0

   widget_control, child, set_uvalue= widgetData
   return, b
end
