PRO hydra_get_remote_account_info, url

   COMMON hydra_remote_account_info, account_info_WidgetData
  
;check the url for "pasword" and "user", if there get interactively!
   res=strpos(url,'user')
   frontpart=strmid(url,0,res)
   if res ne -1 then begin
       base=WIDGET_BASE(/COLUMN, TITLE='Enter login information')
       pos=strpos(url,'@')
       backpart=strmid(url,pos,strlen(url)-1)
       host=strmid(url,pos+1,strlen(url))
       txt_msg=WIDGET_TEXT(base, VALUE='Host: '+host)
       user_fld=CW_field(base,/ROW,/STRING,TITLE='User:    ',UVALUE='user_fld')
       pswd_fld=CW_field(base,/ROW,/STRING,/ALL_EVENTS, $
                         TITLE='Password:', $
                         UVALUE='pswd_fld') 
       pb_base=WIDGET_BASE(base, /ROW)
       pb_enter= WIDGET_BUTTON(pb_base, VALUE='    Enter    ', $
                               UVALUE='pb_enter')
       pb_cancel=WIDGET_BUTTON(pb_base, VALUE='    Cancel   ', $
                               UVALUE='pb_cancel') 
       pb_clear= WIDGET_BUTTON(pb_base, VALUE='    Clear   ', $
                               UVALUE='pb_clear')    
       
       account_info_WidgetData={user:'',$
                                pswd:'',$
                                user_fld:user_fld, $
                                pswd_fld:pswd_fld}
       
       WIDGET_CONTROL, base, xoffset=300, yoffset=300, /REALIZE

       XMANAGER, 'hydra_get_remote_account_info', base, /MODAL
     
       url=frontpart + $
         account_info_WidgetData.user+':'+account_info_WidgetData.pswd + $
         backpart
       
   endif else begin
     print,'% hydra_get_remote_account_info: No user needed'
   endelse  
   
 END  
 
;******************************************************************************
;* PROCEDURE:
;*      PRO hydra_get_remote_account_info_event
;* 
;* DESCRIPTION:  
;*      Event handler for hydra_get_remote_account_info
;*
;* INPUTS:       
;*      event    Event
;*
;* KEYWORDS:
;* 	none
;*
;* MODIFICATION HISTORY:       
;*     October 1997, Reiner Friedel
;******************************************************************************
PRO hydra_get_remote_account_info_event, event
  
  COMMON hydra_remote_account_info, account_info_WidgetData
  
  WIDGET_CONTROL, event.id, GET_UVAL=uval

  CASE uval OF
    
    'pb_cancel': BEGIN
      WIDGET_CONTROL, event.top, /DESTROY      
    END
    
    'pb_enter': BEGIN
      WIDGET_CONTROL,account_info_WidgetData.user_fld,GET_VALUE=getuser
      account_info_WidgetData.user=getuser(0)
      WIDGET_CONTROL, event.top, /DESTROY  
    END 
    
    'pb_clear': BEGIN
      account_info_WidgetData.pswd=''
      WIDGET_CONTROL,account_info_WidgetData.pswd_fld,SET_VALUE=''
    END 
    
    'pswd_fld': BEGIN
      WIDGET_CONTROL,account_info_WidgetData.pswd_fld,GET_VALUE=getpswd
      len=strlen(getpswd(0))
      newchar=strmid(getpswd(0),0,1)
      account_info_WidgetData.pswd=account_info_WidgetData.pswd+newchar
      hide_user='' & star='*'
      for i=0,strlen(account_info_WidgetData.pswd)-1 do $
        hide_user=hide_user+star
      WIDGET_CONTROL,account_info_WidgetData.pswd_fld,SET_VALUE=hide_user
    END  
    
    ELSE: PRINT, '%hydra_get_remote_account_info_event: Event not handled.'
    
  ENDCASE
  
END   
   
function wget_available
   wget= getenv('wget_exe')
   spawn, wget+' --help', result
   avail=0
   if n_elements( result ) gt 0 then begin
       r= where( strpos( result, 'GNU' )  ne -1 )
       if r(0) ne -1 then begin
           avail=1 
       endif
   endif
   return, avail
end

function can_write, dir=dir, file=file
   if n_elements( dir ) eq 0 then dir=''
   if n_elements( file ) eq 0 then begin
       file= 'cw'+strtrim(fix(randomu(s)*1000),2)+'.zzz'
       delete=1
       append=0
   endif else begin
       if (findfile( dir+file ))(0) ne '' then begin
           delete=0
           append=1
       endif else begin
           delete=1
           append=0
       endelse
   endelse
   openw, unit, err=err, dir+file, delete=delete, append=append, /get_lun
   if err eq 0 then begin
       close, unit
       return, 1
   endif else begin
       return, 0
   endelse
end

pro wget_start, site, wget_data, output=output, log=log
   verbose= ( getenv('hydra_retrieve_verbose') ne '' )

   wget= getenv('wget_exe')
   
   if keyword_set( output ) then scratch= " -O "+output+' ' else begin
       output=''
       scratch=' '
   endelse
   if keyword_set( log ) then log= log else log='/dev/null'

   wget='wget'
   
   exestr= wget+' -o '+log+' '+scratch+'"'+site+'"'+'&'
   if verbose then message, exestr, /cont

   spawn, exestr, pid=ppid
   
   wait, .1

   spawn, 'ps -p '+strtrim(ppid+1,2)+' -o pid -o comm', result
   if n_elements( result ) lt 2 then pid=-999 else begin
       s=str_sep(result(1),' ')
       r= where( s ne '' )
       s=s(r)
       if strpos( s(1), 'wget' ) eq -1 then begin
           pid=-999
       endif else begin
           pid=long(s(0))
       endelse
   endelse

   wget_data= { $
                pid:pid, $
                log:log, $
                output:output, $
                line_offset:1 $                
              }
end

function process_running, pid
   exestr= 'ps -p '+strtrim(pid,2)+' -o time | tail +2'
   spawn, exestr, result
   return, result ne ''
end

pro wget_status, wget_data, bytesRead=bytesRead, length=length, done=done
;  parses wget log file to retrieve file information
   openr, unit, wget_data.log, /get_lun, err=err
   if err ne 0 then begin
       bytesRead=0
       done=0
       return
   endif

   bytesRead= 0L
   BytesReadId='K -> '
   LengthID='Length:'

   done=0

   dummystr=''   
   while not eof(unit) do begin
       readf, unit, dummystr
       if strpos( dummystr, bytesreadid ) ne -1 then begin
           bytes= strtrim(dummystr,1)
           bytes = str_sep(bytes,' ')
           for j=2, n_elements(bytes)-1 do begin
               bytesread = bytesread + 1024 * strlen(bytes(j))
           endfor
       endif else if strpos( dummystr, 'saved' ) gt -1 then begin
           done=1
       endif else if strpos( dummystr, 'Length:' ) gt -1 then begin           
           p1= str_sep( dummystr, ' ' )
           r= where( p1 ne '' )
           p1= p1(r)
           n1= strmid( p1(1), 0, 1 )
           if strpos( '1234567890', n1 ) ne -1 then length=long(p1(1)) 
       endif
   endwhile
   close, unit
   free_lun, unit
end

function hydra_retrieve, date, $
                         survey=survey, $
                         level1=level1, $
                         ddcal=ddcal, $
                         errmsg=errmsg, $
                         verbose=verbose, $
                         version=version

; argument preprocessing
   date= strtrim(date,2)
   verbose= keyword_set( verbose ) or $
     ( getenv( 'hydra_retrieve_verbose' ) ne '' )
   
; common data
   common hydra_retrieve_common, name_queue
   common papco_color_names, black, red, green, yellow, blue, magenta, cyan, $
     white, burgundy, olive, dark_green, teal, $
     royal_blue, violet, dark_grey, grey, foreground1, background1 
   if n_elements( red ) eq 0 then red= !p.color

; retrieves specified data for specified day hydra data site.
;
   archive= getenv('HYDRA_WEB_ARCHIVE')
   wget= getenv('wget_exe')
   swytch= getenv('HYDRA_REMOTE_RETRIEVE')

   errmsg='Unidentified Error.'

   if wget eq '' then begin
       errmsg='environment variable wget_exe not set.'
       if verbose then message, errmsg, /cont
       return, ''
   endif
   
   if wget eq '0' then begin
       message, 'wget turned off via wget_exe=0', /cont
       if verbose then message, errmsg, /cont
       return, ''
   endif

   if archive eq '' then begin
       errmsg='environment variable HYDRA_WEB_ARCHIVE not set.'
       if verbose then message, errmsg, /cont
       return, ''
   endif

   if strtrim(swytch,2) eq '0' then begin
       errmsg='remote retrieval turned off via HYDRA_REMOTE_RETRIEVE'
       if verbose then message, errmsg, /cont
       return, ''
   endif

   if not wget_available() then begin
       message, 'wget apparently not available.', /cont
       return, ''
   endif
   
   case 1 of
       keyword_set( survey ): begin
           type= 'survey'
           install= getenv('HYDRA_SURVEY_DATA_PATH')
       end
       keyword_set( level1 ): begin
           type= 'level1'
           install= getenv('HYDRA_LEVEL1_DATA_PATH')
       end
       keyword_set( ddcal ): begin
           type= 'ddcal'
           install= getenv('HYDRA_LEVEL1CAL_DATA_PATH')
           if install eq '' then install= getenv('HYDRA_LEVEL1_DATA_PATH')
       end
   endcase

   if verbose then message, 'envvar path: '+install, /cont

;  get a directory from PATH envar.
   if !version.os_family eq 'unix' then begin
       path_sep=':'   
       dir_sep='/'
   endif else begin
       path_sep=';'
       dir_sep='\'              ;'
   endelse
   if strpos( install, path_sep ) ne -1 then begin
       s= str_sep( install, path_sep )
       install=s(n_elements(s)-1) ; takes the last one
   endif
   
   if strmid( install, strlen(install)-1, 1 ) ne dir_sep then $
     install= install+dir_sep
   
   f= findfile( strmid( install, 0, strlen(install)-1 ) )
   if n_elements(f) eq 0 then begin
       errmsg= 'directory not found'
       message, errmsg, /cont
       return, ''
   endif else begin
       n= strlen( install )
       r= where( strpos( f, ':' ) eq n-1 ) ; these are the directories
       if r(0) ne -1 then begin
           dir= strtrim(f(r(n_elements(r)-1)),2) 
           install= strmid( dir, 0, n-1 ) ; remove the :
           install= install+'/' ; takes the last wildcard.
       endif                    
       message, 'Writing downloaded file to '+install, /cont
   endelse

   if not can_write( dir=install ) then begin
       message, 'No write access to '+install, /cont
       return, ''
   endif 

   if strpos( archive, 'user:password' ) ne -1 then begin
       hydra_get_remote_account_info, archive
   endif

   if verbose then message, archive, /cont
   
;  query hydra for existence of file.  Get name, vers and size of file
   exestr= wget+' -T20 -O - "'+archive+'query_data.cgi?'+date+'&'+type+'"'
   if verbose then message, exestr, /cont
   message, 'querying Hydra data server...', /cont
   spawn, exestr, result
   if verbose then $
     for i=0,n_elements(result)-1 do message, result(i), /cont

   if result(0) eq '' then begin
       message, 'No response from archive.  Check address.', /cont
       errmsg='No response from archive.'
       return, ''
   endif

   message= result(1:*)

;  parse returned message.
   s= str_sep( result(0), ' ' )
   r= where( s ne '' )
   if r(0) ne -1 then s=s(r)

   r= where( s eq 'Found:' )
   if r(0) eq -1 then begin
       errmsg= 'File not found at Hydra'
       name=''
       size=0
   endif else begin
       name= s(r(0)+1)
       r= where( s eq 'Size:' )
       size= long( s(r(0)+1) ) * 512 / 1000 ; in KBytes
       r= strpos( name, '_v' )
       vers= float( strmid( name, r(0)+2, 4 ) )
   endelse

;  report this to user.

   oldwin= !d.window

   base= widget_base( Title='HYDRA Data Retrieve', /column )

   text= strarr(4)
   n= n_elements(message)<3 
   text(0:(n-1))= message
   if name ne '' then $
     text(3)= 'Output: '+install+name

   textID= widget_text( base, $
                        value= message, $
                        ysize=4, xsize=4, scr_xsize=200, /scroll )

   b2= widget_base( base )
   r= widget_label( b2, value='Queue: ' )
   bar1ID= widget_draw( b2, $
                        xoffset=45, yoffset=8, $
                        scr_xsize=200, scr_ysize=5 )
   
   b2= widget_base( base )   
   r= widget_label( b2, value='File: ' )
   bar2ID= widget_draw( b2, $
                        xoffset=45, yoffset=8, $
                        scr_xsize=200, scr_ysize=5 )
   
   list = [ strtrim( date,2 ) + ' ' + type ]
   if n_elements( name_queue ) gt 0 then begin
       list = [ list, $
                strtrim( name_queue.date, 2 ) + ' ' + $
                strtrim(name_queue.type) ] 
   endif 
   s= sort( list )
   u= uniq( list, s )
   list= list( u )


   queueID= widget_droplist( base, $
                             value= list, scr_xsize=100 )
   
   buttstr= [ 'Get It', 'Skip', 'Postpone', 'Get Postponed', 'Cancel' ]
   if name eq '' then begin
       buttstr(4)='Okay'
       sens=[ 0,0,0,0,1 ]
   endif else begin
       sens=[ 1,1,1,1,1 ]
       if n_elements( name_queue ) eq 0 then sens(3)=0 ;Get postponed
   endelse
   b= cw_bgroup( base, row=2, $
                 buttstr, $
                 ids= buttID, $
                 /return_name, xpad=0, space=0 )
   for i=0,n_elements(sens)-1 do widget_control, buttID(i), sens=sens(i)
   cancelID= buttID(4)
   
   widget_control, base, xoffset=300, yoffset=300, /realize
   widget_control, bar1ID, get_value=bar1win

   wset, bar1win 
   plot, [0,1],[0,1], /nodata, xstyle=5, ystyle=5, position=[0,0,1,1] 
   widget_control, bar2ID, get_value=bar2win
   wset, bar2win
   plot, [0,1],[0,1], /nodata, xstyle=5, ystyle=5, position=[0,0,1,1]

   widget_control, base, timer=.5

   exit=0
   downloading=0
   downloadqueue=0

   repeat begin
       event= widget_event( base )
       case tag_names( event, /structure_name ) of 
           'WIDGET_TIMER': begin
               if downloadqueue and not downloading then begin
                   dequeued= dequeued+1
                   pop= name_queue(0)
                   if n_elements( name_queue ) gt 1 then begin
                       name_queue= name_queue(1:*)
                   endif else begin
                       r= temporary( name_queue )
                       downloadqueue=0
                   endelse
                   if n_elements( name_queue ) gt 0 then begin
                       list = [ strtrim( name_queue.date, 2 ) + ' ' + $
                                strtrim(name_queue.type) ] 
                       widget_control, queueID, set_value=list
                   endif 

                   rfile= archive+'retrieve_data.cgi?'+pop.date+'&'+pop.type
                   ustr= strtrim(long( systime(1)*1000 mod 10000 ),2)
                   output= pop.install+'/received'+ustr+'.gz'
                   log= pop.install+'/wget'+ustr+'.log'
                   if not can_write( file=log ) then begin
                       errmsg= 'Can''t write to '+log+'.'
                       message, errmsg, /cont                           
                       widget_control, base, /destroy
                       wset, oldwin
                       return, ''
                   endif
                   if not can_write( file=output ) then begin
                       errmsg='Can''t write to '+output+'.'
                       message, errmsg, /cont                           
                       widget_control, base, /destroy
                       wset, oldwin
                       return, ''
                   endif
                   size= pop.size
                   text(0)= 'File: '+pop.name
                   text(1)= 'Size: '+strtrim(pop.size,2)
                   wget_start, rfile, wget_data, output=output, log=log
                   wset, bar2win & erase                   
                   downloading=1
               endif
               if downloading eq 1 then begin
                   wget_status, wget_data, bytesread=bytesread, done=done
                   text(2)= 'Received '+$
                     strtrim(long(bytesread/1000),2) + $
                     ' KBytes'
                   widget_control, textID, set_value=text
                   wset, bar2win
                   f= float( bytesread / 1000 ) / size
                   polyfill, [0,1,1,0,0]*f, [0,0,1,1,0], color=red
                   wset, bar1win                   
                   fq= float( dequeued+f ) / queue0 
                   polyfill, [0,1,1,0,0]*fq, [0,0,1,1,0], color=red
                   if done then begin
                       text(3)='Decompressing...'
                       widget_control, textID, set_value=text
                       spawn, 'gunzip -N -f '+wget_data.output
                       spawn, 'rm -f '+wget_data.log
                       text(3)=''
                       downloading=0
                   endif
               endif
               widget_control, base, timer=0.5
           end
           '': begin            ; button
               if event.value eq 'Okay' then event.value='Cancel'
               case event.value of
                   'Get It': begin
                       rfile= archive+'retrieve_data.cgi?'+date+'&'+type
                       ustr= strtrim(long( systime(1)*1000 mod 10000 ),2)
                       output= install+'/received'+ustr+'.gz'
                       log= install+'/wget'+ustr+'.log'
                       if not can_write( file=log ) then begin
                           errmsg= 'Can''t write to '+log+'.'
                           message, errmsg, /cont                           
                           widget_control, base, /destroy
                           wset, oldwin
                           return, ''
                       endif
                       if not can_write( file=output ) then begin
                           errmsg='Can''t write to '+output+'.'
                           message, errmsg, /cont                           
                           widget_control, base, /destroy
                           wset, oldwin
                           return, ''
                       endif             
                       wget_start, rfile, wget_data, output=output, log=log
                       wset, bar2win & erase
                       downloading=1
                       dequeued=0
                       queue0=1
                       exit=1
                       for i=0,n_elements(buttID)-1 do $
                         widget_control, buttID(i), sens=0
                       widget_control, cancelID, sens=1
                   end
                   'Skip': begin
                       errmsg='User Skip'
                       name=''
                       exit=1
                   end
                   'Postpone': begin
                       errmsg='Retrieve Postponed'
                       st= { named, date:date, type:type, $
                             name:name, size:size, install:install }
                       if n_elements( name_queue ) eq 0 then begin
                           name_queue= [ st ]
                           name=''
                           exit=1
                       endif else if n_elements( name_queue ) lt 10 then begin
                           name_queue= [ name_queue, st ]
                           name=''
                           exit=1
                       endif else begin
                           message, 'Queue is full.', /cont
                           widget_control, textID, $
                             set_value=[ 'Queue is full.  Queue length', $
                                         'is limited to ten requests.' ]
                       endelse
                   end
                   'Get Postponed': begin
                       st= { named, date:date, type:type, $
                             name:name, size:size, install:install }
                       name_queue= [ name_queue, st ]
                       sstr= name_queue.date+' '+name_queue.type
                       s= sort( sstr )
                       u= uniq( sstr, s )
                       name_queue= name_queue( u )
                       downloadqueue=1
                       queue0= n_elements( name_queue )
                       dequeued= -1
                       exit=1
                       for i=0,n_elements(buttID)-1 do $
                         widget_control, buttID(i), sens=0
                       widget_control, cancelID, sens=1
                   end
                   'Cancel': begin
                       if downloading then begin
                           if wget_data.pid gt 0 then begin
;                               spawn, 'ps -p '+string(wget_data.pid)
                               spawn, 'kill -9 '+string(wget_data.pid)
                           endif
                           spawn, 'rm -f '+wget_data.output
                           spawn, 'rm -f '+wget_data.log
                       endif
                       downloading=0
                       downloadqueue=0
                       exit=1
                       name=''
                       errmsg='User Cancel'
                   end
               endcase
           end
           'WIDGET_DROPLIST':
       endcase
   endrep until exit eq 1 and ( downloading+downloadqueue) eq 0

   if name ne '' then begin
       f= findfile( install+name )
       name= f(0)
       if name eq '' then $
         errmsg='Downloaded file not found.'
   endif
   
   widget_control, base, /destroy

   wset, oldwin
   return, name
end



