pro hydra_ylim, yray_in,yst,yen,ylog,smart=smart,_extra=e

; smart: takes the median 99% of the data to set bottom and top bounds,
; else:
; then these bounds are expanded an additional 10% for linear...
;
; For logarythmic:
;    range is enough cycles to cover data
;    if data fits within a cycle, then switch ylog to linear.
; 
; if e.minvalue is set then it is used as the minimum.  This will be
; used for positive definate data, and where 0 should always be the minimum.
;
; ylog parameter passes back what ylog has been reset to.

  yray= yray_in

  if n_elements( e ) gt 0 then begin
      t= tag_names(e)
      if (where(t eq 'MIN_VALUE'))(0) ne -1 then minvalue=e.min_value
      if (where(t eq 'YLOG'))(0) ne -1 then ylog=e.ylog
  endif

  r= where( yray gt 1e-31 and yray lt 1e30 )
  if r(0) ne -1 then yray= yray(r)

  ord=sort(yray)
  n=n_elements(ord)

  redo:
  if keyword_set(smart) then begin
      yst=yray(ord(n/200))
      yen=yray(ord(long((n-1)-(n/200.)+0.5)))
  endif else begin
      yst=yray(ord(0))
      yen=yray(ord(n-1))
  endelse

  if keyword_set(ylog) then begin 
      yst=10.^floor(alog10(yst))
      yen=10.^ceil( alog10(yen))
      if yen/yst eq 10. then begin 
          print, 'Only one cycle, plotting linear instead of logarytmic'
          e.ylog=0              ; turn off log if only once cycle
          ylog=0
          minvalue=0.0
          goto, redo
      endif
  endif

  yrange=abs(yen-yst)
  if not keyword_set(ylog) then begin
      yst=yst-yrange*0.1
;      if n_elements(minvalue) gt 0 then yst=e.min_value
      if n_elements(minvalue) gt 0 then yst=minvalue
      yen=yen+yrange*0.1
  endif else begin
      yst=yst*0.9
      yen=yen*1.1
  endelse
end




