pro test_it, ylog=ylog
   data= randomn(s,1000)
   erase
   if keyword_set(ylog) then begin
       e= { ylog:1 } 
       data= 10^data
   endif else begin
       e= { ylog:0 } 
   endelse

   for i=-1,-4,-1 do begin       
       if keyword_set(ylog) then begin
           e= { ylog:1 } 
       endif else begin
           e= { ylog:0 } 
       endelse

       print, 2.^(i+1)*0.8, 2.^(i)*0.8+2.^(i+1)*0.8
       !p.position= [ 0.2, 2.^(i)*0.95 +0.03, $
                      0.9, 2.^(i+1)*0.95 ]
       e= hydra_ytick_parm( data, _extra=e )
       help, /str, e
       plot, data, /noerase, _extra=e       
   endfor
end

function hydra_ytick_parm, ydata_in, panel=panel_in, $
                           yrange=yrange, $
                           ylog=ylog, $
                           yticks=yticks, $
                           fill=fill, $
                           options=options, $ ; see hydra_ylim_widget.pro
                           _extra=e

;  sets plot parameter keywords for the yaxis so that
;  things look nice.  The keywords are returned in a
;  structure that should be passed into plot via the
;  _extra convention.
;  The following keywords will be specified:
;     ylog, yrange, yticks
;  These may be specified:
;     ytickname
;
;  ylog logic:
;     Whether to use ylog or not may be specified in two places:
;     On the panel, or in the code (passed in to here via keyword).
;     The logic is:
;        code_specifies   manual_button_out -->  code specifies
;        code_specifies   manual_button_in  -->  panel specifies
;        code doesn't specify ---------------->  panel specifies

   common yscale, yscl
   if n_elements( yscl ) eq 0 then yscl=intarr(1,4)
   if n_elements( panel_in ) eq 0 then panel=0 else panel=panel_in(0)
   if n_elements( options ) eq 0 then ylim_options=0 else ylim_options=options

   center_zero = ( 1 and ylim_options ) eq 1
   include_zero = ( 2 and ylim_options ) eq 2
   multicycle_log_only = ( 4 and ylim_options ) eq 4
   smart= ( 8 and ylim_options ) eq 8 

; --- clean up ydata in ---------
   ydata= double(ydata_in)
   r= where( ydata ne !values.d_infinity )
   if r(0) ne -1 then begin 
       ydata= ydata(r)
   endif else begin
       message, 'all values are Inf.', /cont
       return, e
   endelse
      
; --- ylog logic ----------------
   manual= yscl(panel,0) eq 1
   ylog_panel= yscl(panel,3)
   if n_elements(ylog) eq 0 then begin
       ylog= ylog_panel
   endif else begin
       if manual then ylog= ylog_panel
   endelse
   yscl(panel,3)=ylog

   y_kw= { ylog:ylog }

; --- yrange logic --------------
   yrange_panel= reform( yscl(panel,[1,2]) )
   if manual then begin
       yrange= yrange_panel
   endif else begin
       if n_elements( yrange ) eq 0 then begin
           if n_elements(fill) eq 0 then r= lindgen(n_elements(ydata)) else $
             r= where( ydata ne fill )
           
           if r(0) eq -1 then begin ; clumbsy code, sorry
               ydata_test= ydata
           endif else begin
               ydata_test= ydata(r)
               if ylog then begin
                   r= where( ydata_test gt 0. )
               endif else begin
                   r= lindgen( n_elements( ydata_test ) ) 
               endelse
           endelse

           if r(0) ne -1 then begin
               ydata_test= ydata_test(r)
               if smart then begin
;                  require 11 adjacent measurements to stat. agree
                   a= smooth(ydata_test,11) ; "average"
                   v= smooth((ydata_test-a)^2,11) ; "variance"
                   r= where( (ydata_test-a)^2 lt v*3^2 ) ; lt 5 sd's away
                   ydata_test= ydata_test(r)
               endif
               ymin= min( ydata_test, max=ymax ) 
               yrange= [ymin,ymax]
               if ylog then yrange= $
                 double(10)^[floor(alog10(yrange(0))), ceil(alog10(yrange(1)))]
           endif else begin
               if ylog then yrange=[1,10] else yrange=[0,1]
           endelse
       endif
       yscl(panel,1:2)=yrange
   endelse

   if not ylog then begin
       if center_zero then begin 
           ma= max(abs(yrange))
           yrange=[-ma,ma]
       endif
       if include_zero then begin
           yrange= [ yrange(0)<0., yrange(1)>0. ]
       endif
   endif   
   
   y_kw= create_struct( y_kw, { yrange:yrange } )


; --- yticks logic --------------
;  number of ticks depends on panel height.  Measure the panel height
;  by testing !p.position, convert to charsize heights, then decide
;  based on that.
   if n_elements( yticks ) eq 0 then begin
       nheight= !p.position(3)-!p.position(1) ; height in normal coord
       if !p.charsize eq 0 then charsize=1 else charsize=!p.charsize
       cheight= nheight * !d.x_size / ( !d.x_ch_size * charsize )
       if cheight lt 12 then yticks=fix(cheight/1.5+0.5) else yticks=0
;       yticks=0
   endif

; --- ytickv --------------------
; wow--this is getting complex, huh?  A new problem arises when we
; specify yticks--IDL places them without regard to the value of the
; tick, so unless yrange is carefully picked, then non-integral tickv's
; are used.  We need to specify tickv as well.
   if ylog then begin
       yr= alog10( yrange ) 
       if yrange(0) le 0 then yr(0)=-31
       if yrange(1) le 0 then yr(1)=-30
   endif else yr=yrange
   if yr(1) eq yr(0) then yr(1)=yr(0)+1 ; more conditioning
   if yticks gt 0 then begin
       yticks_max= yticks 
       mant= double([ 1,2,5,10,20,50,100,200,500 ]) ;redundancy intentional
       minor=       [ 10,4,5,10,4,5,10,4,5,10,4,5 ]
       exp=1 
       pick=-1
       repeat begin
           if getenv( 'hydra_verbose' ) ne '' then $
             help, mant, exp
           units= mant * double(10)^exp
           r= where( (yr(1)-yr(0)) / units lt yticks_max, count )
           if count eq 0 then begin
               exp= exp+1
               if exp eq -1 and ylog then pick=0
           endif else if count eq n_elements( mant ) then begin
               exp=exp-1 
           endif else begin
               pick= r(0)
           endelse
       endrep until pick gt -1
       units= units(pick)
       yminor= minor(pick)
       ytick0= units*ceil(yr(0)/units)
       yticks= fix((yr(1)-yr(0)) / units)
       if yticks le 1 then begin ; only gonna print two ticks, make them nice
           if not ylog then begin
               exp= double(10)^floor(alog10(max(abs(yr))))
               yr= exp*[floor(yr(0)/exp),ceil(yr(1)/exp)]
               y_kw.yrange= yr
               yminor= (yr(1)-yr(0))/exp
           endif
           ytickv= yr
           yticks= 1
           if ylog then begin
               ytickv(0)= ceil(ytickv(0))
               ytickv(1)= floor(ytickv(1))
           endif
       endif else begin           
           ytickv= ytick0 + dindgen(yticks+1) * units
       endelse
       r= where( ytickv ge yr(0) and ytickv le yr(1), count )
       if r(0) eq -1 then begin
           yticks=0             ; major problem -- give up!!!
           yminor=0
           ytickv=0
       endif else begin
           ytickv=ytickv(r)
           yticks=count-1
       endelse
       if ylog then begin
           if units gt 1 then begin
               yminor=units 
               ytickv=10^ytickv
           endif else begin
               yticks=0         ; don't touch a thing!
               yminor=0
               ytickv=0
           endelse
       endif
       y_kw= create_struct( y_kw, $
                            { yticks:yticks, ytickv:ytickv, yminor:yminor } )
   endif else begin
       y_kw= create_struct( y_kw, { yticks:yticks } )
   endelse

; --- pass other keywords ------
   if n_elements( e ) gt 0 then y_kw= create_struct( y_kw, e )

   return, y_kw
end
