pro l1_mfe_get_status, cdfcal, rec_start, rec_count, $
                       sensor, range, flipper, itime

   cdf_varget, cdfcal, 'MFE_STATUS', mfe_status, $
     rec_start=rec_start, rec_count= rec_count
   mfe_status= reform( mfe_status )

   flipper = (mfe_status AND 8) eq  8
   range = (mfe_status AND 4) eq 4 
   sensor = (mfe_status AND 2) eq 2

; load the times
   cdf_varget, cdfcal, 'BLOCK_TIME', rectimes, $
     rec_start=rec_start, rec_count=rec_count
   hr= long( rectimes mod 86400000 / 3600000. )
   mn= long( rectimes mod  3600000 /   60000. )
   sc= long( rectimes mod    60000 /    1000. )
   time= hr*10000L + mn*100L + sc ; HHMMSS

   idmode= sensor(*)*2 + range*6 + flipper*12
   u= where( (idmode(1:*)-idmode(0:*)) ne 0, n )
   if u(0) ne -1 then u=[0,u+1,n_elements(idmode)] else $
     u=[0,n_elements(idmode)]
   mode_start= u(0:(n_elements(u)-2))
   mode_count= u(1:*)-mode_start

   cdf_varget, CDFcal, 'MFE_OFFSET_START', mfe_offset_start
   cdf_varget, CDFcal, 'MFE_OFFSET_END', mfe_offset_end
   
   itime= intarr( n_elements( idmode ) )
   for imode= 0, n_elements(mode_start)-1 do begin
       i= mode_start(imode)
       rmode= mode_start(imode)+lindgen(mode_count(imode))
       mfe_time_start = $
         reform( mfe_offset_start(sensor(i),range(i),*) )
       mfe_time_end = $
         reform( mfe_offset_end(sensor(i),range(i),*) )
       
       time1= time(rmode)
       
       itime(rmode)= $
         ( time1 gt mfe_time_start(0) and time1 le mfe_time_end(0) ) * 1 + $
         ( time1 gt mfe_time_start(1) and time1 le mfe_time_end(1) ) * 2 + $
         ( time1 gt mfe_time_start(2) and time1 le mfe_time_end(2) ) * 3 + $
         ( time1 gt mfe_time_start(3) and time1 le mfe_time_end(3) ) * 4 
       
;       itime= (itime-1)>0
   endfor

end
