function polar_hydra_public, reset=reset

;  returns 1 if the system has only access to the public
;  hydra software.  
;
;  setenv, 'polar_hydra_public=[0|1]' can be used to override.
;


  common polar_hydra_public_common, is_public

  if keyword_set(reset) then begin
      r= temporary(is_public)
  endif

  if getenv('polar_hydra_public') ne '' then begin
      is_public= fix( getenv('polar_hydra_public') )
      return, is_public
  endif else begin
      
      if n_elements( is_public ) eq 0 then begin
          
          if !version.os_family eq 'Windows' then begin
              path_sep= ';'
          endif else begin
              path_sep= ':'
          endelse
          patharr= str_sep(!path,path_sep)
          patharr= ['.',patharr]
          
          fname='hyd_access'
          for i=0, n_elements( patharr )-1 do begin
              f= findfile( patharr(i)+'/'+fname+'.pro' )
              if f(0) ne ''  then begin
                  file=f 
              endif
          endfor
          
          if n_elements( file ) eq 0 then is_public=1 else is_public=0
          
      endif
  endelse

  return, is_public

end
  
  
