pro blank_part_of_xticks, xtickv, xtickname
n=n_elements(xtickname)
r=where(xtickv eq 0.)
if r[0] mod 2 eq 0 then begin
    xtickname[1+2*indgen(n/2)]=' '
endif else begin
    xtickname[2*indgen((n+1)/2)]=' '
endelse
print, 'Blanking alternate tick labels due to size issues.'
end


pro set_xticks, xdata, ydata, xtickv, xtickname, xticks, xminor, $
                xstyle=xstyle_in, xlog=xlog, position=position, $
                tight=tight, $
                _extra=e
;+
;
;   Set_xtick marks based on xdata.
; 
;   Arguments: 
;      Inputs: xdata, ydata
;   
;      Outputs: xtickv, xtickname, xticks, xminor
;
;   Keywords: xstyle, xlog, position
;             tight: Multiplier on average allowable length of a
;             numeric label. [Use this if the default is inadequate.]
;
;-
xstyle=4
if keyword_set(xstyle_in) then xstyle=xstyle or xstyle_in
if not keyword_set(xlog) then xlog=0
;
;    Find the xtickv values without plotting an axis
;
;
pmulti=!p.multi
plot, xdata, ydata, xstyle=xstyle, ystyle=4, $
  /nodata, xtick_get=xtickv, xlog=xlog, _extra=e
!p.multi=pmulti
if !p.multi[0] eq 0 then !p.multi[0]=!p.multi[1]*!p.multi[2]
;;
;; Format the idl-chosen ticks
;;
n=n_elements(xtickv)
xtickname=strarr(n)
for i=0,n-1 do begin
    if keyword_set(xlog) then begin
        if alog10(xtickv[i]) eq long(alog10(xtickv[i])) then begin
            xtickname[i]='!310!E'+strtrim(long(alog10(xtickv[i])),2)+'!N'
        endif else begin
            message, 'ERROR - Non-decade xlog value found:'+$
              strtrim(xtickv[i],2), /cont
            xtickname[i]=strtrim(xtickv[i],2)
        endelse
    endif else begin
        xtickname[i]=format_axis_values([xtickv[i]])
    endelse
endfor
xticks=n-1
if keyword_set(xlog) then begin
    xminor=9
endif else begin
    dv=xtickv[1]-xtickv[0]
    while dv ge 10.0 do dv=dv/10d0
    while dv lt 1.0 do dv=dv*10d0
    dvs=[1,2,5]
    minors=[9, 1, 4]
    r=where(dv eq dvs)
    if r[0] ne -1 then xminor=minors[r[0]] else xminor=1
endelse

if !d.name eq 'PS' then begin
    xsize=!d.x_size/1000.0/2.54 / float(!p.multi[2] > 1)
endif else begin
    xsize=!d.x_size/75.0/2.54 / float(!p.multi[2] > 1)
endelse
if total(!p.position) ne 0 or keyword_set(position) then begin
    if keyword_set(position) then begin
        xsize=xsize*(position[2]-position[0])
    endif else begin
        xsize=xsize*(!p.position[2]-!p.position[0])
    endelse
endif

length=0.30
if keyword_set(tight) then begin
    if tight eq 1 then length=length*2.0 else length=length*(tight)
endif

if n gt xsize/0.33 then begin
    blank_part_of_xticks, xtickv, xtickname
    if xminor eq 9 and not keyword_set(xlog) then xminor=4
endif

end






