pro blank_part_of_ticks, ytickv, ytickname
n=n_elements(ytickname)
r=where(ytickv eq 0.)
if r[0] mod 2 eq 0 then begin
    ytickname[1+2*indgen(n/2)]=' '
endif else begin
    ytickname[2*indgen((n+1)/2)]=' '
endelse
print, 'Blanking alternate tick labels due to size issues.'
end



pro set_yticks, xdata, ydata, ytickv, ytickname, yticks, yminor, $
                ystyle=ystyle_in, ylog=ylog, position=position, $
                _extra=e
;+
;
;   Set the ytick marks based on ydata.
;
;
;
;
;
;
;
;-
ystyle=4
if keyword_set(ystyle_in) then ystyle=ystyle or ystyle_in
if not keyword_set(ylog) then ylog=0
;
;    Find the ytickv values without plotting an axis
;
;
pmulti=!p.multi
plot, xdata, ydata, ystyle=ystyle, xstyle=4, $
  /nodata, ytick_get=ytickv, ylog=ylog, _extra=e
!p.multi=pmulti
if !p.multi[0] eq 0 then !p.multi[0]=!p.multi[1]*!p.multi[2]
;;
;; Format the idl-chosen ticks
;;
n=n_elements(ytickv)
ytickname=strarr(n)
for i=0,n-1 do begin
    if keyword_set(ylog) then begin
        if alog10(ytickv[i]) eq long(alog10(ytickv[i])) then begin
            ytickname[i]='!310!E'+strtrim(long(alog10(ytickv[i])),2)+'!N'
        endif else begin
            message, 'ERROR - Non-decade ylog value found:'+$
              strtrim(ytickv[i],2), /cont
            ytickname[i]=strtrim(ytickv[i],2)
        endelse
    endif else begin
        ytickname[i]=format_axis_values([ytickv[i]])
    endelse
endfor
yticks=n-1
if keyword_set(ylog) then begin
    yminor=9
endif else begin
    dv=ytickv[1]-ytickv[0]
    while dv ge 10.0 do dv=dv/10d0
    while dv lt 1.0 do dv=dv*10d0
    dvs=[1,2,5]
    minors=[9, 1, 4]
    r=where(dv eq dvs)
    if r[0] ne -1 then yminor=minors[r[0]] else yminor=1
endelse

if !d.name eq 'PS' then begin
    ysize=!d.y_size/1000.0/2.54 / float(!p.multi[2] > 1)
endif else begin
    ysize=!d.y_size/75.0/2.54 / float(!p.multi[2] > 1)
endelse
if total(!p.position) eq 0 and not keyword_set(position) then begin
    if ysize lt 1 then begin
        if n gt 4 then begin
            blank_part_of_ticks, ytickv, ytickname
        endif
        if yminor eq 9 and not keyword_set(ylog) then yminor=4
    endif else if ysize lt 2 then begin
        if n gt 5 then begin
            blank_part_of_ticks, ytickv, ytickname
        endif
        if yminor eq 9 and not keyword_set(ylog) then yminor=4
    endif
endif else begin
    if keyword_set(position) then begin
        ysize=ysize*(position[3]-position[1])
    endif else begin
        ysize=ysize*(!p.position[3]-!p.position[1])
    endelse
    ;;message, 'YSIZE='+strtrim(ysize,2), /cont
    if ysize lt 1. then begin
        if n gt 4 then begin
            blank_part_of_ticks, ytickv, ytickname
        endif
        if yminor eq 9 and not keyword_set(ylog) then yminor=4
    endif else if ysize lt 2. then begin
        if n gt 5 then begin
            blank_part_of_ticks, ytickv, ytickname
        endif
        if yminor eq 9 and not keyword_set(ylog) then yminor=4
    endif
endelse
end

